package gov.va.med.mhv.usermgmt.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;

@Path("/")
@Service("directMessageService")
public interface DirectMessageService {

	/**
	 * Execute the SaveDirectMessage service
	 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService#SaveDirectMessage()
	 */
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("directMessageService")
	Long saveDirectMessage(DirectMessageDTO directMessage);

	/**
	 * Execute the GetDirectMessagesByDirectMessageStatusAndUserProfileId service
	 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService#GetDirectMessagesByDirectMessageStatusAndUserProfileId()
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("directMessageService/{userProfileId}/{directMessageStatus}")
	List<DirectMessageDTO> getDirectMessagesByDirectMessageStatusAndUserProfileId(@PathParam("userProfileId") Long userProfileId, @PathParam("directMessageStatus")String directMessageStatus);

	/**
	 * Execute the GetDirectMessagesByUserProfileId service
	 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService#GetDirectMessagesByUserProfileId()
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("directMessageService/{userProfileId}")
	List<DirectMessageDTO> getDirectMessagesByUserProfileId(@PathParam("userProfileId") Long userProfileId);
	
	/**
	 * Execute the GetDirectMessagesSentTodayByUserProfileId service
	 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService#GetDirectMessagesSendTodayByUserProfileId()
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("directMessageService/today/{userProfileId}")
	List<DirectMessageDTO> getDirectMessagesSentTodayByUserProfileId(@PathParam("userProfileId") Long userProfileId);

	/**
	 * Gets the list of all direct messages for all users with the status provided. Called only by PatientServiceImpl.healthSummaryBatch.
	 * Do not expose as a web service.
	 * @param directMessageStatus The direct message status to query by.
	 * @return The direct messages matching the status provided as a parameter.
	 */
	List<DirectMessageDTO> getDirectMessagesByDirectMessageStatus(String directMessageStatus);

}