package gov.va.med.mhv.usermgmt.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.ActivitySearchCriteriaDTO;

@Service("accountActivityService")
public interface AccountActivityLogService extends AccountActivityCreatorService {
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/activity")
	public List<ActivityDTO> getAccountActvity(ActivitySearchCriteriaDTO activtySearchCriteria) throws MHVException;
	
	
	@POST
	@Path("/loginActivityFailed/{userProfileId}")
	@Consumes(MediaType.APPLICATION_JSON)
	public void createFailedLoginActivity(@PathParam("userProfileId") Long userProfileId) throws MHVException;


}
