package gov.va.med.mhv.usermgmt.messages;

import com.fortify.annotations.FortifyNotPassword;

public interface UserManagementMessages {

	public static final String FACILITY_NOT_FOUND = "facility.not.found.summary";
	public static final String USER_NOT_FOUND = "user.not.found.summary";
	public static final String INVALID_HINTS = "invalid.hints.summary";
	public static final String INVALID_SEARCH_FIELDS = "invalid.search.field.combo.summary";
	// public static final String INVALID_USER_ID = "invalid.userid";
	// public static final String CURRENT_AND_NEW_USER_NAMES_MUST_DIFFER = "current.and.new.user.names.must.differ";
	public static final String NO_USERS_FOUND = "no.users.found.summary";
	public static final @FortifyNotPassword String PASSWORD_NOT_CONFIRM = "password.not.confirm.summary";
	public static final String PATIENT_REGISTRY_ACCESS_ERROR = "ipa.patient.registry.access.error.summary";
	public static final String HINTS_MUST_DIFFER = "hints.must.differ.summary";
	public static final String SSN_REQUIRED_FOR_PATIENT = "ssn.required.for.patient.summary";
	public static final String INVALID_EMAIL = "invalid.email.address.summary";

	//CR2161 and CR2162 Kumar,Vyasa
	public static final String HINTS_ANSWER_REQUIRED = "password.hint.answer.required.summary";
	public static final String HINTS_ANSWER_MUST_DIFFER = "password.hint.answer.differ.summary";
	public static final String HINTS_ANSWER_ONE = "password.hint.answerone.summary";
	public static final String HINTS_ANSWER_TWO = "password.hint.answertwo.summary";
	//US8.15 & US7.15 - SSN is required if Relationship to VA is or has changed to Veteran and/or VA Patient.
	public static final String SSN_REQUIRED_FOR_VETERAN = "ssn.required.for.veteran.summary";

	public static final String MISSING_USER_TYPE = "user.profile.missing.user.type.summary";
	public static final String SUCCESSFUL_REGISTRATION = "user.successful.registration.summary";
	public static final String MUST_ACCEPT_TERMS = "user.must.accept.terms.summary";
	public static final String MUST_ACCEPT_PRIVACY = "user.must.accept.privacy.summary";
	public static final String MUST_ACCEPT_DISCLAIMER = "user.must.accept.disclaimer.summary";
	public static final String HEALTH_INTEREST_EMAIL_REQUIRED = "user.health.interest.email.required.summary";
	public static final String NOTIFICATIONS_EMAIL_REQUIRED = "user.notifications.email.required.summary";
	public static final String SSN_DOES_NOT_MATCH = "user.ssn.does.not.match.summary";
	public static final String EMAIL_DO_NOT_MATCH = "emails.not.confirm.summary";
	public static final String USER_ALREADY_IN_USE = "user.already.in.use.summary";
	public static final String TERMS_NOT_ACCEPTED = "not.accept.terms.summary";
	public static final String MVI_PARSE_RES_AE_ISSUE = "mvi.parse.response.ae.issue.summary";

	//US8.16 & US7.16 - Last name is not blank and contains no numbers.
	public static final String LAST_NAME_NUMBERS = "last.name.numbers.summary";
	public static final String FIRST_NAME_NUMBERS = "first.name.numbers.summary";

	// Address messages
	public static final String STATE_REQUIRED = "address.state.required.summary";
	public static final String COUNTRY_REQUIRED = "address.country.required.summary";
	public static final String PROVINCE_REQUIRED = "address.province.required.summary";
	public static final String INVALID_STATE = "address.state.invalid.summary";
	public static final String INVALID_COUNTRY = "address.country.invalid.summary";
	public static final String PROVINCE_OR_STATE = "address.province.or.state.summary";
	public static final String INVALID_BLOODTYPE = "bloodtype.invalid.summary";
	public static final String INVALID_SUFFIX = "suffix.invalid.summary";
	public static final String INVALID_MARITAL_STATUS = "maritalstatus.invalid.summary";
	public static final String INVALID_TITLE = "title.invalid.summary";
	public static final String INVALID_GENDER = "gender.invalid.summary";
	public static final String PASSQ1_REQUIRED = "passq1.required.summary";
	public static final String INVALID_PASSQ1 = "passq1.invalid.summary";
	public static final String PASSQ2_REQUIRED = "passq2.required.summary";
	public static final String INVALID_PASSQ2 = "passq2.invalid.summary";
	public static final String ALTR_STATE_REQUIRED = "altr.address.state.required.summary";
	public static final String INVALID_ALTR_STATE = "altr.address.state.invalid.summary";
	public static final String ADDRSTATE_REQUIRED = "addressstate.required.summary";
	public static final String INVALID_ADDRSTATE = "addressstate.invalid.summary";
	
	public static final String HINT_ANSWER_REQUIRED = "hint.answer.required";
	public static final String HINT_ANSWER_NO_MATCH = "hint.answer.no.match";
	
	// Contact info messages
	public static final String CONTACT_METHOD_NOT_SPECIFIED = "contact.method.not.specified.summary";

	public static final String LOGIN_FAILED = "user.login.failed";
	public static final String USER_ALREADY_EXISTS = "user.already.exists.summary";
	public static final String USER_DOES_NOT_EXIST = "user.does.not.exist.summary";
	public static final String UNKNOWN_EXCEPTION_OCCURRED = "unknown.exception.occurred.summary";
	public static final String INVALID_CREDENTIALS = "invalid.credentials.summary";
	public static final String ACCOUNT_LOCKED = "account.locked.summary";
	public static final String ACCOUNT_DEACTIVATED = "account.deactivated.summary";
	public static final @FortifyNotPassword String USERNAME_PASSWORD_REQUIRED = "username.password.required.summary";
	public static final String USERNAME_INVALID_LENGTH = "username.invalid.length.summary";
	public static final String USERNAME_NOT_ALPHANUMERIC = "username.not.alphanumeric.summary";
	public static final @FortifyNotPassword String USERNAME_PASSWORD_EQUAL = "user.name.password.equal.summary";
	public static final @FortifyNotPassword String PASSWORD_INVALID_LENGTH = "password.invalid.length.summary";
	public static final @FortifyNotPassword String PASSWORD_SPACES_NOT_ALLOWED = "password.spaces.not.allowed.summary";
	public static final @FortifyNotPassword String PASSWORD_NO_SPECIAL_CHAR = "password.no.special.char.summary";
	public static final @FortifyNotPassword String PASSWORD_NO_LETTER = "password.no.letter.summary";
	public static final @FortifyNotPassword String PASSWORD_NO_DIGIT = "password.no.digit.summary";
	public static final @FortifyNotPassword String CURRENT_PASSWORD_INVALID = "current.password.invalid.summary";
	public static final @FortifyNotPassword String CURRENT_PASSWORD_EXPIRED = "current.password.expired.summary";
	public static final @FortifyNotPassword String CURRENT_PASSWORD_TEMPORARY = "current.password.temporary.summary";
	public static final @FortifyNotPassword String PASSWORD_USED = "password.used.summary";
	public static final @FortifyNotPassword String PASSWORD_CHANGED = "password.changed.successfully.summary";

	public static final String BLUEBUTTON_INVALID_SEARCH_CRITERIA_1 = "user.invalid.search.criteria.dataclasses.1.summary";
	public static final String BLUEBUTTON_INVALID_SEARCH_CRITERIA_2 = "user.invalid.search.criteria.dataclasses.2.summary";

	
	// Geetha: Added
	public static final String INVALID_ZIP_CODE  = "invalid.zip.code.detail";
	
	public static final String INVALID_SSN  = "invalid.ssn.detail";
	public static final String INVALID_CONF_SSN  = "invalid.confssn.detail";
	
	public static final String SEARCH_NO_RESULTS = "employee.search.noresults.summary";
	public static final String SEARCH_FAILED = "employee.search.failed.summary";
	
	public static final String ACTIVITY_SEARCH_INVALID_RANGE="activity.invalid.date.range";
	
	public static final String ACTIVITY_SEARCH_FUTURE_RANGE = "invalid.future.from.date.range.summary";
	
	public static final String ACTIVITY_SEARCH_FROM_GREATER_TO = "error.from.greater.summary";

	
	
	
	public static final String MVI_IPA_CORRELATION_COMMUNICATION_ERROR = "mvi.ipa.correlation.communication.error.summary";
}
