package gov.va.med.mhv.usermgmt.filter;

import gov.va.med.mhv.common.api.service.SessionAPIService;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

import javax.annotation.Resource;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


///NEEDS TO BE REVIEWED FOR DESIGN

public class ApiAddAuthSessionServiceFilter implements ClientRequestFilter {
		private static Logger logger = LogManager.getLogger(ApiAddAuthSessionServiceFilter.class);
		
		private static final String API_TOKEN_KEY = "Token";
		private static final String API_EXPIRES_KEY = "Expires";
		
		private static final String API_SESSION_TOKEN_KEY = "APISessionToken";
		private static final String API_SESSION_EXP_KEY = "APISessionExpiration";
		private static final String RFC1123_PATTERN  = "EEE, dd MMM yyyy HH:mm:ss z";

		private static final String USER_NAME_KEY = "LIFERAY_SHARED_userid";
		
		@Context
	    org.apache.cxf.jaxrs.ext.MessageContext mc;

		@Resource
		private SessionAPIService sessionServiceProxy;
		
		public ApiAddAuthSessionServiceFilter() {
		}

		@Override
		public void filter(ClientRequestContext requestContext) throws IOException {
			Map<String,String> session = new Hashtable<String,String>();
			
			String token = (String)session.get(API_SESSION_TOKEN_KEY);
			String expires = (String)session.get(API_SESSION_EXP_KEY);

			Date expiresDt = null;

			if( expires != null ) {
				SimpleDateFormat sdf = new SimpleDateFormat(RFC1123_PATTERN);
				try {
					expiresDt = sdf.parse(expires);
				} catch (ParseException e1) {
					throw new IOException("API Session Expiration is invalid from http session");
				}
			}

			String currentUserName = (String) session.get(USER_NAME_KEY);
			boolean needsNewAPIToken = false;
			
			if( token == null || expiresDt == null) {
				needsNewAPIToken = true;
				if(logger.isDebugEnabled()) {
					logger.debug("The API Token for user " + currentUserName + " doesn't exist");
				}
			}
			
			if( !needsNewAPIToken && expiresDt != null && expiresDt.before(new Date()) ) {
				needsNewAPIToken = true;
				if(logger.isDebugEnabled()) {
					logger.debug("The API Token for user " + currentUserName + " expired");
				}
			}
			
			if( needsNewAPIToken ) {
				if(logger.isDebugEnabled()) {
					logger.debug("Fetching a new API Token for user "+currentUserName);
				}
				
				try {
					Response r = sessionServiceProxy.createSession();
					token = r.getHeaderString(API_TOKEN_KEY);
					expires = r.getHeaderString(API_EXPIRES_KEY);
					
					if(StringUtils.isEmpty(token) ||StringUtils.isEmpty(expires)) {
						throw new IOException("API Token response missing headers for 'Token' or 'Expires'");
					}
					
					session.put(API_SESSION_TOKEN_KEY,token);
					session.put(API_SESSION_EXP_KEY,expires);
				} catch (Exception e) {
					throw new IOException(e);
				}
			}
			
			requestContext.getHeaders().add(API_TOKEN_KEY, token);
		}

	}