package gov.va.med.mhv.usermgmt.filter;

import java.io.IOException;

import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * !!WARNING!!
 * 
 * THIS FILTER IS INTENDED TO BE USED BY THE SECURITY CREATION SERVICE PROXY. DO
 * NOT USE THIS FOR ANY OTHER SERVICES!
 *
 */
public class ApiAddAuthSessionAppFilter implements ClientRequestFilter {
	private static Logger logger = LogManager.getLogger(ApiAddAuthSessionAppFilter.class);

	private static final String API_APP_KEY = "appToken";
	private static final String API_MHV_CORRELATION_ID_KEY = "mhvCorrelationId";
	private static final String API_MHV_USERNAME_KEY = "mhvUsername";

	private static final String SESSION_MHV_CORRELATION_ID_KEY = "LIFERAY_SHARED_userprofileid";
	private static final String SESSION_USERNAME_KEY = "LIFERAY_SHARED_userid";

	// TODO:read application id from properties
	private static String APP_TOKEN = "MyHealth3Vet123";

	@Override
	public void filter(ClientRequestContext requestContext) throws IOException {
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			PortletSession session = request.getPortletSession();
			String mhvCorrelationId = String.valueOf(session.getAttribute(SESSION_MHV_CORRELATION_ID_KEY, PortletSession.APPLICATION_SCOPE));
			String mhvUsername = (String) session.getAttribute(SESSION_USERNAME_KEY, PortletSession.APPLICATION_SCOPE);

			if (mhvCorrelationId == null && mhvUsername == null) {
				IOException ioe = new IOException("Unable to get mhvCorrelationId or mhvUsername from session");
				logger.error(ioe);
				throw ioe;
			}

			if (logger.isDebugEnabled()) {
				if (mhvCorrelationId != null) {
					logger.debug("Adding '" + API_APP_KEY + "' and '" + API_MHV_CORRELATION_ID_KEY + "' to API Client Request for " + API_MHV_CORRELATION_ID_KEY
							+ " " + mhvCorrelationId);
				}

				if (mhvUsername != null) {
					logger.debug("Adding '" + API_APP_KEY + "' and '" + API_MHV_USERNAME_KEY + "' to API Client Request for " + API_MHV_USERNAME_KEY + " "
							+ mhvUsername);
				}
			}

			requestContext.getHeaders().add(API_APP_KEY, APP_TOKEN);
			requestContext.getHeaders().add(API_MHV_CORRELATION_ID_KEY, mhvCorrelationId);
			requestContext.getHeaders().add(API_MHV_USERNAME_KEY, mhvUsername);

		} catch (Exception e) {
			IOException ioe = new IOException("Unable to access client http session", e);
			logger.error(ioe);
			throw ioe;
		}

	}
}