/**
 * 
 */
package gov.va.med.mhv.usermgmt.common.enums;


/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public enum Indicator {

    Yes("Y"), No("N");

    public static boolean isYes(String value) {
        return equals(Yes, value);
    }
    public static boolean isNo(String value) {
        return equals(No, value);
    }

    public static Indicator find(String value) {
        return (isYes(value)) ? Yes : ((isNo(value)) ? No : null); 
    }
    
    public static boolean equals(Indicator indicator, String value) {
        return (indicator != null) && indicator.value.equalsIgnoreCase(value);
    }
    
    private final String value;
    
    private Indicator(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return value;
    }

}
