/**
 * 
 */
package gov.va.med.mhv.usermgmt.aal.client;

import java.util.List;

import javax.jms.JMSException;
import javax.jms.Message;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;

/**
 * @author DNS   egberb
 *
 */
public class JmsAccountActivityCreatorClient implements AccountActivityCreatorService {
	
	protected static final Logger LOGGER = LogManager.getLogger(JmsAccountActivityCreatorClient.class);
	
	private JmsTemplate jmsTemplate;

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService#createAccountActivityLog(gov.va.med.mhv.usermgmt.common.dto.ActivityDTO)
	 */
	@Override
	public void createAccountActivityLog(ActivityDTO activity) throws MHVException {
		
		try {
			
			this.jmsTemplate.convertAndSend(activity, new MessagePostProcessor() {
				
				@Override
				public Message postProcessMessage(Message message) throws JMSException {
					message.setStringProperty("JavaType", "ActivityDTO");
					return message;
				}
			});
		} catch ( Exception ex ) {
			String message = "Error sending ActivityDTO asynchronously.";
			LOGGER.error(message);
			throw new MHVException(message, ex);
		}
		
	}
	
	public void setJmsTemplate(JmsTemplate jmsTemplate) {
		this.jmsTemplate = jmsTemplate;
	}

//	@Override
//	public void createAccountActivityLogByList(List<ActivityDTO> activityDTO)
//			throws MHVException {
//		// TODO Auto-generated method stub
//		
//	}
	
	

}
