package gov.va.med.mhv.sm.web.controller;

import gov.va.med.mhv.sm.service.MHVSMBridgeService;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.UserTypeEnum;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.util.PropsUtil;


@ManagedBean(name="mhvsmBridgeController")
@Scope("request")
@Component
@PropertySources(value = {
		@PropertySource("classpath:/${MHV_ENV_PROPERTY}.sm.application.properties"),
		@PropertySource("classpath:/${MHV_ENV_PROPERTY}.sm.liferay.properties") })
public class MhvsmBridgeController implements Serializable {

	private static final long serialVersionUID = 243945029194034624L;

	private static Logger log = LogManager.getLogger(MhvsmBridgeController.class);

	private static final String ERR_PRCS_RQST = "Error Processing request";
	public static final String MISSING_CREDENTIALS = "missing.credentials";
	public static final String DATA_RETRIEVAL_FAILURE = "data.retrieval.failure";
	public static final String DATA_SECURITY_FAILURE = "data.security.failure";
	public static final String UNEXPECTED_ERROR = "unexpected.error.occurred";
	public static final String ORGANIZATIONS_MISCONFIGURED = "organizations.misconfigured";

	private static final String USERPROFILE_DTO_KEY = "LIFERAY_SHARED_userprofiledto";
	private static final String PATIENT_DTO_KEY = "LIFERAY_SHARED_patientdto";
	private static final String USER_ROLE_KEY = "LIFERAY_SHARED_accountType";

	UserProfileDTO userProfileDto = null;
	PatientDTO patientDto = null;

	Boolean isPremiumUser = null;

	private String authKey;
	private String userFirstName;
	private String userLastName;
	private String currentUserName;
	private String sessionId;

	@Autowired
	private ObjectMapper mapper;

	@Value("${sm.integration.mhv.url}")
	private String mhvUrl;

	@Value("${sm.integration.credentialsExpirationPeriod}")
	private long credentialsExpirationPeriod = 120;


	@Resource(name = "smServiceProxy")
	private MHVSMBridgeService mHVSMBridgeService;

	@Resource(name = "activityProxy")
	private AccountActivityCreatorService acctActCreatorService;

    // This method loads up when the SM tab loads up
	public void authorizeSMHome(ComponentSystemEvent event) throws IOException {
		if(log.isInfoEnabled()){
			log.info("=====authorizeSMHome()==========");
		}

		PortletSession session = null;

		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			FacesContext context = FacesContext.getCurrentInstance();

			if (request.getUserPrincipal() == null) {
				context.getApplication().getNavigationHandler().handleNavigation(context, null, "smNonIPAed.xhtml");
			} else {
				session = request.getPortletSession();
				sessionId = session.getId();
				setCurrentUserName(getCurrentUserName());

				if (log.isDebugEnabled()) {
					log.debug("user exists " + currentUserName);
				}
			}
		} catch (Exception e) {
			log.error("Error in authorizeSMHome", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}


	// Login action from smBridgeHome.xhtml
    public String smLogin() throws Exception {

		try {
			// AAL entry
			acctActCreatorService.createAccountActivityLog
			                  (ActivityHelper.createActivityDTOForSelf(this.getUserProfileDTOFromSession().getId(),
			                		  true,
			                		  ActivityTypeEnumeration.GOTOSM,
			                		  ActivityActionTypeEnumeration.NAVIGATE_TO_SECUREMESSAGING,
			                		  ""));

			long start = System.currentTimeMillis();
			if (log.isDebugEnabled()) {
				log.debug("===befere SM web service call === start " + start);
			}

			if (log.isDebugEnabled()) {
				log.debug("login user exists " + getCurrentUserName());
			}

			// Call Service method that calls SM server to retrieve the authentication key/token
			String key = mHVSMBridgeService.getAuthenticatePatient(getCurrentUserName());

			if (null != key) {
				setAuthKey(key);
				if (log.isDebugEnabled()) {
					log.debug("key : " + key);
				}
			}else{
				log.error("Could not retrieve the Authentication key from SM server");
				// TODO: Add the error message to the screen
			}

			long timeToGetAuthKeyFromSMServerInSeconds = (System.currentTimeMillis() - start)/1000;



			if (log.isDebugEnabled()) {
				log.debug("===End of MHV-SM Patient Authentication WS call=== elapsed time " + (System.currentTimeMillis() - start));
			}

			if ((getMhvUrl() == null) || (getAuthKey().isEmpty())) {
				return createFailureForward(null);
			}

			/*
			 *  If the time it took for the initial MHV to SM authentication call and key retrieval took more than 120 seconds (default)
			 *  or the value from the application property file, then load the same SM landing page with error.
			 */

			if(timeToGetAuthKeyFromSMServerInSeconds > this.getCredentialsExpirationPeriod()){
				return createFailureForward(null);
			}

			log.info(">>>>>> 1a - key Value is::"+getAuthKey());
			log.info("URL is::"+getMhvUrl()+ "?key=" + getAuthKey());

			/*
			 * Once we get authentication key from SM server, forward the request to SM loginIntegration along with the key
			 */
			FacesContext context = FacesContext.getCurrentInstance();
			context.getExternalContext().redirect(getMhvUrl()+ "?key=" + getAuthKey());

			return "smBridgeHome";

		} catch (Exception e) {
			log.error("Error in login", e);
			//TODO: Add the error message
			//FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			return "smBridgeHome";
		}
    }

	protected UserTypeEnum getUserRoleFromSession() throws MHVException {
		UserTypeEnum userRole;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();

			String userRoleStr =  (String)session.getAttribute(USER_ROLE_KEY, PortletSession.APPLICATION_SCOPE);
			userRole = UserTypeEnum.valueOfByRole(userRoleStr);
		} catch(Exception e) {
			throw new MHVException("Unable to get user role from session");
		}
		return userRole;
	}

	public Boolean getIsPremiumUser() throws MHVException {
		if (isPremiumUser == null) {
			isPremiumUser = new Boolean(UserTypeEnum.isPremium(getUserRoleFromSession()));
		}
		return isPremiumUser;
	}


	protected String createFailureForward(String message) {
		if (!StringUtils.isBlank(message)) {
			log.error(message);
    		addUnexpectedError(UNEXPECTED_ERROR, null);
    		//TODO: Add message to FacesContext
		}
		return "smBridgeHome";
	}

    protected URL createURL(String description, String url) {
    	try {
    		return new URL(url);
    	} catch (MalformedURLException e) {
    		log.error("Malformed url: " +  ". Provide the appropriate " +
    			description + " URL in the SM properties.");
    		//addErrorMessage("unexpected.error.occurred", null);
    		FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, UNEXPECTED_ERROR, UNEXPECTED_ERROR));
    		return null;
    	}
    }


	protected UserProfileDTO getUserProfileDTOFromSession() throws MHVException {
		UserProfileDTO userProfile;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			String userProfileStr = (String) session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfile = mapper.readValue(userProfileStr, UserProfileDTO.class);
		} catch (Exception e) {
			throw new MHVException("Unable to get UserProfileDTO from session");
		}
		return userProfile;
	}


	protected PatientDTO getPatientDTOFromSession() throws MHVException {
		PatientDTO patient;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();

			String patientStr = (String) session.getAttribute(PATIENT_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			patient = mapper.readValue(patientStr, PatientDTO.class);

		} catch (Exception e) {
			throw new MHVException("Unable to get PatientDTO from session");
		}
		return patient;
	}

	public String getMhvContext() {
		String context = PropsUtil.get("mhv.context");
		return context;
	}

	public String getCurrentUserName() {
		if (null == currentUserName) {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			PortletSession session = request.getPortletSession();
			currentUserName = (String) session.getAttribute("LIFERAY_SHARED_userid", PortletSession.APPLICATION_SCOPE);
		}
		return currentUserName;
	}

	protected void addUnexpectedError(String key) {
		addUnexpectedError(key, null);
    }

	protected void addUnexpectedError(String key, String[] inserts) {
		log.error("Unexpected error '" + key + "' occurred");
    	//addErrorMessage(UNEXPECTED_ERROR, inserts);
		FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, key, key));
    }

	public MHVSMBridgeService getMHVSMBridgeService() {
		return mHVSMBridgeService;
	}

	public void setMHVSMBridgeService(
			MHVSMBridgeService mHVSMBridgeService) {
		this.mHVSMBridgeService = mHVSMBridgeService;
	}

	public void setCurrentUserName(String currentUserName) {
		this.currentUserName = currentUserName;
	}

	public String getAuthKey() {
		return authKey;
	}

	public void setAuthKey(String authKey) {
		this.authKey = authKey;
	}

	public String getUserFirstName() {
		return userFirstName;
	}

	public void setUserFirstName(String userFirstName) {
		this.userFirstName = userFirstName;
	}

	public String getUserLastName() {
		return userLastName;
	}

	public void setUserLastName(String userLastName) {
		this.userLastName = userLastName;
	}

	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public String getMhvUrl() {
		return mhvUrl;
	}

	public void setMhvUrl(String mhvUrl) {
		this.mhvUrl = mhvUrl;
	}

	public long getCredentialsExpirationPeriod() {
		return credentialsExpirationPeriod;
	}

	public void setCredentialsExpirationPeriod(long credentialsExpirationPeriod) {
		this.credentialsExpirationPeriod = credentialsExpirationPeriod;
	}
}