package gov.va.med.mhv.sm.model;

import gov.va.med.mhv.core.crypto.MHVCipher;
//import gov.va.med.mhv.sm.util.Describeable;
//import gov.va.med.mhv.sm.util.DescriptionBuilder;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;


public class SecureMessagingSettings implements Serializable {

	private static final long serialVersionUID = 7319401544459178014L;

	private String mhvUrl = null;
	private String adminUrl = null;
	private String seed = null;
	private String mhvSource = null;
	private String adminSource = null;
	private MHVCipher cipher = null;
	private String authenticationURL = null;
	private String authenticationUserName = null;
	private String authenticationPassword = null;
	private String authenticationKey = null;

	public String getAdminSource() {
		return adminSource;
	}
	public void setAdminSource(String adminSource) {
		this.adminSource = adminSource;
	}
	public String getAdminUrl() {
		return adminUrl;
	}
	public void setAdminUrl(String adminUrl) {
		this.adminUrl = adminUrl;
	}
	public String getMhvSource() {
		return mhvSource;
	}
	public void setMhvSource(String mhvSource) {
		this.mhvSource = mhvSource;
	}
	public String getMhvUrl() {
		return mhvUrl;
	}
	public void setMhvUrl(String mhvUrl) {
		this.mhvUrl = mhvUrl;
	}
	public String getSeed() {
		return seed;
	}
	public void setSeed(String seed) {
		this.seed = seed;
	}
	public MHVCipher getCipher() {
		return cipher;
	}
	public void setCipher(MHVCipher cipher) {
		this.cipher = cipher;
	}
	public String getAuthenticationURL() {
		return authenticationURL;
	}
	public void setAuthenticationURL(String authenticationURL) {
		this.authenticationURL = authenticationURL;
	}
	public String getAuthenticationPassword() {
		return authenticationPassword;
	}
	public void setAuthenticationPassword(String authenticationPassword) {
		this.authenticationPassword = authenticationPassword;
	}
	public String getAuthenticationUserName() {
		return authenticationUserName;
	}
	public void setAuthenticationUserName(String authenticationUser) {
		this.authenticationUserName = authenticationUser;
	}

	/*public void describe(DescriptionBuilder builder) {
		if (builder == null) {
			return;
		}
		builder.header(this);
		builder.openPropertyList();
		builder.appendProperty("mhvUrl", mhvUrl, true);
		builder.appendProperty("adminUrl", adminUrl);
		builder.appendProperty("seed", seed);
		builder.appendProperty("mhvSource", mhvSource);
		builder.appendProperty("adminSource", adminSource);
		builder.appendProperty("cipher", builder.header(cipher));
		builder.appendProperty("authenticationURL", authenticationURL);
		builder.appendProperty("authenticationUser", authenticationUserName);
		builder.appendProperty("authenticationPassword", mask(
			authenticationPassword));
		builder.appendProperty("authenticationKey", mask(authenticationKey));
		builder.closePropertyList();
	}*/
	public String getAuthenticationKey() {
		return authenticationKey;
	}
	public void setAuthenticationKey(String authenticationKey) {
		this.authenticationKey = authenticationKey;
	}

	private String mask(String value) {
		return (value != null) ? StringUtils.repeat("*", value.length()) : null;
	}
}
