package gov.va.med.mhv.sm.model;


import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;


public class PatientLoginInfo extends AbstractLoginInfo
	implements Serializable
{

	private static final long serialVersionUID = -2703401820290604702L;

	private static final String DATE_FORMAT = "MM/dd/yyyy"; 
	
	private String ssn;
	private Date dob = null;
	private String email="";
	private String icn="";
	private Boolean tcAccepted=false;
	private Timestamp tcAcceptedTimeStamp=null;

	public String getDobAsString() {
		return new SimpleDateFormat(DATE_FORMAT).format(dob);
	}
	public Date getDob() {
		return dob;
	}
	public void setDob(Date dob) {
		this.dob = dob;
	}

	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}

	public String getIcn() {
		return icn;
	}
	public void setIcn(String icn) {
		this.icn = icn;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public Boolean getTcAccepted() {
		return tcAccepted;
	}

	public void setTcAccepted(Boolean tcAccepted) {
		this.tcAccepted = tcAccepted;
	}

	public Timestamp getTcAcceptedTimeStamp() {
		return tcAcceptedTimeStamp;
	}

	public void setTcAcceptedTimeStamp(Timestamp tcAcceptedTimeStamp) {
		this.tcAcceptedTimeStamp = tcAcceptedTimeStamp;
	}

}
