package gov.va.med.mhv.sm.doa;

//import gov.va.med.mhv.sm.util.DescriptionBuilder;
////import gov.va.med.mhv.sm.util.Precondition;
import gov.va.med.mhv.sm.doa.PropertiesUtil;

import java.io.IOException;
import java.util.Properties;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Component;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
//import org.tigris.atlas.config.ConfigurationManager;

@Component
@PropertySources(value = {
		@PropertySource("classpath:/${MHV_ENV_PROPERTY}.sm.application.properties") })
public abstract class AbstractBaseProperties<SettingsType> {

	private static final Log LOG = LogFactory.getLog(AbstractBaseProperties.
		class);

	private static boolean reloadProperties = PropertiesUtil.
		getReloadProperties();

    private final String resourceName;
    private final boolean required;
    private Properties properties = null;
    private SettingsType settings = null;

    protected AbstractBaseProperties(String resourceName) {
    	this(resourceName, false, false);
    }

    protected AbstractBaseProperties(String resourceName, boolean required,
    	boolean disallowReload)
    {
    	////Precondition.assertNotNull("resourceName", resourceName);
    	this.resourceName = resourceName;
    	this.required = required;
    	if (!reloadProperties || disallowReload) {
    		properties = loadProperties();
    	}
    	if (properties != null) {
    		settings = loadSettings(properties);
            if (getLocalLog().isInfoEnabled()) {
            	getLocalLog().info("Loaded " ); //+ DescriptionBuilder.describe(settings));
            }
    	}
    }

    public final SettingsType getSettings() {
    	return (settings != null) ? settings : loadSettings(getProperties());
    }

    protected Log getLog() {
    	return LOG;
    }

    protected abstract SettingsType loadSettings(Properties properties);

    /**
     * Indicates the prefix used for all properties.
     * This value must be 'hard-coded' in the overriding method.
     * It cannot be read from a member variable,
     * due to the fact that the prefix value is used
     * when the settings are loaded (in the constructor).
     * If this method is not overriden, no prefix is used.
     * Also, the value may be given with or without a trailing '.'
     * If no trailing '.' is given, it will be added.
     * Also, whitespace is trimmed of the prefix.
     * @return The name of the prefix if any.
     */
    protected String getPropertyPrefix() {
    	return "";
    }

    protected final Properties getProperties() {
    	return (reloads()) ? loadProperties() : properties;
    }

    protected final boolean reloads() {
    	return (properties == null);
    }

	protected String getValue(Properties properties, String name,
		String defaultValue)
	{
		return PropertiesUtil.getValue(resourceName, properties,
			prefix() + name, defaultValue);
	}

	protected int getIntValue(Properties properties, String name,
		int defaultValue)
	{
		return PropertiesUtil.getIntValue(resourceName, properties,
			prefix() + name, defaultValue);
	}

	protected boolean getBooleanValue(Properties properties, String name,
		boolean defaultValue)
	{
		return PropertiesUtil.getBooleanValue(resourceName, properties,
			prefix() + name, defaultValue);
	}

	protected boolean allowLoadFromClassPath() {
		return false;
	}

    private Log getLocalLog() {
    	Log log = getLog();
    	return (log != null) ? log : LOG;
    }

    private Properties loadProperties() {
    	try {
            if (getLocalLog().isInfoEnabled()) {
            	getLocalLog().info("Loading " + resourceName);
            }
    		//return ConfigurationManager.getConfiguration(resourceName);
    		Properties prop = new java.util.Properties();
    		System.out.println(">>>>>>>> Resource file name is::"+resourceName);
    		prop.load(getClass().getClassLoader().getResourceAsStream(resourceName));
    		return prop;
    	} catch (IllegalStateException e) {
    		Properties properties = loadDefaultProperties();
    		if (properties != null) {
    			return properties;
    		}
    		if (required) {
    			throw e;
    		}
            if (getLocalLog().isInfoEnabled()) {
            	getLocalLog().info("Could not find " + resourceName +
                	"'. Presumably using default values");
            }
    		return null;
    	} catch (IOException e) {
    		Properties properties = loadDefaultProperties();
    		if (properties != null) {
    			return properties;
    		}
            if (getLocalLog().isInfoEnabled()) {
            	getLocalLog().info("Could not find " + resourceName +
                	"'. Presumably using default values");
            }
    		return null;
    	}
    }

    private Properties loadDefaultProperties() {
    	if (!allowLoadFromClassPath()) {
    		return null;
    	}
    	final String SEPARATOR = "/";
		String defaultResourceName = (resourceName.startsWith(SEPARATOR))
			? StringUtils.substringAfter(resourceName, SEPARATOR)
			: resourceName;
		if (StringUtils.isBlank(defaultResourceName)) {
			String errorMessage =  "Failed to load " + resourceName
				+ " from classpath, because unable to determine resourceName";
			getLocalLog().error(errorMessage);
            ////Precondition.fail(errorMessage);
		}
		final String name = "default properties from classpath using '"
			+ getClass().getName() + "' and '" + defaultResourceName + "'";
		try {
			Properties properties = new java.util.Properties();
			properties.load(getClass().getResourceAsStream(defaultResourceName));
            if (getLocalLog().isInfoEnabled()) {
            	getLocalLog().info("Loaded " + name + ".");
            }
            return properties;
		} catch (IOException e) {
			String errorMessage = "Failed to load " + name+ "";
			getLocalLog().error(errorMessage, e);
            ////Precondition.fail(errorMessage + ", because " + e.getLocalizedMessage());
        	return null; // Never executed
		}
    }

    private String prefix() {
    	String prefix = getPropertyPrefix();
    	if (prefix != null) {
    		prefix = prefix.trim();
    		if (!StringUtils.isBlank(prefix) && !prefix.endsWith(".")) {
    			prefix += ".";
    		}
    	} else {
    		prefix = "";
    	}
    	return prefix;
    }

}
