package gov.va.med.mhv.sm.data.repository;

import gov.va.med.mhv.sm.data.model.UserAcceptTermsHistory;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface UserAcceptTermsHistoryRepository extends JpaRepository<UserAcceptTermsHistory, Long> {

	@Query("Select u from UserAcceptTermsHistory u where u.userProfileId=:userProfileId and u.userUpdatedTime= :userUpdatedTime")
	List<UserAcceptTermsHistory> getUserAcceptTermsHistByUpdateTime(@Param("userProfileId") Long userProfileId, @Param("userUpdatedTime") Date userUpdatedTime);

	@Query("Select u from UserAcceptTermsHistory u where u.userProfileId=:userProfileId order by u.userUpdatedTime desc")
	List<UserAcceptTermsHistory> getUserAcceptTermsHistByUserProfileId(@Param("userProfileId") Long userProfileId);

	@Modifying
	@Transactional
	@Query("delete from UserAcceptTermsHistory u where u.userProfileId= :userProfileId")
	void deleteByUserProfileId(@Param("userProfileId") Long userProfileId);
}
