package gov.va.med.mhv.rxrefill.web.util;

import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;

import java.util.Comparator;

import org.apache.commons.lang3.builder.CompareToBuilder;

public class PrescriptionsTrackingComparator implements Comparator<PrescriptionDTO> {

	@Override
	public int compare(PrescriptionDTO obj, PrescriptionDTO other) {

		if (obj!=null && other!=null) {

			if (obj.getLastFillDate()!=null && other.getLastFillDate()!=null && obj.getDrugName()!=null && other.getDrugName()!=null) {
				return new CompareToBuilder()

				.append(other.getLastFillDate(), obj.getLastFillDate())
				.append(obj.getDrugName(), other.getDrugName()).toComparison();
			}
			else {

				
				if (obj.getLastFillDate() !=null && other.getLastFillDate()!=null) {
					return new CompareToBuilder()
					.append(other.getLastFillDate(), obj.getLastFillDate()).toComparison();

				}
				else {
					if (obj.getDrugName() !=null && other.getDrugName()!=null) {
						return new CompareToBuilder()
						.append(obj.getDrugName(), other.getDrugName()).toComparison();

					}
				}

			}

		}
		return 0;
	}
}
