package gov.va.med.mhv.rxrefill.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;
import gov.va.med.mhv.rxrefill.web.util.PrescriptionsTrackingComparator;

@ManagedBean
@Component
@Scope("session")
public class PrescriptionsTrackingController extends AbstractRxController {

	private static final long serialVersionUID = -7198958966081915537L;

	private static Logger log = LogManager.getLogger(PrescriptionsHistoryController.class);

	private DataTable historyRxTable;
	private PrescriptionDTO selectedPrescription;
	private boolean hasRefillableRx = false;
	
	private List<PrescriptionDTO> historicalPrescriptions = null;
	private List<PrescriptionDTO> filteredHistoricalPrescriptions = null;
	private List<PrescriptionDTO> allPrescriptions = null;


	public static final String TRACKING_INFORMATION_DETAIL_PAGE="prescriptionsTrackingInformationDetail";
	public static final String IMAGE_PAGE="trackingMedicationImagePage";
	public static final String TRACKING_CARRIER_LANDING_PAGE="trackingCarrierLandingPage";
	

	public String acceptAgreement() {
		if (log.isDebugEnabled()) {
			log.debug("inside acceptAgreement.......");
		}
		declineMessage = null;
		newSaveProfileDto=this.userProfileDto;
		try {
			if (null != newSaveProfileDto && null != newSaveProfileDto.getId()) {
				newSaveProfileDto.setRxAgreementDate(new Date(System.currentTimeMillis()));
				newSaveProfileDto.setRxAgreementSigned(new Boolean(true));

				// save user profile
				saveUserProfile(newSaveProfileDto);
			}
		} catch (MHVException e) {
			throw new MHVRuntimeException("Error in accepting Rx agreement from tracking pages: " + e.getMessage());
		}


		return "prescriptionsTrackingSummary";
	}

	@Override
	protected void loadEntities(UserProfileDTO userProfileDto) {
		// TODO Auto-generated method stub

	}

	@Override
	protected List<PrescriptionDTO> lookupPrescriptions(Long userProfileId) {
		ResponseUtil response = null;

		try {
			historicalPrescriptions = getRxRefillServiceServiceProxy().getPrescriptionsHistory(userProfileId);
			if (log.isDebugEnabled()) {
				log.debug("historicalPrescriptions count : "
						+ ((null != historicalPrescriptions) ? historicalPrescriptions.size() : 0));
			}

		} catch (Exception e) {
			log.error("Error in fetching prescription histories", e);
			throw new MHVRuntimeException("Error in fetching prescription histories", e);
		}		
		
		try {
			allPrescriptions = getRxRefillServiceServiceProxy().getAllPrescriptions(userProfileId);
			if (log.isDebugEnabled()) {
				log.debug("allPrescriptions count : "
						+ ((null != allPrescriptions) ? allPrescriptions.size() : 0));
			}

		} catch (Exception e) {
			log.error("Error in fetching all Prescriptions", e);
			throw new MHVRuntimeException("Error in fetching all Prescriptions", e);
		}

		filteredHistoricalPrescriptions= filterPrescriptions(historicalPrescriptions);

		return historicalPrescriptions;
	}

	private List<PrescriptionDTO> filterPrescriptions(List<PrescriptionDTO> historicalPrescriptions) {
		List<PrescriptionDTO> filteredList = new ArrayList<PrescriptionDTO>();

		if (historicalPrescriptions != null) {
			for (PrescriptionDTO dto : historicalPrescriptions) {
				if (dto.isTracking()) {
					filteredList.add(dto);
				}

			}
		}
		if(filteredList != null){
		   Collections.sort(filteredList, new PrescriptionsTrackingComparator());
		}
		return filteredList;
	}


	@Override
	public String trackDelivery(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		setImagePage("trackingMedicationImagePage");
		return "prescriptionsTrackingInformationDetail";
	}

	public String refillPrescriptionsSummaryPrint() {
		//setHistoryRxTable((DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("prescriptionsTrackingForm:prescTrackList"));
		return "refillPrescriptionsSummaryPrint";
	}

	
	public String showDetail(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		return "prescriptionsTrackingDetail";
	}

	public PrescriptionDTO getSelectedPrescription() {
		return selectedPrescription;
	}

	public void setSelectedPrescription(PrescriptionDTO selectedPrescription) {
		this.selectedPrescription = selectedPrescription;
	}

	public boolean isHasRefillableRx() {
		return hasRefillableRx;
	}

	public void setHasRefillableRx(boolean hasRefillableRx) {
		this.hasRefillableRx = hasRefillableRx;
	}


	@Override
	protected void saveSortInfo() {
		// TODO Auto-generated method stub
		historyRxTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("prescriptionsTrackingForm:prescTrackList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if(sortColumn != null && sortBy != null){
				historyRxTable.setValueExpression("sortBy", sortColumn);
				historyRxTable.setSortOrder(sortBy);
				
			} 
		}
			
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	public DataTable getHistoryRxTable() {
		return historyRxTable;
	}

	public void setHistoryRxTable(DataTable historyRxTable) {
		this.historyRxTable = historyRxTable;
	}
	
	
	@Override
	public String trackingWarningPage() {
		return TRACKING_CARRIER_LANDING_PAGE;
	}

	public List<PrescriptionDTO> getPrescriptions() {
		return historicalPrescriptions;
	}

	public void setPrescriptions(List<PrescriptionDTO> prescriptions) {
		this.historicalPrescriptions = prescriptions;
	}

	public List<PrescriptionDTO> getAllPrescriptions() {
		return allPrescriptions;
	}

	public void setAllPrescriptions(List<PrescriptionDTO> allPrescriptions) {
		this.allPrescriptions = allPrescriptions;
	}

	public List<PrescriptionDTO> getFilteredHistoricalPrescriptions() {
		return filteredHistoricalPrescriptions;
	}

	public void setFilteredHistoricalPrescriptions(
			List<PrescriptionDTO> filteredHistoricalPrescriptions) {
		this.filteredHistoricalPrescriptions = filteredHistoricalPrescriptions;
	}


}
