package gov.va.med.mhv.rxrefill.web.controller;

import java.util.Date;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;

@ManagedBean
@Component
@Scope("session")
public class PrescriptionsHistoryController extends AbstractRxController {

	private static final long serialVersionUID = -7198958966081915537L;

	private static Logger log = LogManager.getLogger(PrescriptionsHistoryController.class);

	private DataTable historyRxTable;
	private PrescriptionDTO selectedPrescription;
	private boolean hasRefillableRx = false;
	//UserProfileDTO userProfileDto = null;
	private List<PrescriptionDTO> allPrescriptions = null;

	public String agreement() {
		if (log.isDebugEnabled()) {
			log.debug("inside accept agreement in PrescriptionsHistoryController.......");
		}
		declineMessage = null;

		newSaveProfileDto=this.userProfileDto;
		try {
			if (null != newSaveProfileDto && null != newSaveProfileDto.getId()) {
				newSaveProfileDto.setRxAgreementDate(new Date(System.currentTimeMillis()));
				newSaveProfileDto.setRxAgreementSigned(new Boolean(true));

				// save user profile
				saveUserProfile(newSaveProfileDto);
			}
		} catch (MHVException e) {
			throw new MHVRuntimeException("Error in accepting Rx agreement from History pages: " + e.getMessage());
		}
		
		return "prescriptionsHistory";
	}

	// TODO: Fix Decline Rx agreement
	public String declineAgreement() {
		if (log.isDebugEnabled()) {
			log.debug("inside declineAgreement.......");
		}

		declineMessage = "You will not be able to use the new Rx Refill capability until you accept terms and conditions for using the site. If you have concerns, you may communicate them using Contact Us";

		return "rxAgreementDisclaimers";
	}

	@Override
	protected void loadEntities(UserProfileDTO userProfileDto) {
		// TODO Auto-generated method stub

	}

	@Override
	protected List<PrescriptionDTO> lookupPrescriptions(Long userProfileId) {
		List<PrescriptionDTO> historicalPrescriptions = null;

		if(log.isDebugEnabled()){
			log.debug(String.format("Current thread name: %s", Thread.currentThread().getName()));
		}
			
		try {
			
			hasRefillableRx = false;
			
			// If the refresh threshold has not expired, skip the refresh; othewise
			// proceed with the update.
			
			historicalPrescriptions = getRxRefillServiceServiceProxy().getPrescriptionsHistory(userProfileId);
			this.lastRefreshTime = System.currentTimeMillis();

			if (log.isDebugEnabled()) {
				log.debug("historicalPrescriptions count : "
						+ ((null != historicalPrescriptions) ? historicalPrescriptions.size() : 0));
			} 
				
		} catch (Exception e) {
			log.error("Error in fetching prescription histories <<<" + userProfileId +">>> ", e);
			throw new MHVRuntimeException("Error in fetching prescription histories", e);
		}

		try {
			allPrescriptions = getRxRefillServiceServiceProxy().getAllPrescriptions(userProfileId);
			if (log.isDebugEnabled()) {
				log.debug("allPrescriptions count : "
						+ ((null != allPrescriptions) ? allPrescriptions.size() : 0));
			}

		} catch (Exception e) {
			log.error("Error in fetching all prescriptions <<<" + userProfileId +">>> ", e);
			throw new MHVRuntimeException("Error in fetching all prescriptions", e);
		} 	
		
		
		return historicalPrescriptions;
	}
	
	public String prescriptionsHistoryPrint() {
		historyRxTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("prescriptionsHistoryForm:prescriptionHistList");
		return "prescriptionsHistoryPrint";
	}


	public String showDetail(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		return "prescriptionsHistoryDetail";
	}

	public PrescriptionDTO getSelectedPrescription() {
		return selectedPrescription;
	}

	public void setSelectedPrescription(PrescriptionDTO selectedPrescription) {
		this.selectedPrescription = selectedPrescription;
	}

	public boolean isHasRefillableRx() {
		return hasRefillableRx;
	}

	public void setHasRefillableRx(boolean hasRefillableRx) {
		this.hasRefillableRx = hasRefillableRx;
	}

	@Override
	public String trackDelivery(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		setImagePage("prescriptionsHistoryTrackingMedicationImagePage");
		return "prescriptionsHistoryTrackingInformationDetail";
	}

	@Override
	public String trackingWarningPage() {
		return "prescriptionsHistoryTrackingCarrierLandingPage";
	}
	
	@Override
	protected void saveSortInfo() {
		
		historyRxTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("prescriptionsHistoryForm:prescriptionHistList");
		
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if (sortColumn != null && sortBy != null){
				historyRxTable.setValueExpression("sortBy", sortColumn);
				historyRxTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	public DataTable getHistoryRxTable() {
		return historyRxTable;
	}

	public void setHistoryRxTable(DataTable historyRxTable) {
		this.historyRxTable = historyRxTable;
	}

	public List<PrescriptionDTO> getAllPrescriptions() {
		return allPrescriptions;
	}

	public void setAllPrescriptions(List<PrescriptionDTO> allPrescriptions) {
		this.allPrescriptions = allPrescriptions;
	}


}
