package gov.va.med.mhv.rxrefill.web.controller;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.dto.MedicationHistoryDTO;
import gov.va.med.mhv.rxrefill.enums.CategoryTypeEnumeration;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;

import java.io.IOException;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class MedicationSupplementsController extends AbstractMedicationsController {

	private static final long serialVersionUID = 5010579180069981061L;

	private static Logger log = LogManager.getLogger(MedicationSupplementsController.class);

	private DataTable medicationTable;
	private MedicationHistoryDTO selectedMedication;
	private MedicationHistoryDTO newMedicationHistory = new MedicationHistoryDTO(); 
	
	public String loadMedicationSupplementsSummaryPrint() {
		resetMessages();
		
		medicationTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicationSupplementsForm:medList");
		return "medicationSupplementsSummaryPrint";
	}
	
	public String showMedSupplementDetails(MedicationHistoryDTO medicationHistoryDTO){
		try {
			resetMessages();
			medicationSupplementReturnPage = MED_SUPPLEMENT_DETAIL_PAGE;
			
			selectedMedication = medicationHistoryDTO;
		} catch (Exception e) {
			log.error("Error in showMedSupplementDetails", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return MED_SUPPLEMENT_DETAIL_PAGE;
	}
	
	
	@Override
	protected List<MedicationHistoryDTO> loadMedications(String userName) {
		
		
		try {
			userProfile = getCurrentUserProfile(userName);
			if (null != userProfile && null != userProfile.getId()) {
				medications = getMedicationSupplementService().getMedicationsByUserId(userProfile.getId());
				setRowsPerPage(10);
			} else {
				log.error("userProfile is null");
				throw new MHVRuntimeException("userProfile is null");
			}
		} catch(Exception e) {
			log.error("Error in loading medications" + e);
			throw new MHVRuntimeException("Error in loading medications", e);
		}
		
		return medications;
	}
	
	public String loadAddNewMedication() {
		try{
			//resetMessages();
			
			newMedicationHistory = new MedicationHistoryDTO();
			
			initializeMedication(newMedicationHistory);
			
			// which page to return from edit page 'Cancel' button
			medicationSupplementReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("medReturnPage");
			
		} catch (Exception e) {
			log.error("Error in loadAddNewMedication", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MED_SUPPLEMENT_ADD_PAGE;
	}
	
	public String loadEditMedSupplementFromSummary(MedicationHistoryDTO medicationHistoryDTO) {
		try{
			selectedMedication = medicationHistoryDTO;
			
			resetMessages();
			
			// which page to return from edit page 'Cancel' button
			medicationSupplementReturnPage = MED_SUPPLEMENT_SUMMARY_PAGE;
		} catch (Exception e) {
			log.error("Error in loadEditMedSupplementFromSummary", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MED_SUPPLEMENT_EDIT_PAGE;
	}

	public String loadEditMedicationFromDetail() {
		try{
			// which page to return from edit page 'Cancel' button
			medicationSupplementReturnPage = MED_SUPPLEMENT_DETAIL_PAGE;
		} catch (Exception e) {
			log.error("Error in loadEditMedicationFromDetail", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MED_SUPPLEMENT_EDIT_PAGE;
	}
	
	public String loadEditMedication() {
		try{
			String strMedicationId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("medicationId");
			Long medicationId = Long.valueOf(strMedicationId);
			
			selectedMedication = loadMedication(medicationId);
		} catch (Exception e) {
			log.error("Error in loadEditMedication", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return MED_SUPPLEMENT_EDIT_PAGE;
	}

	public String loadDeleteMedication(MedicationHistoryDTO medicationHistoryDTO) {
		try{
			resetMessages();
			
			// which page to return from edit page 'Cancel' button
			medicationSupplementReturnPage = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("medReturnPage");
			
			// if delete request from summary, then get food journal from foodJournalTable, otherwise not required from detail page 
			if (null != medicationSupplementReturnPage && medicationSupplementReturnPage.equalsIgnoreCase(MED_SUPPLEMENT_SUMMARY_PAGE)) {
				selectedMedication = medicationHistoryDTO;
			}
		} catch (Exception e) {
			log.error("Error in loadDeleteMedication", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return MED_SUPPLEMENT_DELETE_PAGE;
	}
	
	public String returnToCallingPage() {
		resetMessages();
		medicationSupplementReturnPage = (null != medicationSupplementReturnPage && medicationSupplementReturnPage.trim().length() > 0) ? medicationSupplementReturnPage : MED_SUPPLEMENT_SUMMARY_PAGE;

		return medicationSupplementReturnPage;
	}
	
	public String saveMedication() {
		log.info("===============inside saveMedication()==========");
		
		MedicationHistoryDTO medHistoryDto = null;
		String returnpage = MED_SUPPLEMENT_SUMMARY_PAGE;
		String requestFrom = null;
		Boolean errInSave = Boolean.FALSE;
		MedicationHistoryDTO saveMedication = new MedicationHistoryDTO();
		setRowsPerPage(10);
		try {
			resetMessages();
			requestFrom = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("requestFrom");
			
			if (null != requestFrom) {
				if (requestFrom.equalsIgnoreCase(MED_SUPPLEMENT_ADD_PAGE) 
						|| requestFrom.equalsIgnoreCase(MED_SUPPLEMENT_ADD_NEW_PAGE)) {
					saveMedication = newMedicationHistory;
					returnpage = MED_SUPPLEMENT_ADD_PAGE;
				} else if (requestFrom.equalsIgnoreCase(MED_SUPPLEMENT_EDIT_PAGE)) {
					saveMedication = selectedMedication;
					returnpage = MED_SUPPLEMENT_EDIT_PAGE;
				}
			}
			
			try {
				medHistoryDto = getMedicationSupplementService().saveMedication(saveMedication);
				medications = getMedicationSupplementService().getMedicationsByUserId(userProfile.getId());
			} catch (MHVException e) {
				super.processErrorMessages(ResponseUtil.toResponseUtil(e));
				errInSave = Boolean.TRUE;
				
			}
			
			if (requestFrom.equalsIgnoreCase(MED_SUPPLEMENT_ADD_NEW_PAGE)) {
				addNewMessage = true;
				return loadAddNewMedication();
			} else if (requestFrom.equalsIgnoreCase(MED_SUPPLEMENT_EDIT_PAGE)) {
				saveMessage = true;
			} else if (requestFrom.equalsIgnoreCase(MED_SUPPLEMENT_ADD_PAGE)) {
				saveMessage = true;
			}
			
			if (errInSave) {
			returnpage = MED_SUPPLEMENT_ADD_PAGE;
			} else {
			
			returnpage = MED_SUPPLEMENT_SUMMARY_PAGE;
			}
			
		} catch (Exception e) {
			log.error("Error in saving new medication", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		} 

		return returnpage;
	}
	
	public String saveMedicationLoadAddNewMedication() {
		
		addNewMessage = true;
		return MED_SUPPLEMENT_ADD_PAGE;
	}
	
	public String deleteMedication() {
		log.info("===============inside deleteMedication()==========");
		
		ResponseUtil response = null;
		setRowsPerPage(10);
		try {
			String strMedicationId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("medicationId");
			Long medicationId = Long.valueOf(strMedicationId);
			
			response = getMedicationSupplementService().deleteMedication(medicationId);
			
			// response has errors
			if (response.isFailure()) {
				log.info("isFailure : " + response.isFailure());
				super.processErrorMessages(response);
			} else {
				deleteMessage = true;
				medications = getMedicationSupplementService().getMedicationsByUserId(userProfile.getId());
			}
		} catch (Exception e) {
			log.error("Error in deleting medication", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return MED_SUPPLEMENT_SUMMARY_PAGE;
	}
	
	private MedicationHistoryDTO loadMedication(Long medicationId) {
		MedicationHistoryDTO medication = null;
		
		try {
			medication = getMedicationSupplementService().getMedicationsById(medicationId);
		} catch(Exception e) {
			log.error("Error in loading loadMedication" + e);
			throw new MHVRuntimeException("Error in loading loadMedication", e);
		}
		
		return medication;
	}
	
	private void initializeMedication(MedicationHistoryDTO medication) {
		medication.setMedicationId(null);
		medication.setComments(null);
		medication.setReason(null);
		medication.setStartDate(new java.util.Date());
		medication.setStrength(null);
		medication.setPharmacyPhone(null);
		medication.setDosage(null);
		medication.setFrequency(null);
		medication.setCategory(null);
		medication.setPrescriptionNumber(null);
		medication.setEndDate(null);
		medication.setMedicationName(null);
		medication.setPharmacyName(null);
		medication.setUserId(getUserProfileId());
	}
	
	public String loadAddNewMedicationFromADifferentPortlet(){
		resetMessages();
		findUser();
		setRowsPerPage(10);
		loadAddNewMedication();
		userProfile=getCurrentUserProfile(getUserScreenName());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "/views/rx-refill/addMedicationSupplements.xhtml");
		return null;
	}
	
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}
	

	public MedicationHistoryDTO getSelectedMedication() {
		return selectedMedication;
	}
	
	public MedicationHistoryDTO getNewMedicationHistory() {
		return newMedicationHistory;
	}
	
	public void setNewMedicationHistory(
			MedicationHistoryDTO newMedicationHistory) {
		this.newMedicationHistory = newMedicationHistory;
	}
	
	public CategoryTypeEnumeration[] getCategories() {
		return CategoryTypeEnumeration.values();
	}

	@Override
	protected void saveSortInfo() {
		// TODO Auto-generated method stub
		medicationTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicationSupplementsForm:medList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if (sortColumn != null && sortBy != null){
				medicationTable.setValueExpression("sortBy", sortColumn);
				medicationTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public DataTable getMedicationTable() {
		return medicationTable;
	}

	public void setMedicationTable(DataTable medicationTable) {
		this.medicationTable = medicationTable;
	}
	
}
