package gov.va.med.mhv.rxrefill.web.controller;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.rxrefill.dto.MedicationHistoryDTO;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.enums.CategoryTypeEnumeration;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;

@ManagedBean
@Component
@Scope("session")
public class MedicationController extends AbstractMedicationsController {

	private static final long serialVersionUID = -3844815209208073218L;

	private static Logger log = LogManager.getLogger(MedicationController.class);

	private DataTable medicationTable;
	
	private PrescriptionDTO  selectedPrescription = new PrescriptionDTO();
	private List<PrescriptionDTO> prescriptions = new ArrayList<PrescriptionDTO>(0);
		
	private String now = null;
	
	public String loadMedicationSupplementsSummaryPrint() {
		resetMessages();
		medicationTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicationsSummaryForm:vaMedList");
		return "vaMedicationsSummaryPrint";
	}
	
	public String showMedicationDetails(PrescriptionDTO prescriptionDTO){
		try {
			resetMessages();
			vaMedicationReturnPage = MED_VA_MEDICATION_DETAIL_PAGE;
			selectedPrescription= prescriptionDTO;
		} catch (Exception e) {
			log.error("Error in showMedicationDetails", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		
		return MED_VA_MEDICATION_DETAIL_PAGE;
	}
	
	@Override
	protected List<MedicationHistoryDTO> loadMedications(String userName) {
    
		Date newDate=new Date();
		DateFormat dtfmt = new SimpleDateFormat( "MM/dd/yyyy");
		dtfmt.setTimeZone(TimeZone.getTimeZone("EST"));
		
        DateFormat dtfmt2 = new SimpleDateFormat("HH:mm");
		dtfmt2.setTimeZone(TimeZone.getTimeZone("EST"));
        
		now=dtfmt.format(newDate);
		now+=" at ";
		now+=dtfmt2.format(newDate);
		
		try {
			userProfile = getCurrentUserProfile(userName);
			
			if (null != userProfile && null != userProfile.getId()) {
				prescriptions=lookupPrescriptions(userProfile.getId());
			} else {
				log.error("userProfile is null");
				throw new MHVRuntimeException("userProfile is null");
			}
		} catch(Exception e) {
			log.error("Error in loading medications" , e);
		}
		
		return medications;
	}

	public String returnToCallingPage() {
		resetMessages();
		vaMedicationReturnPage = (null != vaMedicationReturnPage && vaMedicationReturnPage.trim().length() > 0) ? vaMedicationReturnPage : MED_VA_MEDICATION_SUMMARY_PAGE;
		return vaMedicationReturnPage;
	}
	
	public CategoryTypeEnumeration[] getCategories() {
		return CategoryTypeEnumeration.values();
	}
	
		protected List<PrescriptionDTO> lookupPrescriptions(Long userProfileId) {
			List<PrescriptionDTO> historicalPrescriptions = null;
			
			try {
				
				historicalPrescriptions = getRxRefillWebService().getPrescriptionsHistory(userProfileId);
					
					if (log.isDebugEnabled()) {
						log.debug("historicalPrescriptions count : " + ((null != historicalPrescriptions) ? historicalPrescriptions.size(): 0));
					}
			
			} catch (Exception e) {
				log.error("Error in fetching prescription histories", e);
				throw new MHVRuntimeException("Error in fetching prescription histories", e);
			}
			
			return historicalPrescriptions;
		}

	public PrescriptionDTO getSelectedPrescription() {
		return selectedPrescription;
	}

	public void setSelectedPrescription(PrescriptionDTO selectedPrescription) {
		this.selectedPrescription = selectedPrescription;
	}

	public List<PrescriptionDTO> getPrescriptions() {
		return prescriptions;
	}

	public void setPrescriptions(List<PrescriptionDTO> prescriptions) {
		this.prescriptions = prescriptions;
	}

	public String getNow() {
		return now;
	}

	public void setNow(String now) {
		this.now = now;
	}

	public DataTable getMedicationTable() {
		return medicationTable;
	}

	public void setMedicationTable(DataTable medicationTable) {
		this.medicationTable = medicationTable;
	}

	@Override
	protected void saveSortInfo() {
		medicationTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicationsSummaryForm:vaMedList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if (sortColumn != null && sortBy != null){
				medicationTable.setValueExpression("sortBy", sortColumn);
				medicationTable.setSortOrder(sortBy);
			} 
		}
		
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}
	
/*	@Override
	protected void saveSortInfo() {
		
	}*/


}
	
