package gov.va.med.mhv.rxrefill.web.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.bean.ManagedBean;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.web.util.RxMessagesUtil;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;

@ManagedBean
@Component
@Scope("session")
public class ActivePrescriptionController extends AbstractRxController {

	private static final long serialVersionUID = -7198958966081915537L;

	private static Logger log = LogManager.getLogger(ActivePrescriptionController.class);

	private DataTable activeRxTable;
	private PrescriptionDTO selectedPrescription;
	private boolean hasRefillableRx = false;
	private List<PrescriptionDTO> allPrescriptions = null;

	@Autowired
	private RxMessagesUtil rxMessagesUtil;


	/*public void init(ComponentSystemEvent event) throws IOException {
		if (log.isDebugEnabled()) {
			log.debug("Initializing Refresh Status");
		}
		activeRxTable =  (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("refillPrescriptionForm:refillPrescriptionList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if (sortColumn != null && sortBy != null){
				activeRxTable.setValueExpression("sortBy", sortColumn);
				activeRxTable.setSortOrder(sortBy);
			}
		}
		findUser();
	}*/

	public String refillPrescriptionsSummaryPrint() {
		activeRxTable =  (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("refillPrescriptionForm:refillPrescriptionList");
		return "refillPrescriptionsSummaryPrint";
	}


	public String acceptAgreement() {
		if (log.isDebugEnabled()) {
			log.debug("inside acceptAgreement.......");
		}
		declineMessage = null;
		newSaveProfileDto=this.userProfileDto;
		try {
			if (null != newSaveProfileDto && null != newSaveProfileDto.getId()) {
				newSaveProfileDto.setRxAgreementDate(new Date(System.currentTimeMillis()));
				newSaveProfileDto.setRxAgreementSigned(new Boolean(true));

				// save user profile
				saveUserProfile(newSaveProfileDto);
			}
		} catch (MHVException e) {
			throw new MHVRuntimeException("Error in accepting Rx agreement from Refill pages: " + e.getMessage());
		}

		//return "refillPrescriptionsSummary";
		return "refillPrescriptionsSummary";
	}

	private UserProfileDTO getUserProfile(String userName) {
		// TODO Auto-generated method stub
		return null;
	}


	public String declineAgreement() {
		if (log.isDebugEnabled()) {
			log.debug("inside declineAgreement.......");
		}

		declineMessage = "You will not be able to use the new Rx Refill capability until you accept terms and conditions for using the site. If you have concerns, you may communicate them using Contact Us";

		return "rxAgreementDisclaimers";
	}

	@Override
	protected void loadEntities(UserProfileDTO userProfileDto) {
		// TODO Auto-generated method stub

	}

	@Override
	protected List<PrescriptionDTO> lookupPrescriptions(Long userProfileId) {
		//ResponseUtil prescriptionResponse = new ResponseUtil();
		ResponseUtil<List<PrescriptionDTO>> prescriptionResponse = null;
		List<PrescriptionDTO> activePrescriptions = null;
		
		try {

			prescriptionResponse = getRxRefillServiceServiceProxy().getActivePrescriptions(userProfileId);

	        if (!prescriptionResponse.isFailure()) {
	        	activePrescriptions = (List<PrescriptionDTO>) prescriptionResponse.getPojoObject();
			}
			
			selectedRxRefillFacilityNames = "";
			ArrayList<String> facilityNamesList = new ArrayList<String>();

			if (null != activePrescriptions && activePrescriptions.size() > 0) {
				for (PrescriptionDTO rx : activePrescriptions) {
					facilityNamesList.add(rx.getFactilityName());
				}
			}
			// convert to hashlist and copy back to arraylist to remove duplicates
			HashSet hs = new HashSet();
			hs.addAll(facilityNamesList);
			facilityNamesList.clear();
			facilityNamesList.addAll(hs);
			Collections.sort(facilityNamesList);

			Iterator<String> itr = facilityNamesList.iterator();
			int i=0;
			while(itr.hasNext()){
				selectedRxRefillFacilityNames = selectedRxRefillFacilityNames+","+itr.next();
			}
			
			if(log.isDebugEnabled()){
				log.debug("response.getFailureMessage()" + prescriptionResponse.getFailureMessage());
			}
			//FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, prescriptionResponse.getFailureMessage(), prescriptionResponse.getFailureMessage()));

			Map<String, String> infoMessages = prescriptionResponse.getInfoMessages();
			if (null != infoMessages && infoMessages.size() > 0) {
				if(log.isDebugEnabled()){
					log.debug("infoSize : " + infoMessages.size());
				}
				Set set = infoMessages.entrySet();
				Iterator iterator = set.iterator();
		        while(iterator.hasNext()) {
		             Map.Entry me = (Map.Entry)iterator.next();
		 			if(log.isDebugEnabled()){
		 				log.debug("Key is: "+ me.getKey() + "& Value is: "+me.getValue());
		 			}
		             //FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, (String) me.getValue(), (String) me.getValue()));
		             if (me.getKey().toString().contains("error")) {
		            	 //String infoMessage = String.format(rxMessagesUtil.getErrorVistaSystemfailure(),selectedRxRefillFacilityNames.substring(1));  // Substring Removes extra , in the front
		            	 String selectedRxRefillFacilityName = (String) me.getValue();
		            	 String infoMessage = String.format(rxMessagesUtil.getErrorVistaSystemfailure(),selectedRxRefillFacilityName.substring(selectedRxRefillFacilityName.indexOf("null,")+5));  
		            	 FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, infoMessage, infoMessage));
		            	 messageSeverity = "INFO";
		             }
		        }
			}

			hasRefillableRx = false;

			if (log.isDebugEnabled()) {
				log.debug("activePrescriptions count : "
						+ ((null != activePrescriptions) ? activePrescriptions.size() : 0));
			}

			// show submit refill button if at least one rx is refillable
			if (null != activePrescriptions && activePrescriptions.size() > 0) {
				for (PrescriptionDTO prescriptionDto : activePrescriptions) {
					if (checkRefillable(prescriptionDto)) {
						hasRefillableRx = true;
						break;
					}
				}
			}
		} catch (Exception e) {
			log.error("Error in fetching active prescriptions <<<" + userProfileId +">>>", e);
			throw new MHVRuntimeException("Error in fetching active prescriptions", e);
		}


		try {
			allPrescriptions = getRxRefillServiceServiceProxy().getAllPrescriptions(userProfileId);
			if (log.isDebugEnabled()) {
				log.debug("historicalPrescriptions count : "
						+ ((null != allPrescriptions) ? allPrescriptions.size() : 0));
			}

		} catch (Exception e) {
			log.error("Error in fetching all prescriptions <<<" + userProfileId +">>>", e);
			throw new MHVRuntimeException("Error in fetching all prescriptions", e);
		}

		return activePrescriptions;
	}

	@Override
	public String trackDelivery(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		setImagePage("refillPrescriptionsTrackingMedicationImagePage");
		return "refillPrescriptionsTrackingInformationDetail";
	}

	/* This is not used... submitRefillAction in AbstractRxController is used.
	public String submitRefills() {
		log.info("inside submitRefills()...........");
		List<PrescriptionDTO> selectedPrescriptions = new ArrayList<PrescriptionDTO>();
		for (PrescriptionDTO prescriptionDto : prescriptions) {
			if (prescriptionDto.isSelected()) {
				if (log.isDebugEnabled()) {
					log.debug("selected prescription rx# for refill : " + prescriptionDto.getPrescriptionNumber());
				}
				selectedPrescriptions.add(prescriptionDto);

				refillSubmitSucccess = "Your refill request for DAYT3 has been submitted.";
			}

		}

		return "refillPrescriptionsSummary";
	}
	*/

	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	public String showDetail(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		return "refillPrescriptionDetail";
	}

	public PrescriptionDTO getSelectedPrescription() {
		return selectedPrescription;
	}

	public void setSelectedPrescription(PrescriptionDTO selectedPrescription) {
		this.selectedPrescription = selectedPrescription;
	}

	public boolean isHasRefillableRx() {
		return hasRefillableRx;
	}

	public void setHasRefillableRx(boolean hasRefillableRx) {
		this.hasRefillableRx = hasRefillableRx;
	}

	@Override
	public String trackingWarningPage() {
		return "refillPrescriptionsTrackingCarrierLandingPage";
	}

	@Override
	protected void saveSortInfo() {
		activeRxTable =  (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("refillPrescriptionForm:refillPrescriptionList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if (sortColumn != null && sortBy != null){
				activeRxTable.setValueExpression("sortBy", sortColumn);
				activeRxTable.setSortOrder(sortBy);
			}
		}
		findUser();
	}

	public DataTable getActiveRxTable() {
		return activeRxTable;
	}

	public void setActiveRxTable(DataTable activeRxTable) {
		this.activeRxTable = activeRxTable;
	}


	public List<PrescriptionDTO> getAllPrescriptions() {
		return allPrescriptions;
	}


	public void setAllPrescriptions(List<PrescriptionDTO> allPrescriptions) {
		this.allPrescriptions = allPrescriptions;
	}


}
