package gov.va.med.mhv.rxrefill.web.controller;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import javax.annotation.Resource;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.net.ssl.HttpsURLConnection;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.CommonUtility;
import gov.va.med.mhv.rxrefill.dto.PharmacyPatientDTO;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.dto.RequestDTO;
import gov.va.med.mhv.rxrefill.dto.RxTrackingDTO;
import gov.va.med.mhv.rxrefill.enums.PrescriptionStatusEnumeration;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;
import gov.va.med.mhv.rxrefill.service.PharmacyRefillWebService;
import gov.va.med.mhv.rxrefill.utils.TimerUtils;
import gov.va.med.mhv.rxrefill.web.util.RxMessagesUtil;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatusEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

	public abstract class AbstractRxController implements Serializable {

	private static final long serialVersionUID = 2236322817917893453L;

	private static final int WARN_ON_REPEAT_COUNT = 3;
	
	protected static final String LAST_UPDATED_DATE_FORMAT = "MM/dd/yyyy 'at' HHmm";
	protected static final String ERR_PRCS_RQST = "An unknown exception occured."; //"Error Processing request";

	private static Logger log = LogManager.getLogger(AbstractRxController.class);

	private static final String USERPROFILE_DTO_KEY = "LIFERAY_SHARED_userprofiledto";
	private static final String PATIENT_DTO_KEY = "LIFERAY_SHARED_patientdto";
	private static final String PATIENT_ID_KEY = "LIFERAY_SHARED_patientid";
	private static final String USER_PROFILE_ID_KEY = "LIFERAY_SHARED_userprofileid";
	private static final String USER_NAME_KEY = "LIFERAY_SHARED_userid";

	@Value("${logoutUrl}")
	private String logoutUrl;

	@Value("${appContextroot}")
	private String appContextRoot;

	@Value("${drugImagesRoot}")
	private String drugImagesRoot;
	
	@Value("${rxRefreshThreshold}")
	private Long rxRefreshThreshold;

	@Autowired
	private RxMessagesUtil rxMessagesUtil;

	@Resource(name = "userMgmtServiceProxy")
	protected UserMgmtService userMgmtService;

	@Resource(name = "rxRefillServiceServiceProxy")
	private PharmacyRefillWebService rxRefillServiceServiceProxy;

	@Resource(name = "activityProxy")
	private AccountActivityCreatorService accountActivityService;

	@Autowired
	private ObjectMapper mapper;

	protected String firstName;
	protected String lastName;
	protected String declineMessage;
	protected PharmacyPatientDTO pharmacyPatientDto;
	protected List<PrescriptionDTO> prescriptions;
	private RxTrackingDTO rxTrackingDTO = new RxTrackingDTO();
	protected String refillSubmitSucccess;
	protected String messageSeverity;
	protected boolean isDuplicateRefillSubmitted;
	protected String selectedRxRefillFacilityNames;
	private Date lastUpdatedTimeForList;
	protected String presName = "";
	protected String presNumber = "";
	protected String presImageUrl = "";
	private String currentRxId = "";
	protected String imagePage;
	private RxTrackingDTO trackingDetailsForImage = new RxTrackingDTO();
	private String urlString = "";
	private String trackingPageName = "";
	UserProfileDTO userProfileDto = null;
	UserProfileDTO newSaveProfileDto=null;
	protected Boolean isRxAgreementSigned=null;

	PatientDTO patientDto = null;

	protected PrescriptionDTO trackedPrescription = new PrescriptionDTO();

	protected ValueExpression sortColumn;
	protected String sortBy;
	protected int rowsPerPage;
	
	// session scoped - concurrenct access monitor object.
	protected final AtomicInteger monitor = new AtomicInteger(0);
	protected Long lastRefreshTime = 0L;

	// abstract protected ResponseUtil lookupPrescriptions(PrescriptionService
	// prescriptionService);
	abstract protected List<PrescriptionDTO> lookupPrescriptions(Long userProfileId);

	abstract protected void loadEntities(UserProfileDTO userProfileDto);

	abstract public String trackDelivery(PrescriptionDTO prescriptionDTO);

	abstract public String trackingWarningPage();

	protected String getHomeURL() {
		return logoutUrl;
	}

	public String getAppContextRoot() {
		return appContextRoot;
	}

	public void authorizeRxHome(ComponentSystemEvent event) throws IOException {

		log.info("=====authorizeRxHome()==========");

		declineMessage = null;

		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		FacesContext context = FacesContext.getCurrentInstance();

		if (request.getUserPrincipal() == null) {
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "rxUnauthorized.xhtml");
		}
	}

	// TODO: process error response to show these in the GUI
	// protected void processErrorResponse(Exception ex) {
	// if(ex instanceof MHVException) {
	// MHVException mhve = (MHVException)ex;
	//
	// FacesContext.getCurrentInstance().addMessage(null,
	// new FacesMessage(FacesMessage.SEVERITY_ERROR, mhve.getErrorCode().name(),
	// mhve.getFailureMessage()));
	//
	// if(mhve.getValidationErrorMessages().size() > 0) {
	// for(String key : mhve.getValidationErrorMessages().keySet()) {
	// // add the validation messages to the Faces Context
	// FacesContext.getCurrentInstance().addMessage(null,
	// new FacesMessage(FacesMessage.SEVERITY_ERROR, String.format("Error
	// validating field: %s.", key),
	// mhve.getValidationErrorMessages().get(key)));
	// }
	// }
	// }
	// else {
	// FacesContext.getCurrentInstance().addMessage(null,
	// new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ex.get));
	// }
	// }

	/**
	 * Verifies the user's status. Forward to a failure page if the user is not
	 * a correlated patient otherwise creates the search criteria and loads the
	 * list medications accordingly.
	 */
	public void authorize(ComponentSystemEvent event) throws IOException {
		
		try {
			// declineMessage flag is used in Pharmacy Agreement portlet
			declineMessage = null;

			//Initialize the lastUpdatedTimeForList
			lastUpdatedTimeForList =  new Date();

			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			FacesContext context = FacesContext.getCurrentInstance();


			if (request.getUserPrincipal() == null) {
				context.getApplication().getNavigationHandler().handleNavigation(context, null, "rxUnauthorized.xhtml");
			} else {

				if (!context.isPostback()) {
					refillSubmitSucccess = null;
					isDuplicateRefillSubmitted = false;
					selectedRxRefillFacilityNames = null;
					setRowsPerPage(10);
				}else {
					saveSortInfo();
				}

				this.userProfileDto = getUserProfileDTOFromSession();
				this.patientDto = getPatientDTOFromSession();

				if (null != this.userProfileDto && null != this.userProfileDto.getId()) {
					if (null != this.userProfileDto.getName()) {
						firstName = this.userProfileDto.getName().getFirstName();
						lastName = this.userProfileDto.getName().getLastName();
					}
				}

				// user with a basic account type
				if (this.userProfileDto == null
						|| (this.userProfileDto != null && this.userProfileDto.getIsPatient() == null)
						|| (this.userProfileDto.getIsPatient() != null
								&& !this.userProfileDto.getIsPatient().booleanValue())
						|| this.patientDto == null) {

					if (log.isDebugEnabled()) {
						log.debug("User not privileged to see Rx data for the user profile id: "
								+ this.userProfileDto.getId());
					}
					// Forward the request to non patient page
					context.getApplication().getNavigationHandler().handleNavigation(context, null,
							"nonPatientRxPrescriptions.xhtml");
					return;
				}
			}


			 String portletId = (String) request.getAttribute(WebKeys.PORTLET_ID);

			// Check the RxAgreementSigned value from session, if it null, get the new value from the userMgmntService and save locally for further screen refreshes. 
			if ((this.userProfileDto.getRxAgreementSigned() == null) && (isRxAgreementSigned == null)) {
				isRxAgreementSigned = this.userMgmtService.getUserProfile(this.userProfileDto.getUserName()).getRxAgreementSigned();
			}
			else {
				isRxAgreementSigned = this.userProfileDto.getRxAgreementSigned();
			}

			// Rx Agreement page
			if (!BooleanUtils.isTrue(isRxAgreementSigned)) {
				if (portletId!=null && portletId.contains("mhvPrescriptionsHistory")){
					context.getApplication().getNavigationHandler().handleNavigation(context, null,
							"rxAgreementDisclaimersPrescriptionHistory.xhtml");
				}
				else if(portletId!=null && portletId.contains("mhvRxTracking")){
					context.getApplication().getNavigationHandler().handleNavigation(context, null,
							"rxAgreementDisclaimersPrescriptionsTracking.xhtml");
				}
				else {
					context.getApplication().getNavigationHandler().handleNavigation(context, null,
							"rxAgreementDisclaimers.xhtml");
				}
				return;
			}

			/*
			 * Perform facility update for a user who is Authenticated but not Correlated
			 */
			try {
				if(!this.patientDto.getCorrelationStatus().equals(PatientCorrelationStatusEnumeration.CORRELATED.getValue())){
					this.userMgmtService.DoRxIPACheck(this.patientDto.getId());
				}
			} catch (Exception e) {
				log.error("Error in calling DoRxIPACheck...<<<" + this.patientDto.getId() + ">>>: ", e);
			}
			
			// Load entities
			if (!context.isPostback()) {
				
				monitor.incrementAndGet();
				
				// Synchronize the Prescription Refresh operation
				synchronized(monitor) {
					try {
						if(monitor.get() >  WARN_ON_REPEAT_COUNT) {
							FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, 
									rxMessagesUtil.getWarnMultipleRefreshes(), rxMessagesUtil.getWarnMultipleRefreshes()));
						}
						
						if((System.currentTimeMillis() - this.lastRefreshTime) >  this.rxRefreshThreshold) {
							// Must refresh the pharmacy patient to incorporate any changes.
							refreshPharmacyPatient(getUserProfileIdFromSession());
						    loadEntitiesAndPopulateView(getUserProfileIdFromSession(), null);
						    this.lastRefreshTime = System.currentTimeMillis();
						}
					} finally {
						monitor.decrementAndGet();
					}
				}
				
				
			}
		} catch (Exception e) {
			if(this.userProfileDto!= null){
				log.error("Error in showDetail <<<" + this.userProfileDto.getId() +">>>: ", e);
			}
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			messageSeverity = "ERROR";
		} finally {

		}

	}

	protected  abstract void saveSortInfo();

	/**
	 * save user profile details
	 *
	 * @return
	 */
	protected String saveUserProfile(UserProfileDTO userProfile) throws MHVException {
		try {
			if (log.isDebugEnabled()) {
				log.debug("inside saveUserProfile");
			}
			this.userMgmtService.saveUserProfile(userProfile);
		} catch (MHVException e) {
			if(userProfile!= null){
				log.error("Error in storing updated user profile details <<<" + userProfile.getUserName() +">>>", e);
			}
			if (null != e.getFailureMessage() && e.getFailureMessage().length() > 0) {
				String errorMessage = e.getFailureMessage();
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage));
				messageSeverity = "ERROR";
			}
		}

		return null;
	}

	protected void updateTreatmentFacilitiesForExistingPatients(UserProfileDTO userProfileDto) {
		try {
			if (null != userProfileDto.getId() && null != patientDto.getId()) {
				userMgmtService.updateTreatmentFacilitiesForExistingPatients(userProfileDto.getId());
			} else {
				log.error("UserProfileId is null");
			}
		} catch (Exception e) {
			if(userProfileDto!= null){
				log.error("Error in fetching patient data <<<" + userProfileDto.getUserName() +">>>",  e);
			}
		}

		return;
	}

	/*
	 * public void refreshAction(UserProfileDTO userProfile) {
	 *
	 * // Must refresh the pharmacy patient to incorporate any changes.
	 * refreshPharmacyPatient(); return loadEntitiesAndPopulateView(null); }
	 */

	protected Date getLastUpdatedTime(Long userProfileId) {
		RequestDTO requestDto = null;
		Date lastUpdatedTime = null;

		try {
			if (null != userProfileId && userProfileId > 0) {
				requestDto = rxRefillServiceServiceProxy.getLastSuccessfulExtractRequest(userProfileId);
			} else {
				log.error("userName is null");
				throw new MHVRuntimeException("userName is null");
			}

			if (null != requestDto) {
				lastUpdatedTime = requestDto.getModifiedDate();
			}
		} catch (Exception e) {
			log.error("Error in fetching patient data <<<" + userProfileId +">>>", e);
			throw new MHVRuntimeException(e);
		}
		return lastUpdatedTime;
	}

	protected UserProfileDTO getUserProfileDTOFromSession() throws MHVException {
		UserProfileDTO userProfile;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			session = request.getPortletSession();

			String patientStr = (String) session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfile = mapper.readValue(patientStr, UserProfileDTO.class);

		} catch (Exception e) {
			throw new MHVException("Unable to get UserProfileDTO from session");
		}
		return userProfile;
	}

	protected PatientDTO getPatientDTOFromSession() throws MHVException {
		PatientDTO patient;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			session = request.getPortletSession();

			String patientStr = (String) session.getAttribute(PATIENT_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			patient = mapper.readValue(patientStr, PatientDTO.class);

		} catch (Exception e) {
			throw new MHVException("Unable to get PatientDTO from session");
		}
		return patient;
	}

	protected Long getPatientIdFromSession() throws MHVException {
		Long patientId = 0l;
		PortletSession session = null;
		try {

			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			session = request.getPortletSession();
			patientId = (Long) session.getAttribute(PATIENT_ID_KEY, PortletSession.APPLICATION_SCOPE);
		} catch (Exception e) {
			throw new MHVException("Unable to get Patient Id from Liferay Session");
		}
		return patientId;
	}

	protected Long getUserProfileIdFromSession() throws MHVException {
		Long userProfileId = 0l;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			session = request.getPortletSession();
			userProfileId = (Long) session.getAttribute(USER_PROFILE_ID_KEY, PortletSession.APPLICATION_SCOPE);
		} catch (Exception e) {
			throw new MHVException("Unable to get UserProfile Id from Liferay Session");
		}
		return userProfileId;
	}

	public void findUser() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {

		}
		if (user != null) {
			setFirstName(user.getFirstName());
			setLastName(user.getLastName());
		}
	}

	protected String getUserScreenName() throws MHVException {
		String userScreenName = null;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			session = request.getPortletSession();
			userScreenName = (String) session.getAttribute(USER_NAME_KEY, PortletSession.APPLICATION_SCOPE);
		} catch (Exception e) {
			throw new MHVException("Unable to get MHV User name from Liferay Session");
		}
		return userScreenName;

	}

	public String getMhvContext() {
		String context = PropsUtil.get("mhv.context");
		if (log.isDebugEnabled()) {
			log.debug("getMhvContext() : " + context);
		}
		return context;
	}

	protected void loadEntitiesAndPopulateView(Long userProfileId, Collection refillRequests) {
		TimerUtils timer = new TimerUtils();
		timer.start();

		// TODO: fix me
		prescriptions = getEntities(userProfileId, refillRequests);
		// saveEntities(entities);

		/*
		 * viewData = createPrescriptionViewData(); // Removed IPA check as per
		 * CR 6671 viewData.setEntityList(entities, getRequest());
		 *
		 * TransferObject request = ServiceDelegateFactory.
		 * createPrescriptionServiceDelegate().
		 * getLastSuccessfulExtractRequestForUser(pharmacyPatient). getEntity();
		 *
		 * lastUpdatedTimeForList = ((request == null ) ? null : ((Request)
		 * request).getModifiedDate());
		 */

		lastUpdatedTimeForList = getLastUpdatedTime(userProfileId);

		timer.stop();
		////if (log.isInfoEnabled()) {
		////	log.info("For::" + pharmacyPatientDto.getPatient().getUserProfile().getUserName()
		////			+ " loadEntitiesAndPopulateView:: Elapsed time in Seconds: " + timer.getElapsedTimeSecs());
		////}
		// return determineForward();
	}

	protected List<PrescriptionDTO> getEntities(Long userProfileId, Collection refillRequests) {
		List<PrescriptionDTO> prescriptions = lookupEntities(userProfileId);
		// TODO: Fix me - Prasad
		// this.lookupMessages =
		// ServiceResponseUtil.convertMessages(refillRequests, response,
		// getMessageIdPrefix());
		// this.handleMessages(response, null);

		/*
		 * if (! response.isFailure()) { activePrescriptions =
		 * (List<PrescriptionDTO>) response.getPojoObject(); }
		 */

		return prescriptions;
	}

	protected List<PrescriptionDTO> lookupEntities(Long userProfileId) {
		// return lookupPrescriptions(prescriptionService);
		return lookupPrescriptions(userProfileId);
	}

	public String submitRefillAction() {

		if (log.isDebugEnabled()) {
			log.debug("001 >>>>>>>>>>> inside AbstractRxController:submitRefillAction.......");
		}
		List<PrescriptionDTO> refillList = null;
		try {
			// Must refresh the pharmacy patient to incorporate any changes.
			refreshPharmacyPatient(getUserProfileIdFromSession());

			refillList = populateRefillList(prescriptions, true);

			if (refillList == null || refillList.size() == 0) {
				// always recreate the facility status messages
				// createStatusNotifications();

				// if the empty refillList is caused by submitting duplicates,
				// do nothing
				// TODO: isDuplicateRefillSubmitted might not required - prasad
				/*
				 * if (getViewData().isDuplicateRefillSubmitted()) { return
				 * determineForward(); }
				 */

				/* TODO - Ask Prasad for the Above comments - */
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, rxMessagesUtil.getRxrefillErrorNorefillselected(), rxMessagesUtil.getRxrefillErrorNorefillselected()));
				messageSeverity = "ERROR";

				return "refillPrescriptionsSummary";
			}

			if (log.isDebugEnabled()) {
				log.debug("inside AbstractRxController:submitRefillAction. refillList.size::" + refillList.size());
			}

			if (log.isDebugEnabled()) {
				log.debug("002 >>>>>>>>>>> inside AbstractRxController:submitRefillAction. refillList.size::"
						+ refillList.size());
			}
			// TODO: Fix getRefillPrescriptions - prasad
			// Collection refillRequests = getRefillPrescriptions(refillList);
			// return loadEntitiesAndPopulateView(userScreenName,
			// refillRequests);

			// TODO: Fix getRefillPrescriptions - prasad

			if (log.isDebugEnabled()) {
				log.debug(
						"003 >>>>>>>>>>> inside AbstractRxController:submitRefillAction. calling getRefillPrescriptions - userScreenName::"
								+ getUserScreenName());
			}
			Collection refillRequests = getRefillPrescriptions(getUserProfileIdFromSession(), refillList);
			//System.out.println(refillRequests.size());
			if (refillRequests != null) {
				if (log.isDebugEnabled()) {
				log.debug(
						"020a >>>>>>>>>>> inside AbstractRxController:submitRefillAction. calling loadEntitiesAndPopulateView - refillRequests Count::"
								+ refillRequests.size());
				}
			} else {
				if (log.isDebugEnabled()) {
					log.debug("020b >>>>>>>>>>> inside AbstractRxController:submitRefillAction. calling loadEntitiesAndPopulateView - refillRequests is null::");
				}
			}
			loadEntitiesAndPopulateView(getUserProfileIdFromSession(), null);

			// TODO: FIX ME - PRASAD
			selectedRxRefillFacilityNames = "";
			ArrayList<String> facilityNamesList = new ArrayList<String>();
		
			List<RequestDTO> requests = null;
			Date currentDate = null;
			Date modifiedDate = null;
			Date now = new Date();
			for (PrescriptionDTO rx : refillList) {
				requests = rxRefillServiceServiceProxy.getRequestByFunctionAndInstitution(rx.getUserId(), rx.getInstitution().getId());
				if(requests != null && requests.size()>0) {
					for (RequestDTO rqst : requests) {
						if(rqst != null && (rqst.getInstitution().getId() == rx.getInstitution().getId())) {
						
							if(rqst.getModifiedDate() != null) {
								currentDate = CommonUtility.getDaTeTime(now, "0", "0");
								modifiedDate = CommonUtility.getDaTeTime(rqst.getModifiedDate(), "0", "0");
									if(rqst.getRequestFunction() == 2 && rqst.getStatus().equalsIgnoreCase("successful") ) {
										if(currentDate != null && modifiedDate != null && modifiedDate.compareTo(currentDate) == 0) {
											facilityNamesList.add(rx.getFactilityName());
									}
								}
						
							}
						}
					
					}
				}
			}

			// convert to hashlist and copy back to arraylist to remove duplicates
			HashSet hs = new HashSet();
			hs.addAll(facilityNamesList);
			facilityNamesList.clear();
			facilityNamesList.addAll(hs);
			Collections.sort(facilityNamesList);

			Iterator<String> itr = facilityNamesList.iterator();
			int i=0;
			while(itr.hasNext()){
				selectedRxRefillFacilityNames = selectedRxRefillFacilityNames+","+itr.next();
			}

			refillSubmitSucccess = String.format(rxMessagesUtil.getRxrefillInfoVistaRefillsuccess(),selectedRxRefillFacilityNames.substring(1));  // Substring Removes extra , in the front
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, refillSubmitSucccess, refillSubmitSucccess));
			messageSeverity = "INFO";

		} catch (MHVException e) {
			try{
				log.error("Unable to refill prescriptions: <<<" + getUserScreenName() +">>>", e);
			}catch(Exception ex){
				log.error("Unable to refill prescriptions: <<>>", e);
			}
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Unable to refill", "Unable to refill"));
			messageSeverity = "ERROR";
				//jazz#364893
				for (PrescriptionDTO rx : refillList) {
					
				// to prevent user from requesting the same refills twice
				// by double-clicking the submit button
					rx.setIsRefillable(new Boolean(true));
				}
		}
		return "refillPrescriptionsSummary";
	}

	protected Collection getRefillPrescriptions(Long userProfileId, List<PrescriptionDTO> refillList)
			throws MHVException {

		/*
		 * PrescriptionServiceDelegate service = ServiceDelegateFactory.
		 * createPrescriptionServiceDelegate();
		 *
		 * VoidServiceResponse response = service.refillPrescriptions(
		 * pharmacyPatient, refillList);
		 *
		 * // Get requests with statuses from response message inserts
		 * Collection refillRequests = ServiceResponseUtil.
		 * removeRequestStatusMessages(response);
		 *
		 */
		if (log.isDebugEnabled()) {
			log.debug(
					"004 >>>>>>>>>>> inside AbstractRxController:getRefillPrescriptions. calling service refillPrescriptions - userProfileId::"
							+ userProfileId + " --- Refill Count::" + refillList.size());
		}

		List<RequestDTO> refillRequests = null;
		refillRequests = rxRefillServiceServiceProxy.refillPrescriptions(userProfileId, refillList);

		if (log.isDebugEnabled()) {
			log.debug(
					"019 >>>>>>>>>>> inside AbstractRxController:getRefillPrescriptions. calling service refillPrescriptions - userProfileId::"
							+ userProfileId + " --- Refill Count::" + refillList.size());
		}

		return refillRequests;
	}

	private void refreshPharmacyPatient(Long userProfileId) {
		if (null != userProfileId) {
			PharmacyPatientDTO pharmacyPatientDto = getPharmacyPatient(userProfileId);
			if (pharmacyPatientDto != null) {
				this.pharmacyPatientDto = pharmacyPatientDto;
				if (log.isInfoEnabled()) {
					log.info("For:: User Profile ID:" + userProfileId + ":: Pharmacy Patient:"
							+ pharmacyPatientDto.getPatient().getUserProfile().getUserName());
				}
			} else {
				this.pharmacyPatientDto = null;
				log.warn("Failed to refresh pharmacyPatient for user '" + userProfileId + "'");
			}
		}
	}

	private PharmacyPatientDTO getPharmacyPatient(Long userProfileId) {
		PharmacyPatientDTO pharmacyPatientDto = null;
		try {
			pharmacyPatientDto = rxRefillServiceServiceProxy.getPharmacyPatient(userProfileId);
			/*
			 * if (response.isSuccess()) { pharmacyPatientDto =
			 * (PharmacyPatientDTO) response.getPojoObject(); }
			 */
		} catch (Exception e) {
			log.error("Error in fetching PharmacyPatient : <<<" + userProfileId +">>>", e);
		}
		return pharmacyPatientDto;
	}

	protected List<PrescriptionDTO> populateRefillList(List<PrescriptionDTO> prescriptions, boolean toRefill) {

		if (log.isDebugEnabled()) {
			log.debug("Inside populateRefillList");
		}
		List<PrescriptionDTO> selectedRefillList = new ArrayList<PrescriptionDTO>();
		isDuplicateRefillSubmitted = false;

		for (PrescriptionDTO rx : prescriptions) {
			if (null != rx.getId() && rx.isSelected()) {

				if (log.isDebugEnabled()) {
					log.debug("selected prescription rx# for refill : " + rx.getPrescriptionNumber());
				}

				if (rx.getIsRefillable().booleanValue()) {

					selectedRefillList.add(rx);

					// to prevent user from requesting the same refills twice
					// by double-clicking the submit button
					if (toRefill) {
						rx.setIsRefillable(new Boolean(false));
					}
				} else {
					isDuplicateRefillSubmitted = true;
				}
			}
		}
		return selectedRefillList;
	}

	protected String getFormattedDate(Date date) {
		if (date == null)
			return "";
		SimpleDateFormat df = new SimpleDateFormat(LAST_UPDATED_DATE_FORMAT);
		String formattedDate = df.format(date);
		return formattedDate;
	}

	protected boolean checkRefillable(PrescriptionDTO rx) {
		if (null != rx.getIsRefillable() && rx.getIsRefillable().booleanValue())
			return true;
		else
			return false;
	}

	public String getDeclineMessage() {
		return declineMessage;
	}

	public void setDeclineMessage(String declineMessage) {
		this.declineMessage = declineMessage;
	}

	public List<PrescriptionDTO> getPrescriptions() {
		return prescriptions;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastUpdatedTimeForList() {
		return getFormattedDate(lastUpdatedTimeForList);
	}

	public void setLastUpdatedTimeForList(Date lastUpdatedTimeForList) {
		this.lastUpdatedTimeForList = lastUpdatedTimeForList;
	}

	public String getRefillSubmitSucccess() {
		return refillSubmitSucccess;
	}

	public void setRefillSubmitSucccess(String refillSubmitSucccess) {
		this.refillSubmitSucccess = refillSubmitSucccess;
	}

	public String getMessageSeverity() {
		return messageSeverity;
	}

	public void setMessageSeverity(String messageSeverity) {
		this.messageSeverity = messageSeverity;
	}

	public String getDrugImagesRoot() {
		return drugImagesRoot;
	}

	public String getPresName() {
		return presName;
	}

	public void setPresName(String presName) {
		this.presName = presName;
	}

	public String getPresNumber() {
		return presNumber;
	}

	public void setPresNumber(String presNumber) {
		this.presNumber = presNumber;
	}

	public String getPresImageUrl() {
		return presImageUrl;
	}

	public void setPresImageUrl(String presImageUrl) {
		this.presImageUrl = presImageUrl;
	}
	public String getCurrentRxId() {
		return currentRxId;
	}

	public void setCurrentRxId(String currentRxId) {
		this.currentRxId = currentRxId;
	}

	public RxTrackingDTO getTrackingDetailsForImage() {
		return trackingDetailsForImage;
	}

	public void setTrackingDetailsForImage(RxTrackingDTO trackingDetailsForImage) {
		this.trackingDetailsForImage = trackingDetailsForImage;
	}

	public String generateTrackingLink(PrescriptionDTO prescriptionDTO, RxTrackingDTO rxTrackingDTO) {
		String carrier = "";
		String trackingNumber = "";
		String urlString = "";

		carrier=rxTrackingDTO.getCarrier();
		trackingNumber=rxTrackingDTO.getTrackingNumber();

		// Build Carrier Link
		if (carrier.compareTo("UPS") == 0) {
			String ups_link = "http://wwwapps.ups.com/WebTracking/processInputRequest?HTMLVersion=5.0&loc=en_US&Requester=UPSHome&tracknum=";
			urlString = ups_link + trackingNumber;
		} else if (carrier.compareTo("USPS") == 0) {
			String usps_link = "https://tools.usps.com/go/TrackConfirmAction_input?qtc_tLabels1=";
			urlString = usps_link + trackingNumber;
		} else if (carrier.compareTo("DHL") == 0) {
			String dhl_link = "http://webtrack.dhlglobalmail.com/?id=462&trackingnumber=";
			urlString = dhl_link + trackingNumber;
		} else {
			// Need to fix this. It should not come here if there is no defoined
			// carrier.
			urlString = trackingNumber;
		}
		setUrlString(urlString);
		setTrackedPrescription(prescriptionDTO);
		return trackingWarningPage();

	}

	public String leaveSite() {
		savePrescriptionTrackingActivity(getUserProfileDto(), getTrackedPrescription());
		ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
		try {
			externalContext.redirect(getUrlString());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return trackingWarningPage();
	}

	public String populateTrackingImageTableRows(PrescriptionDTO prescriptionDTO, RxTrackingDTO rxTrackingDTO) {
		String ndc = "";
		String folderName = "";
		String fileName = "";
		String uriString = getDrugImagesRoot();
		List folderNames = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9");
		presName = prescriptionDTO.getDrugName();
		presNumber = rxTrackingDTO.getRxNumber();
		ndc = rxTrackingDTO.getNdc(); // Remove all spaces in NDC
		folderName = ndc.replaceFirst("^0+(?!$)", "").substring(0, 1);
		fileName = "NDC" + ndc + ".jpg";
		setPresName(presName);
		setPresNumber(presNumber);

		// check if the foldername is one of the listed folders. if not, set
		// folder name to "other";
		if (!folderNames.contains(folderName))
			folderName = "other";

		uriString = uriString + folderName + "/" + fileName;
		boolean imageFound=false;
		URL url;
		try {

			url = new URL(uriString);
			HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
			con.connect();
			int code = con.getResponseCode();

			if (code==200) {
				imageFound=true;
			}



		} catch (Exception e) {
			imageFound=false;
		}

		if(imageFound) {
			setPresImageUrl(uriString);
		}
		else {
			setPresImageUrl("");
		}

		return imagePage;

	}

	/**
	 * save user profile details
	 * @param prescription TODO
	 *
	 * @return
	 */
	protected void savePrescriptionTrackingActivity(UserProfileDTO userProfile, PrescriptionDTO prescription) {
		try {

			ActivityDTO activity = new ActivityDTO();

			activity.setAction(ActivityActionTypeEnumeration.PRESCRIPTION.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.TRACK.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.SELF.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setStatus(true);
			String detailValue=prescription.getDispRxNumber() + " RX Name: " + prescription.getDrugName();
			activity.setDetailValue(detailValue);

			this.accountActivityService.createAccountActivityLog(activity);

		} catch (Exception e) {
			if(userProfile!=null){
				log.error("Error in storing updated user profile details <<<" + userProfile.getUserName() + ">>>", e);
			}
			throw new MHVRuntimeException("Error in storing updated user profile details " + e.getMessage());
		}
	}

	public String getImagePage() {
		return imagePage;
	}

	public void setImagePage(String imagePage) {
		this.imagePage = imagePage;
	}

	public String getUrlString() {
		return urlString;
	}

	public void setUrlString(String urlString) {
		this.urlString = urlString;
	}

	public UserProfileDTO getUserProfileDto() {
		return userProfileDto;
	}

	public void setUserProfileDto(UserProfileDTO userProfileDto) {
		this.userProfileDto = userProfileDto;
	}

	/**
	 * @return the rxRefillServiceServiceProxy
	 */
	public PharmacyRefillWebService getRxRefillServiceServiceProxy() {
		return rxRefillServiceServiceProxy;
	}

	/**
	 * @param rxRefillServiceServiceProxy
	 *            the rxRefillServiceServiceProxy to set
	 */
	public void setRxRefillServiceServiceProxy(PharmacyRefillWebService rxRefillServiceServiceProxy) {
		this.rxRefillServiceServiceProxy = rxRefillServiceServiceProxy;
	}

	public PrescriptionDTO getTrackedPrescription() {
		return trackedPrescription;
	}

	public void setTrackedPrescription(PrescriptionDTO trackedPrescription) {
		this.trackedPrescription = trackedPrescription;
	}

	public ValueExpression getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}

	public int getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}

	public UserProfileDTO getNewSaveProfileDto() {
		return newSaveProfileDto;
	}

	public void setNewSaveProfileDto(UserProfileDTO newSaveProfileDto) {
		this.newSaveProfileDto = newSaveProfileDto;
	}


	// /**
	// * @return the patientServiceProxy
	// */
	// public PatientWebService getPatientServiceProxy() {
	// return patientServiceProxy;
	// }
	//
	// /**
	// * @param patientServiceProxy
	// * the patientServiceProxy to set
	// */
	// public void setPatientServiceProxy(PatientWebService patientServiceProxy)
	// {
	// this.patientServiceProxy = patientServiceProxy;
	// }

}
