package gov.va.med.mhv.rxrefill.service.impl.util;

import gov.va.med.mhv.rxrefill.data.model.Institution;
import gov.va.med.mhv.rxrefill.data.repository.InstitutionRepository;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UtilityMethods {
	private static Logger log = LogManager.getLogger(UtilityMethods.class);
	
	@Autowired
	private InstitutionRepository institutionRepository; 
	
	public Institution getInstitution(String stationNumber) {
		List<Institution> institutions = null;
		try {
			institutions = institutionRepository.getInstitutionForStationNumber(stationNumber);
		} catch(Exception e) {
			log.error("Error in fetching institutions ", e);
			throw new MHVRuntimeException("Error in fetching institutions " + e.getMessage(), e);
		}
		
		return (!institutions.isEmpty()) ? ((Institution) institutions.get(0)) : null;
	}
	
	public static Date getDateWithoutTime(Date date) {
		Date dateWithoutTime = null;
		if (date != null) {
			GregorianCalendar calendar = new GregorianCalendar();
			calendar.clear();
			calendar.setTime(date);
			int year = calendar.get(Calendar.YEAR); 
			int month = calendar.get(Calendar.MONTH); 
			int day = calendar.get(Calendar.DAY_OF_MONTH);
			
			calendar = new GregorianCalendar(year, month, day);
			dateWithoutTime = calendar.getTime(); 
		
		}
		return dateWithoutTime;
	}
	
	public static Timestamp dateToTimestamp(Date date) {
		return (date != null) ? new Timestamp(date.getTime()) : null;
	}
}
