package gov.va.med.mhv.rxrefill.service.impl.util;

import gov.va.med.mhv.rxrefill.data.model.Request;


public final class RxRequestMessages {
	
	public static final String REQUEST_STATUS = "prescriptionservice.request";
	public static final String MESSAGING_ERROR =  "rxrequestvistaservice.messaging.error";
	public static final String STATUS_ERROR = "rxrequestvistaservice.status.error";
	public static final String UNEXPECTED_ERROR = "rxrequestvistaservice.unexpected.error";

	/**
	 * 
	 */
	private RxRequestMessages() {
		// Hide for Utility class
	}

	public static boolean isMessagingError(String key) {
		return (key != null) && (MESSAGING_ERROR.equalsIgnoreCase(key) || UNEXPECTED_ERROR.equalsIgnoreCase(key));
	}

	public static boolean isStatusError(String key) {
		return (key != null) && STATUS_ERROR.equalsIgnoreCase(key);
	}

	public static String createRequestStatusMessage(Request request) {
		return String.format(RxRequestMessages.REQUEST_STATUS + " %s",identify(request));
	}
	
	public static String createStatusErrorMessage(Request request) {
		return String.format(RxRequestMessages.STATUS_ERROR + " %s",identify(request));
	}
	
	public static String createMessagingErrorMessage(Request request) {
		return String.format(RxRequestMessages.MESSAGING_ERROR + " %s",identify(request));
	}
	
	public static String createUnexpectedErrorMessage(Request request) {
		return String.format(RxRequestMessages.UNEXPECTED_ERROR + " %s",identify(request));
	}
	
	private static String identify(Request request) {
		return (request != null) ? request.getId()+"-"  : "<unknown>";
	}
}
