package gov.va.med.mhv.rxrefill.service.impl.util;

import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.data.model.Request;
import gov.va.med.mhv.rxrefill.data.model.RequestAttempt;
import gov.va.med.mhv.rxrefill.data.repository.PrescriptionRequestRepository;
import gov.va.med.mhv.rxrefill.enums.RequestStatusEnumeration;
import gov.va.med.mhv.rxrefill.service.PrescriptionRefreshResponseProcessor;
import gov.va.med.mhv.rxrefill.service.RxRequestVistaService;
import gov.va.med.mhv.rxrefill.util.RequestUtils;

@Component
public class RxRequestHelper {

	private static Logger log = LogManager.getLogger(RxRequestHelper.class);

	@Autowired
	private RequestUtils requestUtils;

	@Autowired
	private PrescriptionRequestRepository prescriptionRequestRepository;

	@Autowired
	private RxRequestVistaService rxRequestVistaService;
	
	@Autowired
	private PrescriptionRefreshResponseProcessor responseProcessor;

	@SuppressWarnings("unchecked")
	public ResponseUtil sendRequest(Patient patient, Request request)
	{
		if (log.isDebugEnabled()) {
			log.debug(String.format("inside sendRequest patientId : %s requestId %s", patient.getId(), request.getId()));
		}

		RequestAttempt attempt = null;
		for (RequestAttempt tmp : request.getRequestAttempts()) {
			if (requestUtils.isInProgress(tmp)) {
				// there may be only one in-progress attempt
				attempt = tmp;
				break;
			}
		}

		/*PrescriptionCollectionServiceResponse response = null;
		PrescriptionCollectionServiceResponse re = ServiceFactory.createRxRequestVistaService().sendRxRequest(patient, request);
		response = new PrescriptionCollectionServiceResponse();*/

		ResponseUtil response = new ResponseUtil();
		ResponseUtil re = rxRequestVistaService.sendRxRequest(patient, request);

		//TODO: Fix me - Prasad
		/*Messages messages = re.getMessages();
		if (messages.getInformationalMessageCount() > 0) {
			for (Object m: messages.getInformationalMessages()) {
				Message message = (Message) m;
				if (RxRequestMessages.isMessagingError(message)) {
					processBadResponse(request, attempt, RequestStatusEnumeration.FAILED.getDescription());
					return response;
				} else if (RxRequestMessages.isStatusError(message)) {
					processBadResponse(request, attempt, RequestStatusEnumeration.REJECTED.getDescription());
					return response;
				}
			}
		}
		response.getMessages().addMessages(messages);

		List<Prescription> resultPrescriptions = processResponse(request, attempt, re.getPrescriptions());
		for (Object o: resultPrescriptions) {
			Prescription prescription = (Prescription) o;
			response.addPrescription(prescription);
		}*/

		Map<String, String> infoMessages = re.getInfoMessages();
		if (null != infoMessages && infoMessages.size() > 0) {
			log.info("infoSize : " + infoMessages.size());
			for (String key: infoMessages.keySet()) {
				log.debug("key : " + key);
				if (RxRequestMessages.isMessagingError(key)) {
					this.responseProcessor.processBadResponse(request, attempt, RequestStatusEnumeration.FAILED.getDescription());
					log.info("inside for : FAILED");
					response.getInfoMessages().putAll(infoMessages);
					return response;
				} else if (RxRequestMessages.isStatusError(key)) {
					this.responseProcessor.processBadResponse(request, attempt, RequestStatusEnumeration.REJECTED.getDescription());
					log.info("inside for : REJECTED");
					response.getInfoMessages().putAll(infoMessages);
					return response;
				}
			}
		}

		log.info("outside for....");
		response.getInfoMessages().putAll(infoMessages);

		List<Prescription> prescriptions = (List<Prescription>) re.getPojoObject();
		if (log.isDebugEnabled()) {
			log.debug("prescriptions size " + ((null != prescriptions) ? prescriptions.size() : 0));
		}

		List<Prescription> resultPrescriptions = null;

		if (null != prescriptions && prescriptions.size() > 0) {
			resultPrescriptions = this.responseProcessor.processResponse(request, attempt, prescriptions);
		} else {
			log.error("prescriptions is null");
			response.setFailure(false);
			response.setSuccess(true);
			response.setPojoObject(null);
			return response;
		}

		if (log.isDebugEnabled()) {
			log.debug("resultPrescriptions size " + ((null != resultPrescriptions) ? resultPrescriptions.size() : 0));
		}

		response.setFailure(false);
		response.setSuccess(true);
		response.setPojoObject(resultPrescriptions);
		return response;
	}
}
