package gov.va.med.mhv.rxrefill.service.impl.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.rxrefill.data.model.Institution;
import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.data.model.Request;
import gov.va.med.mhv.rxrefill.data.repository.RequestRepository;
import gov.va.med.mhv.rxrefill.enums.RequestFunctionEnumeration;
import gov.va.med.mhv.rxrefill.service.ExtractRequestCreator;
import gov.va.med.mhv.rxrefill.util.RequestUtils;
import gov.va.med.mhv.rxrefill.util.RxMessagesUtil;

@Component
public class RxRequestDispatcher {

	private static Logger log = LogManager.getLogger(RxRequestDispatcher.class);

	@Autowired
	private RxMessagesUtil rxMessagesUtil;

	@Autowired
	private RequestRepository requestRepository;

	@Autowired
	private RequestUtils requestUtils;

	@Autowired
	private RxRequestStrategy strategy;

	@Autowired
	private RxRequestHelper rxRequestHelper;
	
	@Autowired
	private ExtractRequestCreator requestCreator;

	private boolean testInstitution(Institution institution) {
		boolean result = ((institution != null)
				&& institution.getIsTreatment().equalsIgnoreCase("Y")
				&& institution.getIsActive().equalsIgnoreCase("Y"));
		if (log.isDebugEnabled()) {
					log.debug(" 100c >>>>>>>>>>>> testInstitution result:: "+result);
		}
		return result;
	}

	public int dispatchRefillRequests(Patient patient, List<Prescription> prescriptions, ResponseUtil response) {
		log.info("================= inside dispatchRefillRequests - begining==========================");
		if (log.isDebugEnabled()) {
					log.debug(" 70 >>>>>>>>>>>> in side dispatchRefillRequests - begining");
		}
		Hashtable<Long, List<Prescription>> mappedPrescriptions = new Hashtable<Long, List<Prescription>>();
		for (Prescription prescription: prescriptions) {
			Long institutionId = prescription.getInstitution().getInstitutionId();
			if (!mappedPrescriptions.keySet().contains(institutionId)) {
				mappedPrescriptions.put(institutionId, new ArrayList<Prescription>());
			}
			if (log.isDebugEnabled()) {
						log.debug(" 70a >>>>>>>>>>>> institutionId - "+institutionId+"   ----- prescription"+prescription);
			}
			mappedPrescriptions.get(institutionId).add(prescription);

		}

			if (log.isDebugEnabled()) {
						log.debug(" 70b >>>>>>>>>>>> mappedPrescriptions size "+mappedPrescriptions.size());
			}

		List<Request> requests = new ArrayList<Request>();
		for (Long institutionId: mappedPrescriptions.keySet()) {
			List<Prescription> list = mappedPrescriptions.get(institutionId);
			Prescription prescription = list.iterator().next();
			Institution institution = prescription.getInstitution();

			if (testInstitution(institution) && strategy.checkSendRefillRequest(patient, institution)) {
				Timestamp now = UtilityMethods.dateToTimestamp(new Date());
				Request request = this.requestCreator.createRefillRequest(now, list);
				requests.add(request);
				if (log.isDebugEnabled()) {
							log.debug(" 71 >>>>>>>>>>>> in side dispatchRefillRequests - calling dispatchRequest - 2");
				}
				ResponseUtil re = dispatchRequest(patient, request);
				
				Map<String, String> infoMessages = re.getInfoMessages();
				if (null != infoMessages && infoMessages.size() > 0) {
					for (String key: infoMessages.keySet()) {
							response.getInfoMessages().putAll(infoMessages);
					}
				}				
			} else if (institution == null) {
				log.error(String.format("Request information for prescription '%s', but no associated institution. Please check INSTITUTION(S) table.",
						prescription.getPrescriptionNumber()));
				response.setFailure(true);
				response.setFailureMessage(rxMessagesUtil.getErrorVistaSystemfailure());
			} else {
				// User cannot change situation, so not alerting user,
				// just ignoring.
				log.error(String.format("Request information for patient %s from institution (Name: %s ; SN: %s) which is not a treatment nor an active facility",
						patient.getId(), institution.getName(), institution.getStationNumber()));
			}
		}
		collectRequestStatuses(requests, response);

		if (log.isDebugEnabled()) {
			log.debug("==== exiting dispatchRefillRequests requests.size() : " + requests.size());
		}
		return requests.size();
	}
	

	public int dipatchExtractRequests(Patient patient, ResponseUtil response) {
		if (log.isDebugEnabled()) {
			log.debug(" 80 >>>>>>>>>>>> in side dipatchExtractRequests - profile");
		}
		return dispatchRequest(patient, response, RequestFunctionEnumeration.GETPRESCRIPTIONPROFILE.getValue());
	}

	public int dipatchStatusRequests(Patient patient, ResponseUtil response) {
		if (log.isDebugEnabled()) {
					log.debug(" 81 >>>>>>>>>>>> in side dipatchStatusRequests - status");
		}
		return dispatchRequest(patient, response, RequestFunctionEnumeration.GETPRESCRIPTIONSTATUS.getValue());
	}

	private int dispatchRequest(Patient patient, ResponseUtil response, int function) {		
		if (log.isDebugEnabled()) {
					log.debug(" 90 >>>>>>>>>>>> in side dispatchRequest - calling multiplexExtractRequests - response.getInfoMessages().size()::"+response.getInfoMessages().size());
		}
		List<Request> requests = this.requestCreator.multipleExtractRequests(patient, function, response);
		
		for (Request request: requests) {
			ResponseUtil re = dispatchRequest(patient, request);
			
			Map<String, String> infoMessages_r = response.getInfoMessages();
			Map<String, String> infoMessages = re.getInfoMessages();
			if (log.isDebugEnabled()) {
				log.debug(" 90a >>>>>>>>>>>> in side dispatchRequest for loop - infoMessages.size()::"+infoMessages.size());
			}			
			if (null != infoMessages && infoMessages.size() > 0) {
				
				for (String key: infoMessages.keySet()) {
						if (key.contains("error")) {							
							//+"-"+request.getInstitution().getName()
							infoMessages.put(key,infoMessages_r.get(key)+","+request.getInstitution().getName());
						}
						response.getInfoMessages().putAll(infoMessages);
						if (log.isDebugEnabled()) {
							log.debug(" 90aa >>>>>>>>>>>> copy messages to response - response.getInfoMessages()::"+response.getInfoMessages().size());
						}
				}
			}
			if (log.isDebugEnabled()) {
				log.debug(" 90b >>>>>>>>>>>> in side dispatchRequest for loop - response.getInfoMessages().size()::"+response.getInfoMessages().size());
			}			
		}
		
		
		if (log.isDebugEnabled()) {
			log.debug(" 92a >>>>>>>>>>>> in side dispatchRequest - requests count -"+requests.size());
			log.debug(" 92a >>>>>>>>>>>> in side dispatchRequest - response.getInfoMessages().size() -"+response.getInfoMessages().size());
		}
		collectRequestStatuses(requests, response);

		if (log.isDebugEnabled()) {
			log.debug("  92a >>>>>>>>>>>> in side dispatchRequest - exiting dispatchRequest requests.size() : " + requests.size());
		}

		return requests.size();
	}

	private ResponseUtil dispatchRequest(Patient patient, Request request) {
		if (log.isDebugEnabled()) {
			log.debug("inside dispatching requests...");
		}
		if (log.isDebugEnabled()) {
					log.debug(" 91 >>>>>>>>>>>> in side dispatchRequest - calling sendRequest");
		}
        return rxRequestHelper.sendRequest(patient, request);
	}

	private void collectRequestStatuses(List<Request> requests, ResponseUtil response) {
		if (log.isDebugEnabled()) {
			log.debug("==============inside collectRequestStatuses()==============");
		}
		if (requests.isEmpty()) {
			if (log.isDebugEnabled()) {
				log.debug(" 92 >>>>>>>>>>>> in side collectRequestStatuses - requests is empty.");
			}
			return;
		}

		if (log.isDebugEnabled()) {
			log.debug(" 93 >>>>>>>>>>>> in side collectRequestStatuses - requests count -"+requests.size());
		}

		for (Request cachedRequest: requests) {
			if (!requestUtils.isInProgress(cachedRequest)) {
				if (log.isDebugEnabled()) {
					log.debug(" 94 >>>>>>>>>>>> in side collectRequestStatuses - status NOT in Progress:"+cachedRequest.getStatus()+" -"+requestUtils.isInProgress(cachedRequest));
				}
				continue;
			}

			if (log.isDebugEnabled()) {
				log.debug(" 94 >>>>>>>>>>>> in side collectRequestStatuses - status IN Progress -"+requestUtils.isInProgress(cachedRequest));
			}

			//RequestBO requestBO = RequestBO.findByPrimaryKey(cachedRequest.getRequestPK());
			Request request = null;
			try{
				request = requestRepository.findOne(cachedRequest.getId());
			} catch(Exception e) {
				log.error("Error in fetching request from DB ", e);
				//throw new MHVRuntimeException("Error in fetching request from DB " + e.getMessage(), e);
			}

			if (request != null) {
				if (!requestUtils.isInProgress(request)) {
					cachedRequest.setStatus(request.getStatus());
                }
				cachedRequest.setModifiedDate(request.getModifiedDate());
			}
		}

		for (Request request: requests) {
			/*response.getMessages().addMessage(MessageUtils.
				createInformationalMessage(RxRequestMessages.REQUEST_STATUS,
		            // add property so messages are allowed for various
					// institutions
					new String[] { request.getInstitution().getName() },
					new Object[] { request } ));*/
			if (log.isDebugEnabled()) {
				log.debug(" 94a >>>>>>>>>>>> in side collectRequestStatuses - REQUEST_STATUS value:: -"+RxRequestMessages.createRequestStatusMessage(request));
			}
			
			response.getInfoMessages().put(RxRequestMessages.REQUEST_STATUS, RxRequestMessages.createRequestStatusMessage(request));
		}
	}

}
