package gov.va.med.mhv.rxrefill.service.impl;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.converter.MedicationHistoryConverter;
import gov.va.med.mhv.rxrefill.data.model.MedicationHistory;
import gov.va.med.mhv.rxrefill.data.repository.MedicataionHistoryRepository;
import gov.va.med.mhv.rxrefill.dto.MedicationHistoryDTO;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;
import gov.va.med.mhv.rxrefill.service.MedicationSupplementService;
import gov.va.med.mhv.rxrefill.service.validator.MedicationsValidator;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MedicationSupplementServiceImpl implements MedicationSupplementService {
	
	private static Logger log = LogManager.getLogger(MedicationSupplementServiceImpl.class);

	@Autowired
	private MedicationsValidator validator;
	
	@Autowired
	private MedicataionHistoryRepository medicataionHistoryRepository;
	
	@Autowired
	private MedicationHistoryConverter medicationHistoryConverter;
	
	@Override
	public String test(String sampleText) {
		return sampleText;
	}

	@Override
	public List<MedicationHistoryDTO> getMedicationsByUserId(Long userId) throws MHVException {
		List<MedicationHistoryDTO> medicationDtos = null;
		List<MedicationHistory> medications = null;
		try {
			medications = medicataionHistoryRepository.getMedicationsByUserId(userId);
		} catch(Exception e) {
			log.error("Error in fetching med hits " + e);
			throw new MHVException("Error in fetching med hits ", e);
		}
		
		if (null != medications && medications.size() > 0) {
			medicationDtos = new ArrayList<MedicationHistoryDTO>();
			for (MedicationHistory medHist : medications) {
				medicationDtos.add(medicationHistoryConverter.convert(medHist));
			}
		}
		
		return medicationDtos;
	}
	
	@Override
	public MedicationHistoryDTO getMedicationsById(Long medicationId) throws MHVException {
		MedicationHistoryDTO medicationDto = null;
		MedicationHistory medication = null;
		try {
			medication = medicataionHistoryRepository.findOne(medicationId);
		} catch(Exception e) {
			log.error("Error in fetching med hits " + e);
			throw new MHVException("Error in fetching med hits ", e);
		}
		
		if (null != medication) {
			medicationDto = medicationHistoryConverter.convert(medication);
		}
		
		return medicationDto;
	}

	@Override
	public MedicationHistoryDTO saveMedication(MedicationHistoryDTO medicationDto) throws MHVException {
		ResponseUtil<MedicationHistory> response = new ResponseUtil<MedicationHistory>();
		MedicationHistory medication = null;
		
		response = validator.fieldValidation(medicationDto);
		
		// input validation errors
		if (response.getValidationErrors().size() > 0) {
			response.setFailure(true);
			throw new MHVException(response);
		}
		
		try {		
			medication = medicationHistoryConverter.convert(medicationDto);
			medication = medicataionHistoryRepository.save(medication);
		} catch(Exception e) {
			log.error("Error in storing medication " + e);
			response.setFailure(true);
			response.setFailureMessage("Error in storing medication ");
			throw new MHVException(response);
		}
		
		return medicationDto;
	}
	
	@Override
	public ResponseUtil deleteMedication(Long medicationId) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		
		try {
			medicataionHistoryRepository.delete(medicationId);
		} catch(Exception e) {
			log.error("Error in deleting medication " + e);
			response.setFailure(true);
			response.setFailureMessage("Error in deleting medication. ");
			throw new MHVException("Error in deleting medication.");
		}
		
		response.setSuccess(true);
		response.setPojoObject(Boolean.TRUE);
		
		return response;
	}
}
