package gov.va.med.mhv.rxrefill.essapi.service.impl;



import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.ErrorTO;
import gov.va.med.mhv.common.api.transfer.Session;
import gov.va.med.mhv.common.api.util.MHVApiUtility;
import gov.va.med.mhv.common.api.util.MHVEssApiUtility;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.converter.PrescriptionConverter;
import gov.va.med.mhv.rxrefill.data.model.PharmacyPatient;
import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.data.model.Request;
import gov.va.med.mhv.rxrefill.data.model.RxTracking;
import gov.va.med.mhv.rxrefill.data.repository.PrescriptionRepository;
import gov.va.med.mhv.rxrefill.data.repository.RxTrackingRepository;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.dto.RxTrackingDTO;
import gov.va.med.mhv.rxrefill.essapi.service.RxAPIService;
import gov.va.med.mhv.rxrefill.essapi.service.util.RxAPIServiceHelper;
import gov.va.med.mhv.rxrefill.essapi.transfer.OtherPresListIncluded;
import gov.va.med.mhv.rxrefill.essapi.transfer.PrescriptionTO;
import gov.va.med.mhv.rxrefill.essapi.transfer.PrescriptionsTO;
import gov.va.med.mhv.rxrefill.essapi.transfer.TrackingInfoDetailsTO;
import gov.va.med.mhv.rxrefill.essapi.transfer.TrackingInfoTO;
import gov.va.med.mhv.rxrefill.service.PrescriptionService;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.service.PatientWebService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author muazzam
 *
 */
public class RxAPIServiceImpl implements RxAPIService {
	
	@Resource
	private UserMgmtService userMgmtServiceProxy;
	
	@Resource
	private PatientWebService patientWebProxy;
	
	@Resource(name = "activityProxy")
	private AccountActivityCreatorService accountActivityCreatorService;

	
	@Autowired
	private PrescriptionService prescriptionService;
	
	@Autowired
	private PrescriptionConverter prescriptionConverter;
	
	@Autowired
	private PrescriptionRepository prescriptionRepository;
	
	@Autowired
	private RxTrackingRepository rxTrackingRepository; 
	
	@Resource
	RxAPIServiceHelper rxServceHelper;
		
	private static final Log log = LogFactory.getLog(RxAPIServiceImpl.class);

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.api.patient.service.RxAPIService#getActivePrescriptions()
	 */
	@Override
	public PrescriptionsTO getActivePrescriptions() {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		PrescriptionsTO presTOs = new PrescriptionsTO();
		List<PrescriptionTO> presList = new ArrayList<PrescriptionTO>();;
		//RxAPIServiceHelper rxServceHelper = new RxAPIServiceHelper();
		if(uf != null) {
			boolean isSigned = rxServceHelper.isRxAgreementSigned(uf);
			if( !isSigned ) {
				MHVEssApiUtility.throwException(ErrorEnum.RX_AGREEMENT_NOT_ACCEPTED_135);
			}
			
			PatientDTO pat = getPatientDTO(uf);

			if(pat != null) {
				try {
					PharmacyPatient pharmPat = getPharmacyPatient(uf, pat);
					if (pharmPat != null) {
						
						ResponseUtil<List<PrescriptionDTO>> responseUtil = prescriptionService.getActivePrescriptions(pharmPat);
						
						StringBuffer failedStationList = new StringBuffer();
						String lastUpdatedtime = null;
						List<Request> request = prescriptionService.getLastSuccessfulExtractRequestForUser(pharmPat);
						if(!request.isEmpty() && request.get(0) != null) {
							lastUpdatedtime = MHVApiUtility.convertDateToMMDDYYYY(request.get(0).getModifiedDate());
						}	
						/*
						//Starting to clean up message...
						StringBuffer failedStationList = new StringBuffer();
						Messages filteredMessages = ServiceResponseUtil.convertMessages(null, response, "rxrefill.");

				        RequestServiceResponse reqServRes =  presServiceDelegate.getLastSuccessfulExtractRequestForUser(pharmPat);
				        String lastUpdatedtime = null;
				        if (reqServRes.getRequest() != null && reqServRes.getRequest().getModifiedDate() != null) {
				        	lastUpdatedtime = MHVEssApiUtility.convertDateToRFC1123Pattern(reqServRes.getRequest().getModifiedDate());
				        }
						if ( !filteredMessages.getInformationalMessages().isEmpty() ){
							Collection<Message> messages = filteredMessages.getInformationalMessages();
							for(Message message: messages) {
								Iterator it = message.getInserts().iterator();
								while (it.hasNext()) {
									failedStationList.append(it.next().toString());
									if (it.hasNext())
											failedStationList.append(",");
								}

							}
						}
						*/
						//Adding some message stuff in SRE structure
						LinkedHashMap<String, String> messageList = responseUtil.getInfoMessages();
						if (!messageList.isEmpty()) {
						     System.out.println("<<<<<< Inside MessageList >>>>>>>>>>");
							for(String key : messageList.keySet()) {
						         String message = messageList.get(key);
						         System.out.println("Message for key : " +key+ "  :Message: " + message);
						    }
						}
						//Ended Here
						try {
							accountActivityCreatorService.createAccountActivityLog(
														ActivityHelper.createActivityDTOForSelf(
														uf.getId(), 
														responseUtil.getFailureMessage()!= null ? false:true, 
														ActivityTypeEnumeration.RXREFILL, 
														ActivityActionTypeEnumeration.VIEW_ACTIVE_PRESCRIPTION, 
														MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
														);
						} catch (MHVException e) {
							log.error("Exception occured in Activity Track", e);
							MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
						}
						
						MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, responseUtil);
						Collection entities = responseUtil.getPojoObject();
						presTOs.setFailedStationList(failedStationList.toString());
						presTOs.setLastUpdatedTime(lastUpdatedtime);
						if (entities != null) {
							for (Object e: entities) {
								PrescriptionDTO rx = (PrescriptionDTO) e;
								presList.add(rxServceHelper.convertToPrescriptionTO(rx));
							}
							presTOs.setPrescriptionList(presList);
						}

					}
					else {
						MHVEssApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
					}
				}catch ( Exception e) {
					e.printStackTrace();
					MHVEssApiUtility.throwException(ErrorEnum.UNKNOWN_99);
				}
			}

		}

		return presTOs;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.api.patient.service.RxAPIService#getHistoricalPrescriptions()
	 */
	@Override
	public PrescriptionsTO getHistoricalPrescriptions() {
		
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		
		PrescriptionsTO presTOs = new PrescriptionsTO();
		List<PrescriptionTO> presList = new ArrayList<PrescriptionTO>();
		
		if(uf != null) {
			boolean isSigned = rxServceHelper.isRxAgreementSigned(uf);
			if( !isSigned ) {
				MHVEssApiUtility.throwException(ErrorEnum.RX_AGREEMENT_NOT_ACCEPTED_135);
			}
			
			PatientDTO pat = getPatientDTO(uf);

			if(pat != null) {
				try {
					PharmacyPatient pharmPat = getPharmacyPatient(uf, pat);
					if (pharmPat != null) {
						
						ResponseUtil<List<PrescriptionDTO>> responseUtil = prescriptionService.getHistoricalPrescriptionsWithRequestStatuses(pharmPat);
						StringBuffer failedStationList = new StringBuffer();
						String lastUpdatedtime = null;
						List<Request> request = prescriptionService.getLastSuccessfulExtractRequestForUser(pharmPat);
						if(request.get(0) != null) {
							lastUpdatedtime = MHVApiUtility.convertDateToMMDDYYYY(request.get(0).getModifiedDate());
						}
						/*
						//Starting to clean up message...
						Messages filteredMessages = ServiceResponseUtil.convertMessages(null, response, "rxhistory");

				        StringBuffer failedStationList = new StringBuffer();
				        RequestServiceResponse reqServRes =  presServiceDelegate.getLastSuccessfulExtractRequestForUser(pharmPat);
				        String lastUpdatedtime = null;
				        if (reqServRes.getRequest() != null && reqServRes.getRequest().getModifiedDate() != null) {
				        	lastUpdatedtime = MHVEssApiUtility.convertDateToRFC1123Pattern(reqServRes.getRequest().getModifiedDate());
				        }
						if ( !filteredMessages.getInformationalMessages().isEmpty() ){
							Collection<Message> messages = filteredMessages.getInformationalMessages();
							for(Message message: messages) {
								Iterator it = message.getInserts().iterator();
								while (it.hasNext()) {
									failedStationList.append(it.next().toString());
									if (it.hasNext())
										failedStationList.append(",");
								}
							//	String formattedMsg = MessageUtils.getSummaryMessage(message.getKey(), message.getInserts(), PrescriptionForm.class, null);
							//	System.out.println("FORMATTED MESSAGE: " +formattedMsg);
							}
						}
						*/
						try {
							accountActivityCreatorService.createAccountActivityLog(
														ActivityHelper.createActivityDTOForSelf(
														uf.getId(), 
														responseUtil.getFailureMessage()!= null ? false:true, 
														ActivityTypeEnumeration.RXREFILL, 
														ActivityActionTypeEnumeration.VIEW_HISTORICAL_PRESCRIPTION, 
														MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
														);
						} catch (MHVException e) {
							log.error("Exception occured in Activity Track", e);
							MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
						}
						MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, responseUtil);
						Collection entities = responseUtil.getPojoObject();
						presTOs.setFailedStationList(failedStationList.toString());
						presTOs.setLastUpdatedTime(lastUpdatedtime);
						if (entities != null) {
							for (Object e: entities) {
								PrescriptionDTO rx = (PrescriptionDTO) e;
								presList.add(rxServceHelper.convertToPrescriptionTO(rx));
							}
							presTOs.setPrescriptionList(presList);
						}

					}
					else {
						MHVEssApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
					}
				}catch ( Exception e) {
					e.printStackTrace();
					MHVEssApiUtility.throwException(ErrorEnum.UNKNOWN_99);
				}
			}

		}

		return presTOs;

	}

/*
	@Override
	public PrescriptionDetailTO getPrescriptionDetail(String rxid) {
		if(rxid == null) {
			if (log.isErrorEnabled())
				log.error("MHV API received NULL string from client");
			MHVEssApiUtility.throwException(ErrorEnum.PRESCRIPTIONID_NOT_FOUND_138);
		}
		RxAPIServiceHelper rxServceHelper = new RxAPIServiceHelper();
		Session session = sessionApiService.checkSession(mc);
		UserProfile uf = session.getPatient().getUserProfile();
		PrescriptionServiceDelegate presServiceDelegate = getPrescriptionServiceDelegate();
		PrescriptionServiceResponse preRes = presServiceDelegate.getPrescriptionDetailsForPrescriptionID(Long.parseLong(rxid));
		MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, preRes);
		Prescription pres = preRes.getPrescription();
		if(pres == null) {
			if (log.isErrorEnabled())
				log.error("MHV API could NOT find the prescription ID: " + rxid +" user has requested");
			MHVEssApiUtility.throwException(ErrorEnum.PRESCRIPTIONID_NOT_FOUND_138);
		}
		if (pres.getUserId().longValue() != uf.getId().longValue()) {
			if(log.isInfoEnabled())
				log.info("The prescription ID: " + rxid +" does not belong to USER: " + uf.getId());
			MHVEssApiUtility.throwException(ErrorEnum.RX_USER_NOT_OWNER_136);
		}

		return rxServceHelper.convertToPrescriptionDetailTO(pres);
	}
/*

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.api.patient.service.RxAPIService#refillPrescriptions(java.lang.String)
	 */
	@Override
	public Response refillPrescriptions(String rxid) {
		
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		PatientDTO pat = getPatientDTO(uf);
		
		List<PrescriptionDTO> rxidList = new ArrayList<PrescriptionDTO>();
		//		for (Long rxid: rxids) {
		 Prescription pres = prescriptionRepository.getPrescriptionById(Long.parseLong(rxid));
		if(pres == null)
		MHVEssApiUtility.throwException(ErrorEnum.PRESCRIPTIONID_NOT_FOUND_138);

		rxidList.add(prescriptionConverter.convertDomainPrescription(pres));
		if (!pres.getUserId().equals(uf.getId()))
			MHVEssApiUtility.throwException(ErrorEnum.RX_USER_NOT_OWNER_136);
		//}

		//ALL prescriptionId belongs to the same user. proceed

		if(pres.getIsRefillable() != null && pres.getIsRefillable() ) {
			PharmacyPatient pharmPat = getPharmacyPatient(uf, pat);
			ResponseUtil response = prescriptionService.refillPrescriptions(pharmPat, rxidList);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, response);

			// Beauty lies in the eyes of beholder
			/*
			if (response.getMessages().hasErrorMessages()) {
				Collection<Message> messages = (Collection<Message>)response.getMessages().getErrorMessages();
				for(Message message: messages) {

				}
			}
			*/
			List<String> infoMessages = new ArrayList<String>();
			List<Request> requests = new ArrayList<Request>();
			//Adding some message stuff in SRE structure
			LinkedHashMap<String, String> messageList = response.getInfoMessages();
			if (!messageList.isEmpty()) {
			     System.out.println("<<<<<< Inside MessageList >>>>>>>>>>");
				for(String key : messageList.keySet()) {
			         String message = messageList.get(key);
			         System.out.println("Message for key : " +key+ ":: " + message);
			         infoMessages.add(message);
			    }
			}
			//Ended Here
			/*
			if (response.getMessages().hasInformationalMessages()) {
				infoMessages = (Collection<Message>)response.getMessages().getInformationalMessages();
		        List messagesToRemove = new ArrayList();
				for (Iterator i = infoMessages.iterator(); i.hasNext();) {
		            Message message = (Message) i.next();
		            if ("prescriptionservice.request".equals(message.getKey())) {
		            	Iterator inserts = message.getInserts().iterator();
		            	if (inserts.hasNext()) {
		            		Object object = inserts.next();
		            		if (object instanceof Request) {
		            			requests.add((Request) object);
		            			messagesToRemove.add(message);
		            		}
		            	}
		            }
		        }
				infoMessages.removeAll(messagesToRemove);
			}
			*/
			// 1st Beauty ends and 2nd starts
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			if( infoMessages != null && !infoMessages.isEmpty() ) {
				builder.status(400);
				ErrorTO error = new ErrorTO(ErrorEnum.PRESCRIPTIONID__REFILL_ERROR_140);
				StringBuffer sb = new StringBuffer();
				for(String message: infoMessages) {
					sb.append(message);
				}

				error.setDeveloperMessage(sb.toString());
				gov.va.med.mhv.common.essapi.cache.CacheHandler.getInstance().setError(error);
				Response responseException = builder.build();
				try {
					accountActivityCreatorService.createAccountActivityLog(
												ActivityHelper.createActivityDTOForSelf(
												uf.getId(), 
												response.getFailureMessage()!= null ? false:true, 
												ActivityTypeEnumeration.RXREFILL, 
												ActivityActionTypeEnumeration.REQUEST_REFILL, 
												MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
												);
				} catch (MHVException e) {
					log.error("Exception occured in Activity Track", e);
					MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
				}
				//throw new WebApplicationException(responseException);
			}
			else {
				ResponseUtil<List<PrescriptionDTO>> responseUtil = prescriptionService.getActivePrescriptions(pharmPat);
				
				StringBuffer failedStationList = new StringBuffer();
				List<String> infoList = new ArrayList();
				/*
				if ( !filteredMessages.getInformationalMessages().isEmpty() ){
					Collection<Message> messages = filteredMessages.getInformationalMessages();
					for(Message message: messages) {
						infoList.add(message.getKey());

						Iterator it = message.getInserts().iterator();
						while (it.hasNext()) {
							failedStationList.append(it.next().toString());
							if (it.hasNext())
								failedStationList.append(",");
						}
					}
				}
				*/
				LinkedHashMap<String, String> messageList2 = responseUtil.getInfoMessages();
				if (!messageList2.isEmpty()) {
				     System.out.println("<<<<<< Inside MessageList >>>>>>>>>>");
					for(String key : messageList2.keySet()) {
				         String message = messageList2.get(key);
				         System.out.println("Message for key : " +key+ ":: " + message);
				         infoList.add(key);
				    }
				}
				if(infoList.contains("rxrefill.info.vista.refillsuccess")) {
					auditRefillrequest(responseUtil, session);
					return Response.ok("Successfully submitted to: "+failedStationList.toString()).build();
				}
				else if(infoList.contains("rxrefill.error.vista.systemfailure")) {
					ErrorTO error = new ErrorTO(ErrorEnum.PRESCRIPTIONID__REFILL_ERROR_140);
					error.setDeveloperMessage("MHV is unable to process your request: System Failed to Connect : "+failedStationList.toString());
					gov.va.med.mhv.common.essapi.cache.CacheHandler.getInstance().setError(error);
					Response responseException = builder.build();
					auditRefillrequest(responseUtil, session);
					throw new WebApplicationException(responseException);
				}
				else if(infoList.contains("rxrefill.info.vista.inProgress")) {
					ErrorTO error = new ErrorTO(ErrorEnum.PRESCRIPTIONID__REFILL_ERROR_140);
					error.setDeveloperMessage("MHV is unable to process your request: Refill is in Process ");
					gov.va.med.mhv.common.essapi.cache.CacheHandler.getInstance().setError(error);
					Response responseException = builder.build();
					auditRefillrequest(responseUtil, session);
					throw new WebApplicationException(responseException);
				}
				else if(infoList.contains("rxrefill.error.vista.prescriptionrejected")) {
					ErrorTO error = new ErrorTO(ErrorEnum.PRESCRIPTIONID__REFILL_ERROR_140);
					error.setDeveloperMessage("MHV is unable to process your request: Prescription Rejected: " +failedStationList.toString());
					gov.va.med.mhv.common.essapi.cache.CacheHandler.getInstance().setError(error);
					Response responseException = builder.build();
					auditRefillrequest(responseUtil, session);
					throw new WebApplicationException(responseException);
				}
				else if(infoList.contains("rxrefill.error.vista.maxfailureexceeded")) {
					ErrorTO error = new ErrorTO(ErrorEnum.PRESCRIPTIONID__REFILL_ERROR_140);
					error.setDeveloperMessage("MHV is unable to process your request: Max Failure Exceeded");
					gov.va.med.mhv.common.essapi.cache.CacheHandler.getInstance().setError(error);
					Response responseException = builder.build();
					auditRefillrequest(responseUtil, session);
					throw new WebApplicationException(responseException);
				}



			}
		}
		else {
			MHVEssApiUtility.throwException(ErrorEnum.PRESCRIPTIONID_NOT_REFILLABLE_139);
		}
		
		// if the flow comes this far. then its a good.
		ResponseBuilderImpl builder = new ResponseBuilderImpl();
		return builder.entity("Success").status(200).build();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.api.patient.service.RxAPIService#getTrackingDetail(java.lang.String)
	 */
	@Override
	public TrackingInfoDetailsTO getTrackingDetail(String rxid) {
		if(rxid == null) {
			if (log.isErrorEnabled())
				log.error("MHV API received NULL string from client");
			MHVEssApiUtility.throwException(ErrorEnum.PRESCRIPTIONID_NOT_FOUND_138);
		}
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		
		Prescription pres = prescriptionRepository.getPrescriptionById(Long.parseLong(rxid));
		
		if(pres == null) {
			log.error("MHV API could NOT find the prescription ID: " + rxid +" user: " + uf.getId() + " has requested");
			MHVEssApiUtility.throwException(ErrorEnum.PRESCRIPTIONID_NOT_FOUND_138);
		}	
		
		if (pres.getUserId().longValue() != uf.getId().longValue()) {
			if(log.isInfoEnabled())
				log.info("The prescription ID: " + rxid +" does not belong to USER: " + uf.getId());
			MHVEssApiUtility.throwException(ErrorEnum.RX_USER_NOT_OWNER_136);
		}
		
		// Good to go Start Tracking
		String mainStationNumber = pres.getInstitution().getStationNumber();
		String rxnumber = pres.getPrescriptionNumber();
		Date releaseDateTime = pres.getReleaseDateTime();

		Collection<RxTracking> trackingNumbers = rxTrackingRepository.getPrescriptionTrackingBySiteAndRxNumber( mainStationNumber, rxnumber);

		TrackingInfoDetailsTO trackingInfoDetailsTO = new TrackingInfoDetailsTO();
		trackingInfoDetailsTO.setPrescriptionName(pres.getDrugName());
		trackingInfoDetailsTO.setPrescriptionNumber(pres.getPrescriptionNumber());
		trackingInfoDetailsTO.setFacilityName(pres.getInstitution().getName());
		String divisionPhone = "";
		String ndcNumber ="";
		String lastUpdatedtime ="";
		for (RxTracking rx: trackingNumbers) {
			divisionPhone = rx.getDivisionPhone();
			if (rx.getDateLoaded() != null) {
				lastUpdatedtime = MHVApiUtility.convertDateToRFC1123Pattern (new Date(rx.getDateLoaded().getTime()));
			}
			ndcNumber = rx.getNdc();
			if (divisionPhone.isEmpty() || ndcNumber.isEmpty() || rx.getDateLoaded() == null)
				continue;
			else
				break;
		}

		trackingInfoDetailsTO.setRxInfoPhoneNumber(divisionPhone);
		trackingInfoDetailsTO.setLastUpdatedtime(lastUpdatedtime);
		trackingInfoDetailsTO.setNdcNumber(ndcNumber);
		List <TrackingInfoTO> trackingInfo= new ArrayList<TrackingInfoTO>();
		for (RxTracking rx: trackingNumbers) {
			TrackingInfoTO trackInf = new TrackingInfoTO();
			trackInf.setTrackingNumber(rx.getTrackingNumber());
			trackInf.setDeliveryService(rx.getCarrier());
			trackInf.setShippedDate(MHVApiUtility.convertDateToRFC1123Pattern(rx.getCompleteDateTime()));

			// Now pull other Prescription infos for the Tracking Number
			List<OtherPresListIncluded> otherPresListIncludedList = new ArrayList<OtherPresListIncluded>();
			// Get the RxIds associated with the Tracking number
			if(log.isInfoEnabled())
				log.info("Dealing with Tracking Number: " + rx.getTrackingNumber());
			Collection<RxTracking> rxTrackingNumbers = rxTrackingRepository.getPrescriptionDataByTrackingNumber(rx.getTrackingNumber());
			if(log.isInfoEnabled())
				log.info("Tracking Number: " + rx.getTrackingNumber() +" has total Rx: " +rxTrackingNumbers.size());
			for (RxTracking rx1: rxTrackingNumbers) {
				OtherPresListIncluded otherPresListIncluded = new OtherPresListIncluded();
				//Get the Prescription of the RxId
				if(log.isInfoEnabled()) {
					log.info("Dealing with Rx1: " + rx1.getRxNumber() +" of STATION: " + rx1.getStationNumber()
						+ " OF Tracking: " + rx.getTrackingNumber() );
				}
				Prescription pres1 = prescriptionRepository.getPrescriptionDetailsForPrescriptionNumber(rx1.getRxNumber(),rx1.getStationNumber()).get(0);
				//NOTE: pres1 is NULL does NOT mean the prescription Does NOT exist. System might NOT be able find coz
				//	of combination of pres number and station is missing in PRESCRIPTIONS. IN Reality HOWZ that possible I don't know.
				// Following what GUI does in those scenario.. ADD N/A for PRESSCIPTION NAME. and ADD PRESCRIPTION NUMBER from
				// RX_TRACKING table.
				otherPresListIncluded.setNdcNumber(rx1.getNdc());
				if(pres1 == null) {
					if(log.isInfoEnabled()) {
						log.info("NO prescritionS found of Rx1: " + rx1.getRxNumber() +" of STATION: " + rx1.getStationNumber()
							+ " OF Tracking: " + rx.getTrackingNumber() );
					}
					otherPresListIncluded.setPrescriptionName("N/A");
					otherPresListIncluded.setPrescriptionNumber(rx1.getRxNumber());
					otherPresListIncluded.setStationNumber(rx1.getStationNumber());
				}
				//NOTE: to EXCLUDE the parent prescription in the OTHER LIST
				//pres1.getPrescriptionNumber().equals(pres.getPrescriptionNumber()

				if(pres1 != null && !pres1.getPrescriptionNumber().equals(pres.getPrescriptionNumber())) {
					if(log.isInfoEnabled())
						log.info("PRES1: " +pres1.getPrescriptionNumber() + " PRES: " + pres.getPrescriptionNumber());
					if (pres1.getDrugName() != null)
						otherPresListIncluded.setPrescriptionName(pres1.getDrugName());
					otherPresListIncluded.setPrescriptionNumber(pres1.getPrescriptionNumber());
					otherPresListIncluded.setStationNumber(pres1.getInstitution().getStationNumber());

				}
				if(otherPresListIncluded.getPrescriptionNumber() != null)
					otherPresListIncludedList.add(otherPresListIncluded);

			}
			trackInf.setOtherPrescriptionListIncluded(otherPresListIncludedList);
			trackingInfo.add(trackInf);
		}
		trackingInfoDetailsTO.setTrackingInfo(trackingInfo);
		return trackingInfoDetailsTO;
		
	}

	/*
	private void auditRefillrequest(Patient patient, Prescription pres,	boolean success, Session session) {
		Activity activity = TransferObjectFactory.createActivity();
		activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.REQUEST_REFILL).getName());
		activity.setActionType(ActivityTypeEnumeration.RXREFILL);
		activity.setCompletionTime(new Timestamp(new Date().getTime()));
		activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(ActivityActorTypeEnumeration.SYSTEM));
		activity.setSubjectId(patient.getUserProfile().getId());
		activity.setDetailValue("Remote System: " +session.getClientApplication().getName() +" :: " +pres.getDrugName());
		activity.setStatus(success);
		getAuditServiceDelegate().audit(activity);


	}

	private void auditPrecriptionTracking(PatientDTO patient, boolean success, Session session, String activityActionType ) {
		Activity activity = TransferObjectFactory.createActivity();
		activity.setAction(ActivityActionTypeEnumeration.getEnum(activityActionType).getName());
		activity.setActionType(ActivityTypeEnumeration.RXREFILL);
		activity.setCompletionTime(new Timestamp(new Date().getTime()));
		activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(ActivityActorTypeEnumeration.SYSTEM));
		activity.setSubjectId(patient.getUserProfile().getId());
		activity.setDetailValue("Remote System: " +session.getClientApplication().getName());
		activity.setStatus(success);
		getAuditServiceDelegate().audit(activity);


	}
	*/

	private UserProfileDTO getUserProfileDTO( Session session) {
		UserProfileDTO uf = null;
		try {
			uf = userMgmtServiceProxy.getUserProfileById(session.getUserId());
		} catch (MHVException e2) {
			log.error("Exception occured in User Mangement Service Proxy", e2);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e2);
		}
		return uf;
	}

	private PatientDTO getPatientDTO(UserProfileDTO uf) {
		PatientDTO pat = null;
		try {
			pat = patientWebProxy.getPatientByUserProfileId(uf.getId());
		} catch (MHVException e1) {
			// TODO Auto-generated catch block
			log.error("Exception occured in Patient Proxy", e1);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e1);
		}
		return pat;
	}

	private PharmacyPatient getPharmacyPatient(UserProfileDTO uf, PatientDTO pat) {
		PharmacyPatient pharmacyPatient = null;
		try {
			pharmacyPatient = prescriptionService.getPharmacyPatient(uf.getId());
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			log.error("Exception occured in Patient Proxy", e1);
			MHVException ex = new MHVException(); 
			ex.setFailureMessage(e1.getMessage());
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, ex);
		}
		return pharmacyPatient;
	}
	
	private void auditRefillrequest(ResponseUtil response, Session session) {
		try {
			accountActivityCreatorService.createAccountActivityLog(
										ActivityHelper.createActivityDTOForSelf(
										session.getUserId(), 
										response.getFailureMessage()!= null ? false:true, 
										ActivityTypeEnumeration.RXREFILL, 
										ActivityActionTypeEnumeration.REQUEST_REFILL, 
										MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
										);
		} catch (MHVException e) {
			log.error("Exception occured in Activity Track", e);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}
		
	}




}
