package gov.va.med.mhv.rxrefill.essapi.service;



import gov.va.med.mhv.rxrefill.essapi.transfer.PrescriptionsTO;
import gov.va.med.mhv.rxrefill.essapi.transfer.TrackingInfoDetailsTO;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces({"application/xml","application/json","application/octet-stream"})
@Consumes({"application/xml","application/json"})
public interface RxAPIService {

	@GET
	@Path("/getactiverx")
	public PrescriptionsTO getActivePrescriptions();

	@GET
	@Path("/gethistoryrx")
	public PrescriptionsTO getHistoricalPrescriptions();

//	@GET
//	@Path("/rxdetail/{rxid}")
//	public PrescriptionDetailTO getPrescriptionDetail(@javax.ws.rs.PathParam("rxid") String rxid);

	@POST
	@Path("/rxrefill/{rxid}")
	public Response refillPrescriptions(@javax.ws.rs.PathParam("rxid") String rxid);

	@GET
	@Path("/rxtracking/{rxid}")
	public TrackingInfoDetailsTO getTrackingDetail(@javax.ws.rs.PathParam("rxid") String rxid);


}
