package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.domain.persistence.jdbc.helper.ParameterEntry;
import gov.va.med.mhv.rxrefill.data.model.ProtocolParameter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class ProtocolParameterConverter implements
		Converter<ProtocolParameter, ParameterEntry> {

	@Override
	public ParameterEntry convert(ProtocolParameter source) {
		ParameterEntry target = new ParameterEntry();

		if (null != source.getProtocolParameterKey()) {
			target.setEndpointId(source.getProtocolParameterKey().getEndpointId());
			target.setDescription(source.getProtocolParameterKey().getDescription());
		}
		target.setValue(source.getValue());

		return target;
	}

}
