package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.mhv.rxrefill.data.model.Institution;
import gov.va.med.mhv.rxrefill.data.model.Prescription;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.data.model.RxTracking;

import org.springframework.stereotype.Component;

@Component
public class PrescriptionConverter {

	public PrescriptionDTO convertDomainPrescription(Prescription prescription) {
		PrescriptionDTO prescriptionDto = new PrescriptionDTO();
		
		prescriptionDto.setId(prescription.getId());
		prescriptionDto.setCreatedDate(prescription.getCreatedDate());
		prescriptionDto.setIsRefillable(prescription.getIsRefillable());
		prescriptionDto.setPlacerOrderNumber(prescription.getPlacerOrderNumber());
		prescriptionDto.setUserId(prescription.getUserId());
		
		/*if (null != prescription.getUserProfile()) {
			prescriptionDto.setUserProfile(new UserProfileConverter().convertDomainUserProfile(prescription.getUserProfile()));
		}*/
		
		prescriptionDto.setIen(prescription.getIen());
		prescriptionDto.setProviderFirstName(prescription.getProviderFirstName());
		prescriptionDto.setProviderId(prescription.getProviderId());
		prescriptionDto.setDivision(prescription.getDivision());
		prescriptionDto.setIsInactive(prescription.getIsInactive());
		prescriptionDto.setSig(prescription.getSig());
		prescriptionDto.setMailWindow(prescription.getMailWindow());
		prescriptionDto.setReleaseDateTime(prescription.getReleaseDateTime());
		prescriptionDto.setIsInvalidMhvStatus(prescription.getIsInvalidMhvStatus());
		prescriptionDto.setPrescriptionNumber(prescription.getPrescriptionNumber());
		prescriptionDto.setExpirationCancelDate(prescription.getExpirationCancelDate());
		prescriptionDto.setProviderLastName(prescription.getProviderLastName());
		prescriptionDto.setQuantity(prescription.getQuantity());
		prescriptionDto.setMhvStatusDate(prescription.getMhvStatusDate());
		prescriptionDto.setLastFillDate(prescription.getLastFillDate());
		prescriptionDto.setRemarks(prescription.getRemarks());
		prescriptionDto.setStatus(prescription.getStatus());
		prescriptionDto.setDaysSupply(prescription.getDaysSupply());
		prescriptionDto.setLastRefillSubmittedDate(prescription.getLastRefillSubmittedDate());
		prescriptionDto.setDivisionName(prescription.getDivisionName());
		prescriptionDto.setArchivedDate(prescription.getArchivedDate());
		prescriptionDto.setDrugName(prescription.getDrugName());
		prescriptionDto.setModifiedDate(prescription.getModifiedDate());
		prescriptionDto.setNumberOfRefills(prescription.getNumberOfRefills());
		prescriptionDto.setMhvStatus(prescription.getMhvStatus());
		prescriptionDto.setIsLastRequestSuccessful(prescription.getIsLastRequestSuccessful());
		prescriptionDto.setIssueDateTime(prescription.getIssueDateTime());
		//prescriptionDto.setInstitutionId(prescription.getInstitutionId());
		
		Institution institution = prescription.getInstitution();
		if (null != institution) {
			prescriptionDto.setInstitution(new InstitutionConverter().convertDomainInstitution(institution));
			prescriptionDto.setFactilityName(institution.getName());
		}
		
		return prescriptionDto;
	}
	
	public Prescription convertDTOPrescription(PrescriptionDTO prescriptionDto) {
		Prescription prescription = new Prescription();
		
		prescription.setId(prescriptionDto.getId());
		prescription.setCreatedDate(prescriptionDto.getCreatedDate());
		prescription.setIsRefillable(prescriptionDto.getIsRefillable());
		prescription.setPlacerOrderNumber(prescriptionDto.getPlacerOrderNumber());
		prescription.setUserId(prescriptionDto.getUserId());
		
		/*if (null != prescriptionDto.getUserProfile()) {
			UserProfile userProfile = new UserProfile();
			
			prescription.setUserProfile(new UserProfileConverter().convertDTOProfile(userProfile, prescriptionDto.getUserProfile()));
		}*/
		
		prescription.setIen(prescriptionDto.getIen());
		prescription.setProviderFirstName(prescriptionDto.getProviderFirstName());
		prescription.setProviderId(prescriptionDto.getProviderId());
		prescription.setDivision(prescriptionDto.getDivision());
		prescription.setIsInactive(prescriptionDto.getIsInactive());
		prescription.setSig(prescriptionDto.getSig());
		prescription.setMailWindow(prescriptionDto.getMailWindow());
		prescription.setReleaseDateTime(prescriptionDto.getReleaseDateTime());
		prescription.setIsInvalidMhvStatus(prescriptionDto.getIsInvalidMhvStatus());
		prescription.setPrescriptionNumber(prescriptionDto.getPrescriptionNumber());
		prescription.setExpirationCancelDate(prescriptionDto.getExpirationCancelDate());
		prescription.setProviderLastName(prescriptionDto.getProviderLastName());
		prescription.setQuantity(prescriptionDto.getQuantity());
		prescription.setMhvStatusDate(prescriptionDto.getMhvStatusDate());
		prescription.setLastFillDate(prescriptionDto.getLastFillDate());
		prescription.setRemarks(prescriptionDto.getRemarks());
		prescription.setStatus(prescriptionDto.getStatus());
		prescription.setDaysSupply(prescriptionDto.getDaysSupply());
		prescription.setLastRefillSubmittedDate(prescriptionDto.getLastRefillSubmittedDate());
		prescription.setDivisionName(prescriptionDto.getDivisionName());
		prescription.setArchivedDate(prescriptionDto.getArchivedDate());
		prescription.setDrugName(prescriptionDto.getDrugName());
		prescription.setModifiedDate(prescriptionDto.getModifiedDate());
		prescription.setNumberOfRefills(prescriptionDto.getNumberOfRefills());
		prescription.setMhvStatus(prescriptionDto.getMhvStatus());
		prescription.setIsLastRequestSuccessful(prescriptionDto.getIsLastRequestSuccessful());
		prescription.setIssueDateTime(prescriptionDto.getIssueDateTime());
		//prescription.setInstitutionId(prescriptionDto.getInstitutionId());
		
		if (null != prescriptionDto.getInstitution()) {
			prescription.setInstitution(new InstitutionConverter().convertDTOInstitution(prescriptionDto.getInstitution()));
		}
		
		return prescription;
	}
}
