package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.mhv.rxrefill.dto.InstitutionDTO;
import gov.va.med.mhv.rxrefill.dto.MedicationHistoryDTO;
import gov.va.med.mhv.rxrefill.dto.MyCompleteMedicationDTO;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MyCompleteMedicationConverter {
	
	public static MyCompleteMedicationDTO convertMedicationHistoryDTO(MedicationHistoryDTO medicatinHistDTO) {
		
		MyCompleteMedicationDTO prescDTO = new MyCompleteMedicationDTO();
		prescDTO.setCategory(medicatinHistDTO.getDispCategory());
		Date d1= new Date();
		if(medicatinHistDTO.getEndDate() == null){
			prescDTO.setStatus("Active");
		}else if(d1.after(medicatinHistDTO.getEndDate())){
			prescDTO.setStatus("Expired");
		}else{
			prescDTO.setStatus("Active");
		}
		prescDTO.setPrescriptionNumber(medicatinHistDTO.getPrescriptionNumber());
		prescDTO.setDrugName(medicatinHistDTO.getMedicationName());
		prescDTO.setIssueDateTime(medicatinHistDTO.getStartDate());
		prescDTO.setExpirationCancelDate(medicatinHistDTO.getEndDate());
		prescDTO.setSource("SELF");
		prescDTO.setStrength(medicatinHistDTO.getStrength());
		prescDTO.setDosage(medicatinHistDTO.getDosage());
		prescDTO.setFrequency(medicatinHistDTO.getFrequency());
		prescDTO.setPharmacyPhone(medicatinHistDTO.getPharmacyPhone());
		prescDTO.setReason(medicatinHistDTO.getReason());
		prescDTO.setComments(medicatinHistDTO.getComments());
		
		InstitutionDTO institutionDTO = new InstitutionDTO();
		institutionDTO.setName(medicatinHistDTO.getPharmacyName());
		prescDTO.setInstitution(institutionDTO);
		return prescDTO;
	}
	
	public static List<MyCompleteMedicationDTO> convertMedicationHistoryDTOList(List<MedicationHistoryDTO>  medicatinHistList){
		
		List<MyCompleteMedicationDTO> presriptionList = new ArrayList<MyCompleteMedicationDTO>();
		for(MedicationHistoryDTO medDTO : medicatinHistList){
			MyCompleteMedicationDTO prescDTO = convertMedicationHistoryDTO(medDTO);
			presriptionList.add(prescDTO);
		}
		return  presriptionList;
	}
	
	public static  List<MyCompleteMedicationDTO>  convertVATOMyCompList(List<PrescriptionDTO> presclist	) {
	
		List<MyCompleteMedicationDTO> vaPrescriptionList  = new ArrayList<MyCompleteMedicationDTO>();
		for(PrescriptionDTO dto :presclist){
			MyCompleteMedicationDTO mycompDTO = new MyCompleteMedicationDTO();
			mycompDTO.setArchivedDate(dto.getArchivedDate());
			mycompDTO.setCategory("Rx Medication");
			mycompDTO.setCreatedDate(dto.getCreatedDate());
			mycompDTO.setDaysSupply(dto.getDaysSupply());
			mycompDTO.setDispExpirationCancelDate(dto.getDispExpirationCancelDate());
			mycompDTO.setDispIssueDateTime(dto.getDispIssueDateTime());
			mycompDTO.setDispLastFillDate(dto.getDispLastFillDate());
			mycompDTO.setDispLastRefillSubmittedDate(dto.getDispLastRefillSubmittedDate());
			mycompDTO.setDispModifiedDate(dto.getDispModifiedDate());
			mycompDTO.setDispNumberOfRefills(dto.getDispNumberOfRefills());
			mycompDTO.setDispReleaseDateTime(dto.getDispReleaseDateTime());
			mycompDTO.setDispRxNumber(dto.getDispRxNumber());
			mycompDTO.setDispStatus(dto.getDispStatus());
			mycompDTO.setDivision(dto.getDivision());
			mycompDTO.setDivisionName(dto.getDivisionName());
			mycompDTO.setDrugName(dto.getDrugName());
			mycompDTO.setExpirationCancelDate(dto.getExpirationCancelDate());
			mycompDTO.setFactilityName(dto.getFactilityName());
			mycompDTO.setId(dto.getId());
			mycompDTO.setIen(dto.getIen());
			mycompDTO.setInstitution(dto.getInstitution());
			mycompDTO.setInstitutionId(dto.getInstitutionId());
			mycompDTO.setIsInactive(dto.getIsInactive());
			mycompDTO.setIsInvalidMhvStatus(dto.getIsInvalidMhvStatus());
			mycompDTO.setIsLastRequestSuccessful(dto.getIsLastRequestSuccessful());
			mycompDTO.setIsRefillable(dto.getIsRefillable());
			mycompDTO.setIssueDateTime(dto.getIssueDateTime());
			mycompDTO.setLastFillDate(dto.getLastFillDate());
			mycompDTO.setLastRefillSubmittedDate(dto.getLastRefillSubmittedDate());
			mycompDTO.setMailWindow(dto.getMailWindow());
			mycompDTO.setMhvStatus(dto.getMhvStatus());
			mycompDTO.setMhvStatusDate(dto.getMhvStatusDate());
			mycompDTO.setModifiedDate(dto.getModifiedDate());
			mycompDTO.setNumberOfRefills(dto.getNumberOfRefills());
			mycompDTO.setPlacerOrderNumber(dto.getPlacerOrderNumber());
			mycompDTO.setPrescriptionNumber(dto.getPrescriptionNumber());
			mycompDTO.setProviderFirstName(dto.getProviderFirstName());
			mycompDTO.setProviderId(dto.getProviderId());
			mycompDTO.setProviderLastName(dto.getProviderLastName());
			mycompDTO.setQuantity(dto.getQuantity());
			mycompDTO.setReleaseDateTime(dto.getReleaseDateTime());
			mycompDTO.setRemarks(dto.getRemarks());
			mycompDTO.setRxTrackingList(dto.getRxTrackingList());
			mycompDTO.setSource("VA");
			mycompDTO.setStatus(dto.getStatus());
			mycompDTO.setUserId(dto.getUserId());
			mycompDTO.setUserProfile(dto.getUserProfile());
			vaPrescriptionList.add(mycompDTO);
		 }
		return vaPrescriptionList;
	}
}
