package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.domain.persistence.jdbc.helper.ParameterEntry;
import gov.va.med.mhv.rxrefill.data.model.EncodingParameter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class EncodingParameterConverter implements Converter<EncodingParameter, ParameterEntry> {

	@Override
	public ParameterEntry convert(EncodingParameter source) {
		ParameterEntry target = new ParameterEntry();

		if (null != source.getEncodingParameterKey()) {
			target.setEndpointId(source.getEncodingParameterKey().getEndpointId());
			target.setDescription(source.getEncodingParameterKey().getDescription());
		}
		target.setValue(source.getValue());

		return target;
	}

}
