package gov.va.med.framework.conversion.converter;

import org.apache.commons.beanutils.Converter;

import gov.va.med.domain.typecode.NumericTypeCodeAbstract;
import gov.va.med.domain.typecode.TypeCode;
import gov.va.med.domain.typecode.TypeCodeAbstract;

/**
 * Converter implementation responsible for converting an object into a TypeCode instance.
 * @author Jon Crater Apr 26, 2005 10:38:30 AM
 * @version $Id: TypeCodeConverter.java,v 1.1.1.1 2005/05/13 19:40:48 jon.crater Exp $
 */
public class TypeCodeConverter implements Converter {

	/**
	 * For purposes of this conversion, it is assumed that the value parameter is either already
	 * a TypeCode instance (in which case it will be returned unchanged), or it is a value
	 * that maps to an enumerated type with that value as its code.
	 * @see org.apache.commons.beanutils.Converter#convert(java.lang.Class, java.lang.Object)
	 * @see gov.va.med.domain.typecode.TypeCode
	 * @see gov.va.med.domain.typecode.TypeCodeAbstract#codeForValue(Class, Object)
	 */
	public Object convert(Class type, Object value) {
		if(value == null || value instanceof TypeCode)
			return value;
		
		Object code = value;
		
		// if we're converting for a numeric type code, parse to Integer object first
		if(NumericTypeCodeAbstract.class.isAssignableFrom(type))
			code = Integer.valueOf(value.toString());

		// Make sure the target class is loaded.  This is necessary because if this class is loaded
		// for the first time by a process that uses reflection (e.g., conversion), then the JVM
		// doesn't initialize the static variables even though we get a valid class object
		// as a parameter to this method.
		try {
			Class.forName(type.getName());
		}
		catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}

		return TypeCodeAbstract.codeForValue(type, code);
	}

}
