package gov.va.med.domain.typecode;

/*
 * @author Susan Gallagher
 * 		Date: May 6, 2005
 * @version $Id: ContactMethodTypeCode.java,v 1.1.1.1 2005/05/13 19:40:45 jon.crater Exp $
 *
 */
public class ContactMethodTypeCode extends AlphaNumericTypeCodeAbstract {

	public static final ContactMethodTypeCode WORK_PHONE = new ContactMethodTypeCode("WP", "Work Phone",
			"Work Phone");

	public static final ContactMethodTypeCode HOME_PHONE = new ContactMethodTypeCode("HP", "Home Phone",
			"Home Phone");
	
	public static final ContactMethodTypeCode PAGER_NUMBER = new ContactMethodTypeCode("PN", "Pager Number", 
			"Pager Number");
	
	public static final ContactMethodTypeCode CELL_PHONE = new ContactMethodTypeCode("CP", "Cell Phone",
			"Cell Phone");
	
	public static final ContactMethodTypeCode FAX_NUMBER = new ContactMethodTypeCode("FN", "FAX Number", 
			"FAX Number");
	
	public static final ContactMethodTypeCode EMAIL = new ContactMethodTypeCode("E", "Email Address",
			"Email Address");
	
	public static final ContactMethodTypeCode PRE_APPROVAL_PHONE = new ContactMethodTypeCode("PA", 
			"Pre-approval Phone", "Pre-approval Phone");
	
	private ContactMethodTypeCode(String methodType, String label, String description) {
		super(methodType, label, description);
	}
	
	public boolean isWorkPhone() {
		return WORK_PHONE == this;
	}

	public boolean isEmail() {
		return EMAIL == this;
	}
}
