package gov.va.med.domain.service.messaging.parse;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;

/**
 * @author Slava Uchitel
 * @version $Id: HL7ParseFieldError.java,v 1.3 2005/07/05 16:35:01 joel.goldberg Exp $
 * @since MHV 2.0 <br>06/14/2005
 */
public class HL7ParseFieldError extends HL7ParseError
{ 
    private int fieldNumber = -1;
    private int repetitionNumber = -1;
    private int componentNumber = -1;
    private Type destinationField = null;
    private String data = null;
    private Primitive primitive = null;
    private String value = null; 
    /**
     * @return Returns the componentNumber.
     */
    public int getComponentNumber()
    {
        return componentNumber;
    }
    /**
     * @param componentNumber The componentNumber to set.
     */
    public void setComponentNumber(int componentNumber)
    {
        this.componentNumber = componentNumber;
    }
  
    public String getData()
    {
        return data;
    }
 
    public void setData(String data)
    {
        this.data = data;
    }
  
    public Type getDestinationField()
    {
        return destinationField;
    }
    
    public void setDestinationField(Type destinationField)
    {
        this.destinationField = destinationField;
    }
    
    public int getFieldNumber()
    {
        return fieldNumber;
    }
  
    public void setFieldNumber(int fieldNumber)
    {
        this.fieldNumber = fieldNumber;
    }
   
    public Primitive getPrimitive()
    {
        return primitive;
    }
   
    public void setPrimitive(Primitive primitive)
    {
        this.primitive = primitive;
    }
    
    public int getRepetitionNumber()
    {
        return repetitionNumber;
    }
   
    public void setRepetitionNumber(int repetitionNumber)
    {
        this.repetitionNumber = repetitionNumber;
    }
    
    public String getValue()
    {
        return value;
    }
 
    public void setValue(String value)
    {
        this.value = value;
    }
    public HL7Exception getHL7Exception() {
        return (HL7Exception)getException();
    }

    public String getFieldName() { 
        return "Structure: " + getStructure().getName() + " " + getRepetitionNumber() + 
               " field: " + getFieldNumber();
    }
    public String getErrorDescrpition() {
        return "HL7 Parse field error for field [" + 
        		getFieldName() +
        		"] with value  [" + 
        		getValue() + 
        		"] with exception: " + getException().getMessage();
    }
}
