package gov.va.med.domain.service.messaging.parse;


/**
 * @author Joel Goldberg
 * @version $Id: HL7DecoderDataError.java,v 1.2 2005/07/04 21:04:14 joel.goldberg Exp $
 * @since MHV 2.0 <br>Jun 15, 2005
 */
public class HL7DecoderDataError extends HL7ParseError {
 
    private int fieldNumber = -1;
    private int componentNumber = -1;
    private String dataType = null;
    private String fieldName = null;
    private String value = null; 
    private String errorKey; 
    
    public HL7DecoderDataError() {
        super();
        
    }

    public String getDataType() {
        return dataType;
    }
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
    public String getFieldName() {
        return fieldName;
    }
    public String getErrorDescrpition() { 
        return new StringBuffer()
        	.append(getErrorKey())
        	.append(" value [")
        	.append(getValue())
        	.append("] in Structure[")
        	.append(getStructure().getName())
        	.append(" ")
        	.append(getFieldName())
        	.append("]")
        	.toString();
    }
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
    public int getFieldNumber() {
        return fieldNumber;
    }
    public void setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
    }
    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }
    public int getComponentNumber() {
        return componentNumber;
    }
    public void setComponentNumber(int componentNumber) {
        this.componentNumber = componentNumber;
    }
    public String getErrorKey() {
        return errorKey;
    }
    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }
}
