package gov.va.med.domain.service.messaging.impl;

import gov.va.med.domain.model.RxRefillPayload;
import gov.va.med.domain.service.messaging.DestinedRequest;
import gov.va.med.domain.service.messaging.IMessageOriginator;
import gov.va.med.domain.service.messaging.IMessageSender;
import gov.va.med.domain.service.messaging.MessageExchangePatternType;
import gov.va.med.domain.service.messaging.MessageType;
import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.Request;
import gov.va.med.domain.service.messaging.Response;
import gov.va.med.domain.service.messaging.environment.DestinationKey;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Facade to the business tier to simplfiy the invocation of predefined requests and encapsulate the
 * messaging-specific logic.
 * <P>
 * A method is provided for each type of supported request and new methods will be added as new
 * requests are implemented. <BR>
 * NOTE: Each added method must be also implemented in IMessageOriginator.
 * <P>
 * There is no public constructor because this class must be loaded from the Spring Framework's Bean
 * Factory for proper transaction management.
 * <P>
 * To obtain an instance of this class, use the static method <BR>
 * public static IMessageOriginator getMessageOriginator()
 * <P>
 * 
 * @author Joel Goldberg
 * @version $Id: MessageOriginator.java,v 1.38 2005/08/27 19:19:20 alex.kalinovsky Exp $
 * @since MHV 2.0 <br>
 *        Apr 17, 2005
 */
@Component
public class MessageOriginator implements MessagingConstants, IMessageOriginator {

   private static Logger logger = LogManager.getLogger(MessageOriginator.class);

   public static final String PATIENT_MESSAGING_REQUEST_DAO_BEAN_NAME = "PatientMessagingRequestDAO";

   private static final MessageType PATIENT_LOOKUP_MESSAGE_TYPE = new MessageType(MessagingConstants.MPI_PATIENT_LOOKUP_FUNCTION, MessageExchangePatternType.SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN);

   private static final MessageType PRESCRIPTION_STATUS_MESSAGE_TYPE = new MessageType(MessagingConstants.GET_ACTIVE_PRESCRIPTIONS_FUNCTION_NAME,
         MessageExchangePatternType.SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN);

   private static final MessageType PRESCRIPTION_PROFILE_MESSAGE_TYPE = new MessageType(MessagingConstants.GET_ALL_PRESCRIPTIONS_FUNCTION_NAME,
         MessageExchangePatternType.SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN);

   private static final MessageType PRESCRIPTION_REFILL_MESSAGE_TYPE = new MessageType(MessagingConstants.PRESCRIPTION_REFILL_FUNCTION_NAME,
         MessageExchangePatternType.SYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN);

   private static final MessageType LINK_PATIENT_MESSAGE_TYPE = new MessageType(MessagingConstants.MPI_PATIENT_LINK_FUNCTION, MessageExchangePatternType.ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN);

   private static final MessageType UNLINK_PATIENT_MESSAGE_TYPE = new MessageType(MessagingConstants.MPI_PATIENT_UNLINK_FUNCTION, MessageExchangePatternType.ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN);

   /**
    * Dummy Function for parent request of PHR extracts requests
    */
   public static final String HEALTH_RECORD_UPDATES_FUNCTION_NAME = "getHealthRecordUpdates";
   
   @Autowired
   private IMessageSender messageSender;
	

   /**
    * This method is public solely to allow Spring Bean Factory to create it. No application code
    * should use this method directly.
    * <P>
    * 
    * Use <code> public static IMessageOriginator getMessageOriginator() </code>
    * 
    * @deprecated use the static method <code> getMessageOriginator() </code>
    */
   public MessageOriginator() {
   }

   /**
    * Factory method to get the MessageOriginator Bean
    */
   //public IMessageOriginator getMessageOriginator() {
      //return (IMessageOriginator) ObjectFactory.getBean(MessagingConstants.MESSAGE_ORIGINATOR_BEAN_NAME);
   //}

/*   *//**
    * <pre>
    *  Queues an extract request for each site and category at which the 
    *  patient has health records.  Each reauest is for all personal health 
    *  records of for a caterory and site since the last corresponding
    *  successful extract.  
    * <BR>
    *  Will apply business rules and query the database to:
    * <UL>
    * <LI>
    * Ensure requests are sent to all sites where patient has record
    * <LI>
    *  Request extracts for all supported subject areas
    * <LI>
    *  Request extracts for a date range subsequent to the last successful extract
    *      for that site/category/patient, or a full extract if it is the first request.
    * <LI>
    *  Sequence the requests in priority order (priority on the PHR_FUNCTIONS table).
    *      If  the categoryType provided is not null,  this category is requested first.
    * </UL>
    * </pre>
    * 
    * logger.
    * <P>
    * 
    * @param patient populated with UserIdSeq and ICN
    * @param categoryType the current category code corresponding to the portlet from which the user
    *           made the request, or null if not from within a category
    *//*
   public void requestAllExtracts(Patient patient, String categoryType) {
      List requestList = getVistaPhrRequestMultiplexor().multiplexRequests(patient, categoryType);
      logger.debug("requestAllExtracts multiplexed requests size = " + requestList.size());
      if (requestList.size() == 0) {
         return;
      }
      
      long patientRequestId = createPatientRequestRecord(patient, HEALTH_RECORD_UPDATES_FUNCTION_NAME);
      List preparedDestinedRequests = prepareToDispatch(requestList, patientRequestId);
      logger.info("requestAllExtracts: dispatching " + preparedDestinedRequests.size() + " requests to the outbound queue");
      dispatchToOutboundQueue(preparedDestinedRequests);
      logger.debug("requestAllExtracts: completed");
   }

   *//**
    * Preprocesses requests to add control values and creating database entries to track the
    * request.
    * 
    * @param requestList List of DestinedRequests with site, category and payload of
    *           PHRRequestPayload that contains the Patient object
    * @param patientRequestId key of the parent PatientRequest
    *//*
   private List prepareToDispatch(List requestList, long patientRequestId) {
      Iterator requests = requestList.iterator();
      DestinedRequest request = null;
      List preparedRequests = new ArrayList(requestList.size());

      while (requests.hasNext()) {
         request = (DestinedRequest) requests.next();
         request.setPatientRequestId(patientRequestId);
         preprocessRequest(request);
         preparedRequests.add(request);
      }
      return preparedRequests;
   }

   *//**
    * Queues each request.
    * 
    * @param requestList List of DestinedRequests with site, category and payload of
    *           PHRRequestPayload that contains the Patient object
    *//*
   private void dispatchToOutboundQueue(List requestList) {
      OutMessageDispatcher dispatcher = getOutMessageDispatcher();
      Iterator requests = requestList.iterator();
      while (requests.hasNext()) {
         DestinedRequest request = (DestinedRequest) requests.next();
         dispatcher.sendObjectMessage(request);
      }
   }

   *//**
    * Queues an MPI message (ADT-A24) to link a Patient with MHV, thus subscribing MHV to MPI�s
    * Patient Change Notifications broadcasts for this patient. Writes the MessagingRequest to the
    * database to track the ACK response.
    * 
    * @param patient containing the icn and user id
    *//*
   public void linkPatient(Patient patient) {
      dispatchMpiRequest(patient, LINK_PATIENT_MESSAGE_TYPE);
   }

   *//**
    * Queues an MPI message (ADT-A37) to unlink a Patient from MHV, thus unsubscribing the MHV from
    * future Patient Change Notifications for this patient. Writes the MessagingRequest to the
    * database to track the ACK response.
    * 
    * @param patient containing the icn and user id
    *//*
   public void unlinkPatient(Patient patient) {
      dispatchMpiRequest(patient, UNLINK_PATIENT_MESSAGE_TYPE);
   }

   *//**
    * Does the common work of populating the MPI request and dispatching it for both Link and Unlink
    * MPI messages.
    * 
    * @param patient
    * @param messageType
    *//*
   protected void dispatchMpiRequest(Patient patient, MessageType messageType) {
      DestinationKey destinationKey = new DestinationKey(NamingDirectory.getMpiSystemId());
      DestinedRequest request = new DestinedRequest(destinationKey, messageType, patient);

      long patientRequestId = createPatientRequestRecord(patient, request.getFunctionName());
      request.setPatientRequestId(patientRequestId);

      preprocessRequest(request);
      getOutMessageDispatcher().sendObjectMessage(request);
   }

   *//**
    * Make Synchronous call to MPI lookup for the ICN (message VQQ_Q02) retrieve the Patient and
    * their treatment locations for patients exactly matching the user's last name, first name,
    * social security number and date of birth.
    * 
    * @param user containing the last name, first name, social security number and date of birth to
    *           match on in MPI
    * @return Response containing DtoListPayload or StatusPayload, or ErrorResponse if an exception
    *         occcred. The normal response is the DtoListPayload containing
    *         gov.va.med.domain.model.Patient objects each containing their Institutions. Normally
    *         this will only contain one patient. Patients and their facilitites do not have the
    *         UserIdSeq, only the ICN
    * @throws MessagingException
    * 
    * First name is optional, if not supplied it must b set to null. We filter out all non-exact
    * matches on first name (if not null), last name, ssn and dob.
    *//*
   public Response lookupPatient(final User user) {

      DestinedRequest request = new DestinedRequest(new DestinationKey(NamingDirectory.getMpiSystemId()), PATIENT_LOOKUP_MESSAGE_TYPE, user);

      Response response = sendSynchronousMessage(request);
      if (!(response.getPayload() instanceof DtoListPayload)) {
         return response;
      }

      DtoListPayload patients = (DtoListPayload) response.getPayload();
      Iterator mpiPatients = patients.getDtoIterator();
      while (mpiPatients.hasNext()) {
         Patient patient = (Patient) mpiPatients.next();
         // NOTE the following logic filters out MPI's fuzzy matches
         // by applying our exact match filtering. Per MPI usage agreemnt
         if (!user.isSameAsMpiUser(patient)) {
            mpiPatients.remove();
         }
         else {
            // NOTE: decoder only created sparse nstitutions with a Station Number in them
            refreshInstitutions(patient);
         }
      }
      return response;
      // NOTE: Currently, the User id is not populated in the Patient nor
      // the contained PateintTreatmentFacilities
   }

   *//**
    * Send an acknowledgement to the sending application that a message was received. <BR>
    * NOTE: The metaData can optionally contain the original message in it from which additional
    * values can be extracted for the ACK as needed by the ack encoder.
    * 
    * @param metaData message header info needed to send the ack
    *//*
   public void sendApplicationAck(HL7MessageMetadata metaData) {
      DestinationKey destinationKey = new DestinationKey(metaData.getSendingSystemId());

      // The function is either a generic application ack or specific to the orginal messege's
      // function
      // If sepcific to function, it is currently only for unsolicited messages: usually MPI.
      String functionName = (metaData.getFunctionName() != null) ? metaData.getFunctionName() : metaData.SEND_APPLICATION_ACK_FUNCTION;

      MessageType messageType = new MessageType(functionName, MessageExchangePatternType.ASYNCHRONOUS_MESSAGE_EXCHANGE_PATTERN);
      DestinedRequest request = new DestinedRequest(destinationKey, messageType, metaData);

      getOutMessageDispatcher().sendObjectMessage(request);
   }*/

   /**
    * Make a synchronous call to a VistA site to for this RxRefillRequest request.
    * <UL>
    * Known functions to date (although not restricted to these) are:
    * <LI>refillPrescriptions
    * <LI>getPrescriptionStatus
    * <LI>getPrescriptionProfile
    * </UL>
    * All functions expect an RxRefillPayload.
    * 
    * @param request containing an RxRefillPayload containing the patient on whose behalf the
    *           request is being made, and the institution to which the request will be sent.
    * 
    * @return Response containing RxRefillPayload or StatusPayload, or ErrorResponse
    */
   public Response sendRxRefillRequest(Request request) {

      RxRefillPayload rxRefillPayload = (RxRefillPayload) request.getPayload();
      DestinationKey key = new DestinationKey(rxRefillPayload.getInstitution().getStationNumber());
      key.setInstitutionId(new Long(rxRefillPayload.getInstitution().getLongId()));

      DestinedRequest destinedRequest = new DestinedRequest(key, request.getMessageType(), rxRefillPayload);
      destinedRequest.setUserId(request.getUserId());
      return sendSynchronousMessage(destinedRequest);
   }

   /**
    * Reusable method to send any DestinedRequest synchronously
    * 
    * @param request as needed for your purposes.
    * @return Response containing RxRefillPayload or StatusPayload, or ErrorResponse
    */
   public Response sendSynchronousMessage(DestinedRequest request) {
      //IMessageSender messageSender = (IMessageSender) ObjectFactory.getBean(MessagingConstants.MESSAGE_SENDER_BEAN_NAME);
      return messageSender.sendSynchronousMessage(request);
   }

   /*
   *//**
    * Create a PatientRequest to be used as parent for related request messages.
    * 
    * @return the key of the parent PatientRequest.
    *//*
   private long createPatientRequestRecord(Patient patient, String functionName) {
      PatientMessagingRequestDAO dao = (PatientMessagingRequestDAO) ObjectFactory.getBean(PATIENT_MESSAGING_REQUEST_DAO_BEAN_NAME);
      PatientMessagingRequest patientRequest = dao.createNew(patient.getLongId(), patient.getIcn(), functionName);
      long patientRequestId = ((Long) patientRequest.getId()).longValue();
      return patientRequestId;
   }

   *//**
    * Prepares the request by persisting it and updating it with necessary control values.
    * <P>
    * Looks up the station number by InstituionId if needed to populate the DestinationKey.
    * 
    * @param request containing the payload, functionName and desinationKey.
    *//*
   private void preprocessRequest(DestinedRequest request) {

      Function function = lookupFunction(request);

      if (function.getPhrFunction() != null) {
         writePhrMessagingRequest(request, function);
      }
      else {
         writeNonPhrMessagingRequest(request);
      }
   }

   *//**
    * Messages for Phr extracts need special manipulation before persisting and transferring to
    * encoder.
    *//*
   private void writePhrMessagingRequest(DestinedRequest request, Function function) {
      MessagingRequestDAO dao = (MessagingRequestDAO) ObjectFactory.getBean(MessagingConstants.MESSAGING_REQUEST_DAO_BEAN_NAME);
      MessagingRequest messagingRequest;
      PHRRequestPayload payload = (PHRRequestPayload) request.getPayload();

      updateStationNumber(request.getDestinationKey());
      updateDateRange(request, (String) function.getCategoryType().getId(), payload);
      long institutionId = request.getDestinationKey().getInstitutionId().longValue();

      messagingRequest = dao.createNew(institutionId, request.getFunctionName(), request.getPatientRequestId(), payload.getFromDate(), payload.getToDate());
      if (logger.isDebugEnabled()) {
         logger.debug("Created new messaging request: " + messagingRequest);
      }

      long longRequestId = ((Long) messagingRequest.getId()).longValue();
      request.setRequestId(longRequestId);
      payload.setRequestId(String.valueOf(longRequestId));
   }

   *//**
    * Generally, these are MPI requests. They are persisted to track and match to the Application
    * ACK when it arrives. Also, the Destination Id is derived here from the Station number.
    *//*
   private void writeNonPhrMessagingRequest(DestinedRequest request) {

      MessagingRequestDAO dao = (MessagingRequestDAO) ObjectFactory.getBean(MessagingConstants.MESSAGING_REQUEST_DAO_BEAN_NAME);
      updateInstitutionId(request.getDestinationKey());
      MessagingRequest messagingRequest = dao.createNew(request.getDestinationKey().getInstitutionId().longValue(), request.getFunctionName(), request.getPatientRequestId());

      long longRequestId = ((Long) messagingRequest.getId()).longValue();
      request.setRequestId(longRequestId);
   }

   *//**
    * For requests missing the Station number, the destination id is used to look up station number
    * and set it.
    *//*
   protected static void updateStationNumber(DestinationKey key) {
      String stationNumber = ((Institution) getInstitutionDao().load(Institution.class, key.getInstitutionId())).getStationNumber();
      key.setStationNumber(stationNumber);
   }

   *//**
    * For requests missing the destination Id, the StationNumber is used to look it up and set it.
    *//*
   protected static void updateInstitutionId(DestinationKey key) {
      Long institutionId = (Long) getInstitutionDao().getByStationNumber(key.getStationNumber()).getId();
      key.setInstitutionId(institutionId);
   }

   *//**
    * Derives the date range from the last successful extract for this category patient and site and
    * then sets the dates on the request payload.
    * <P>
    * A null fromDate causes extract from earliest record. A null toDate causes extracts through
    * current date.
    * <P>
    * While the toDate always is null in today's implementaiton, it is thought that it may be used
    * in future extract scenarios.
    *//*
   protected void updateDateRange(DestinedRequest request, String categoryId, PHRRequestPayload payload) {
      CategoryActivityDAO dao = (CategoryActivityDAO) ObjectFactory.getBean(MessagingConstants.MESSAGING_CATEGORY_ACTIVITY_DAO_BEAN_NAME);
      CategoryActivity activity = dao.getByIdFields(request.getUserId(), request.getDestinationKey().getInstitutionId().longValue(), categoryId);

      if (activity != null) {
         Date fromDate = activity.getLastExtractActivityDate();
         payload.setFromDate(fromDate);
         payload.setToDate(null);
      }
   }

   private Function lookupFunction(DestinedRequest request) {
      String functionName = request.getMessageType().getRemoteFunctionName();
      return FunctionLookup.getInstance().getById(functionName);
   }

   private static InstitutionDAO getInstitutionDao() {
      return (InstitutionDAO) ObjectFactory.getBean("institutionDao");
   }

   private OutMessageDispatcher getOutMessageDispatcher() {
      return (OutMessageDispatcher) ObjectFactory.getBean(OUT_MESSAGE_DISPATCHER_BEAN_NAME);
   }

   private VistaPhrRequestMultiplexor getVistaPhrRequestMultiplexor() {
      return (VistaPhrRequestMultiplexor) ObjectFactory.getBean(VISTA_PHR_REQUEST_MULTIPLEXOR_BEAN_NAME);
   }

   *//**
    * Replaces the sparse Institutions (Station Number only) in the Patient with fully populated
    * institutions as read from the database.
    * 
    * @param patient
    *//*
   private void refreshInstitutions(Patient patient) {
      InstitutionDAO dao = getInstitutionDao();
      Iterator sparseInstitutions = patient.getInstitutions().iterator();

      Institution cmorInstitution = dao.getByStationNumber(patient.getCmorStationNumber());
      if (cmorInstitution != null) {
         patient.setCmorInstitutionId(new Long(cmorInstitution.getLongId()));
      }

      Set fullInstitutions = new HashSet();
      while (sparseInstitutions.hasNext()) {
         Institution oldInstitution = (Institution) sparseInstitutions.next();
         Institution newInstitution = dao.getByStationNumber(oldInstitution.getStationNumber());
         if (newInstitution == null) {
            logger.warn("Invliad Station Number from MPI Patient Lookup [" + oldInstitution.getStationNumber() + "] for patient  ICN [" + patient.getIcn() + "]");
         }
         else {
            fullInstitutions.add(newInstitution);
         }
      }
      patient.setInstitutions(fullInstitutions);
   }

   *//**
    * Used to prequalfy a request by checking to ensure that the configuration and is in place to
    * send the function to endpoint.
    * 
    * NOTE: This does not ensure no problems will occur, but guarantees that the Function has a
    * legitmate association with a Destination that supports it.
    * <P>
    * Rationale: for providing this method The request should not be issued if the Destination is
    * not valid for this Function becuase it will cause predictable and avoidable problems.
    * <UL>
    * <LI>The patient may have records in a destination that has not been activated yet (highly
    * likely during Alpha and Beta)<BR>
    * <LI>The destination may exist but not be configured for this function (possible if the
    * desitnation is set up for RX Refill but not for PHR)
    * </UL>
    * 
    * @param functionName as defined in the Functions table
    * @param institutionId with the Standard Institution id of the desination
    * @return true if it looks valid, false if not
    *//*
   public boolean isFunctionValidForDestination(String functionName, long institutionId) {
      DestinationKey key = new DestinationKey(new Long(institutionId));
      updateStationNumber(key);
      return NamingDirectory.isFunctionValidForDestination(functionName, key);
   }*/
   
}
