package gov.va.med.domain.service.messaging.environment;

import gov.va.med.domain.DomainConstants;
import gov.va.med.domain.persistence.util.FunctionLookup;
//import gov.va.med.domain.persistence.util.PhrFunctionLookup;
import gov.va.med.domain.service.config.MhvConfigService;
import gov.va.med.domain.service.messaging.MessagingConstants;
//import gov.va.med.framework.InvalidConfigurationException;
//import gov.va.med.framework.spring.DefaultApplicationContext;

import java.util.Map;
import java.util.TreeMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Acts as the main class for lookup and caching of configuration values.  
 * Loads the configuration values for Destinations, Functions, and other
 * parameters that direct the framework in processing supported messages,
 * destinations and protocols. 
 * <P>
 * This class provides a quick lookup of a Destination which is the main class 
 * that holds various structures of confguration values.   
 * <P>
 * Currently the data is loaded from the Evault tables but this has been 
 * a subject of debate as xml/properties files alternatives are considered.  
 * For this reason and for reasons to support testing,
 * the actual load processing has been factored into DestinationLoader that 
 * can be swapped out by changing the bean definition in domainMessagingContext.xml.   
 * <P>
 * @author Odysseas Pentakalos
 * @version $Id: NamingDirectory.java,v 1.18 2005/11/14 21:07:44 slava.uchitel Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
@Component
public class NamingDirectory
{
	private static final int DEFAULT_NAMING_DIRECTORY_REFRESH_INTERVAL = 5;
    private static Logger log = LogManager.getLogger(NamingDirectory.class);
	//private static Map destinationsMap = loadDestinations();
    private static Map destinationsMap = null;
	private static long lastLoadTime = System.currentTimeMillis();  
	
	@Autowired
	private FunctionLookup functionLookup;
	
	@Autowired
	private gov.va.med.domain.service.messaging.environment.DestinationLoader destinationLoader; 
	
	private NamingDirectory() {
    }
	/**
	 * Looks up the Destination by the Station Number of key provided.<BR>
	 * NOTE:  As implemented, this can only work with a Station Number because the 
	 * implementation of the destinationsMap is a TreeMap that uses 
	 * StationNumber in the compare.   
	 * @param key with populated StationNumber 
	 * @return the Destination or null if not found under the Station Number.  
	 */
    public Destination getDestination(DestinationKey key) {
        reloadIfTime();
        Destination destination = (Destination) destinationsMap.get(key);
        if (destination != null && (!destination.isActive())) {
            destination = null;
        }
        return destination;
    }
    
    public static String getMpiSystemId() {

        try {
            String mpiStationNumber = MhvConfigService.getInstance().getParamValueString(DomainConstants.MPI_STATION_NUMBER);

            if (mpiStationNumber != null) {
                return mpiStationNumber;
            }
        } catch (Throwable e) {
            log.warn("Could not load MhvConfigManager to get MPI Station Id");
        }

        log.debug("Using the default MPI station number for MPI Message");
        return MessagingConstants.DEFAULT_MPI_STATION_NUMBER;
    }
    /**
     * Used to prequalfy a request by checking to ensure:
     * <UL>
     * <LI>The Destination exists in the DESTINATIONS configuration table
     * <LI>The destination is active
     * <LI>The destination has a version of the MHV package that supports the Function.   
     * <LI>The Function is configured to use the Desitnation in FUNCTION_ENDPOINTS table.  
     * </UL>
     * NOTE:  This does not ensure no problems will occur,  
     * but guarantees that the Function has a legitmate association 
	 * with a Destination that supports it.  It does not check Protocol Parameters.
	 * <P>
	 * Rationale: for providing this method  The request should not be issued if the 
	 * Destination is not valid for this Function becuase it will
	 * cause predictable and avoidable problems.  
	 * <UL>
	 * <LI>The patient may have records in a destination that
	 * has not been activated yet (highly likely during Alpha and Beta)<BR>
	 * <LI>The destination may exist but not be configured for this function
	 * (possible if the desitnation is set up for RX Refill but not for PHR)
	 * </UL> 
     * @param functionName as defined in the Functions table
     * @param destinationKey with the Station number populated
     * @return true if it looks valid, false if not
     */
    /*public static boolean isFunctionValidForDestination(String functionName, 
            											DestinationKey destinationKey) {
        
        Destination destination = getDestination(destinationKey);
	    if (destination == null) {
	        // site not configured  
	        return false;
	    }
	    if (!destination.isActive() || !destination.isParticipating()) {
	        // inactive site
	        return false;
	    }

	    if (!VersionInterpreter.isFunctionSupportedByVersion(functionName, 
	                                                        destination.getMajorVersion(), 
	                                                        destination.getMinorVersion())) {
	        // not expected to send this function to this site
	        return false;
	    }
	    
        if (isFunctionConfiguredForDestination(functionName, destinationKey)) {
            	// configured as expected
            	return true;   
        }

        // Not configured as expected so it is considered a mis-configuration error.  
        // So log it, but do not throw exception. 
        
        log.error("Configuration error.  Function [" + functionName  + 
                  "] not associated with Station [" + destinationKey.getStationNumber() +"]");
        return false; 
    }*/
 	/**
	 * Used to politely prequalfy a request by checking to ensure  
	 * the destination and function are configured.   This does not ensure no 
	 * problems will occur but guarantees that the Function has a legitmate association 
	 * with the Destination.  It does not check Protocol Parameters.
	 * <P>
	 * Rationale:  The request should not be issued if the 
	 * Destination is not configured for this Function becuase it will
	 * cause problems when we could have known not to send it in the first place.  
	 * <UL>
	 * <LI>The patient may have records in a destination that
	 * has not been activated yet (highly likely during Alpha and Beta)<BR>
	 * <LI>The destination may exist but not be configured for this function
	 * (possible if the desitnation is set up for RX Refill but not for PHR)
	 * </UL> 
	 *  
	 * @param functionName the name as stored in the FUNCTIONS table. 
	 * @param destinationKey
	 */
    /*public static boolean isFunctionConfiguredForDestination(String functionName, 
	        											     DestinationKey destinationKey) {
	    Destination destination = getDestination(destinationKey);
	    try {
	        if (destination == null) {
	            return false;
		    }
		    if (destination.getFunction(functionName) == null) {
		        return false;
		    }
		    return true;
	    }
	    catch (InvalidConfigurationException e) {
	        return false;
	    }
	}
    *//**
     * Loads the configuration tables into cache.  
     * This is public to enable invocation from exteranl triggers. 
     */
    private Map loadDestinations() {
        //TODO set a timer using Spring Quartz to refresh the loaded config.  
        Map destMap = new TreeMap();
        /*DestinationLoader loader = (DestinationLoader)
            DefaultApplicationContext.getInstance()
            	.getBean(MessagingConstants.DESTINATION_LOADER_BEAN_NAME);
        loader.loadDestinationEntries(destMap);*/
        destinationLoader.loadDestinationEntries(destMap);
        return destMap;
    }
    
    public void reload() {
        destinationsMap = loadDestinations();
        lastLoadTime = System.currentTimeMillis(); // no accessors because it is temporary.  
    }
    /**
     * Temporary code until a common timer mechanism can be set up. 
     * Causes reload of destination every 10 miniutes.
     *
     */
    private void reloadIfTime() {
        synchronized (NamingDirectory.class)
        {
        	//TODO: load value from a propertyfile - SRE
        	/*int periodInMinutes = 15;//MhvConfigService.getInstance().getParamValueInt(MessagingConstants.NAMING_DIRECTORY_REFRESH_INTERVAL);
            if (periodInMinutes < 0) {
                periodInMinutes = DEFAULT_NAMING_DIRECTORY_REFRESH_INTERVAL;
            }
        	if (System.currentTimeMillis() - lastLoadTime > periodInMinutes*60000) {
                //FunctionLookup.getInstance().load();
                //PhrFunctionLookup.getInstance().load();
                functionLookup.load();
                reload();
            }*/
        	
        	functionLookup.load();
            reload();
        }
    }
}
