package gov.va.med.domain.service.messaging.environment;

//import gov.va.med.domain.model.Function;

import gov.va.med.mhv.rxrefill.data.model.Function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * EndPoint
 *
 * @author Odysseas Pentakalos
 * @version $Id: EndPoint.java,v 1.2 2005/06/08 20:03:07 joel.goldberg Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class EndPoint
{
	private Destination destination;
	private String encodingType;
	private String protocolType;
	private String transceiver;
    private long endpointId;
	private List functionList = new ArrayList();
	private Map functionMapByName = new TreeMap();
    private HashMap protocolParameters = new HashMap();
    private HashMap encodingParameters = new HashMap();
    
    public EndPoint(Destination destination) {
        this.destination = destination;
    }
    
    public EndPoint() {
    }
    
    public Destination getDestination() {
    	return destination;
    }
    
    public void setDestination(Destination destination) {
    	this.destination = destination;
    }
    
    public String getProtocolParameter(String name)
    {
        return (String) protocolParameters.get(name);
    }
    
    public int getIntProtocolParameter(String name) {
        return Integer.parseInt(getProtocolParameter(name));
    }
    
    public String getEncodingParameter(String name)
    {
        return (String) encodingParameters.get(name);
    }
    
    public void setProtocolParameter(String name, String value)
    {
        protocolParameters.put(name, value);
    }
    
    public void setEncodingParameter(String name, String value)
    {
        encodingParameters.put(name, value);
    }
    public void addFunction(Function function) {
    	getFunctionList().add(function);
    	getFunctionMapByName().put(function.getFunctionName(), function);
    }
    public List getFunctionList() {
    	return functionList;
    }
    public Function getFunctionByName(String functionName) {
    	return (Function) functionMapByName.get(functionName);
    }
    public Iterator getFunctionIterator() {
    	return getFunctionList().iterator();
    }
	/**
	 * @return Returns the endpointId.
	 */
	public long getEndpointId() {
		return endpointId;
	}
	/**
	 * @param endpointId The endpointId to set.
	 */
	public void setEndpointId(long endpointId) {
		this.endpointId = endpointId;
	}
	/**
	 * @return Returns the encodingType.
	 */
	public String getEncodingType() {
		return encodingType;
	}
	/**
	 * @param encodingType The encodingType to set.
	 */
	public void setEncodingType(String encodingType) {
		this.encodingType = encodingType;
	}
	/**
	 * @return Returns the protocolType.
	 */
	public String getProtocolType() {
		return protocolType;
	}
	/**
	 * @param protocolType The protocolType to set.
	 */
	public void setProtocolType(String protocolType) {
		this.protocolType = protocolType;
	}
	/**
	 * @return Returns the encodingParameters.
	 */
	public HashMap getEncodingParameters() {
		return encodingParameters;
	}
	/**
	 * @param encodingParameters The encodingParameters to set.
	 */
	public void setEncodingParameters(HashMap encodingParameters) {
		this.encodingParameters = encodingParameters;
	}
	/**
	 * @return Returns the transceiver.
	 */
	public String getTransceiver() {
		return transceiver;
	}

	public void setTransceiver(String tranceiver) {
		this.transceiver = tranceiver;
	}
    protected Map getFunctionMapByName() {
        return functionMapByName;
    }
    protected HashMap getProtocolParameters() {
        return protocolParameters;
    }
}
