package gov.va.med.domain.service.messaging.environment;

import gov.va.med.domain.persistence.jdbc.helper.DestinationEntry;
import gov.va.med.domain.persistence.jdbc.helper.EndpointEntry;
import gov.va.med.domain.persistence.jdbc.helper.ParameterEntry;
//import gov.va.med.domain.persistence.jdbc.dao.MessagingConfigurationDao;
//import gov.va.med.domain.persistence.jdbc.helper.DestinationEntry;
//import gov.va.med.domain.persistence.jdbc.helper.EndpointEntry;
//import gov.va.med.domain.persistence.jdbc.helper.ParameterEntry;
import gov.va.med.domain.persistence.util.FunctionLookup;
import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.framework.conversion.converter.DestinationConverter;
import gov.va.med.mhv.rxrefill.converter.DestinationFunctionConverter;
import gov.va.med.mhv.rxrefill.converter.EncodingParameterConverter;
import gov.va.med.mhv.rxrefill.converter.ProtocolParameterConverter;
//import gov.va.med.framework.util.ObjectFactory;
import gov.va.med.mhv.rxrefill.data.model.Destination;
import gov.va.med.mhv.rxrefill.data.model.DestinationFunction;
import gov.va.med.mhv.rxrefill.data.model.Function;
import gov.va.med.mhv.rxrefill.data.repository.DestinationFunctionRepository;
import gov.va.med.mhv.rxrefill.data.repository.DestinationRepository;
import gov.va.med.mhv.rxrefill.data.repository.EncodingParameterRepository;
import gov.va.med.mhv.rxrefill.data.repository.ProtocolParameterRepository;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Engages the MessageConfigurationDAO to load the desitnations from the database.
 * This class is loaded with bean name in constant DESTINATION_LOADER_BEAN_NAME
 * and can be mocked out for testing or alternate sourcing of these configurations.
 *
 * This is factored into a separate class to decouple the NamingDirectory from the
 * mechanism of loading from the database.
 *
 * Coupling to database loading is undesirable for the service objects
 * who require these values.  They should not concern themselves with the source.  By
 * factoring the loading out,  it makes the transition to use alternate sources of
 * configuration data easier.
 *
 * @author Joel Goldberg
 * @version $Id: DestinationLoader.java,v 1.11 2005/08/04 18:39:21 slava.uchitel Exp $
 * @since MHV 2.0 <br>Mar 23, 2005
 */
@Component
public class DestinationLoader {
	private static Logger logger = LogManager.getLogger(DestinationLoader.class);

	@Autowired
	private DestinationRepository destinationRepository;

	@Autowired
	private DestinationFunctionRepository destinationFunctionRepository;

	@Autowired
	private DestinationFunctionConverter destinationFunctionConverter;

	@Autowired
	private ProtocolParameterRepository protocolParameterRepository;

	@Autowired
	private ProtocolParameterConverter protocolParameterConverter;

	@Autowired
	private EncodingParameterRepository encodingParameterRepository;

	@Autowired
	private EncodingParameterConverter encodingParameterConverter;

	@Autowired
	private FunctionLookup functionLookup;

	/**
	 * reads messaging confguration tables and populates the Destinations in
	 * destinationsMap.
	 *
	 * @param destinationsMap to populate
	 */
	protected void loadDestinationEntries(Map destinationsMap) {
		//MessagingConfigurationDao dao = (MessagingConfigurationDao)ObjectFactory.getBean(MessagingConstants.MESSAGING_CONFIGURATION_DAO_BEAN_NAME);
		// Creates Map for quickly loading endpoints
		//Map destinationMapById = loadDestinations(destinationsMap, dao);
		//TODO: Fix me - SRE
		//Map endpointMapById = loadEndpointsAndRemoteFunctions(dao, destinationsMap, destinationMapById);
		//loadProtocolParameters(dao, endpointMapById);
		//Set invalidEndpoints = loadEncodingParameters(dao, endpointMapById);

		Map destinationMapById = loadDestinations(destinationsMap);
		Map endpointMapById = loadEndpointsAndRemoteFunctions(destinationsMap, destinationMapById);
		loadProtocolParameters(endpointMapById);
		Set invalidEndpoints = loadEncodingParameters(endpointMapById);

		removeInvalidEndpoints(invalidEndpoints, endpointMapById);
	}

	private Map loadDestinations(Map destinationsMap) {
		//Iterator destinations = dao.getDestinations().iterator();
		/*while (destinations.hasNext()) {
    		DestinationEntry destinationEntry = (DestinationEntry) destinations.next();
    		Destination destination = destinationEntry.getDestination();
    		DestinationKey key = new DestinationKey(destination.getDestinationKey());
    		key.setInstitutionId(new Long(destination.getInstitutionId()));
    		destinationsMap.put(key, destination);
    		destinationMapById.put(new Long(destination.getDestinationId()), destination);
    	}*/

		Map destinationMapById = new TreeMap();

		List<Destination> destinations = null;
		try {
			destinations = destinationRepository.getDestinations();
		} catch(Exception e) {
			logger.error("Error in fetching destinations ", e);
			//swallow exception
		}

		if (null != destinations && destinations.size() > 0) {
			for (Destination dest: destinations) {
				DestinationEntry destinationEntry = new DestinationConverter().convert(dest);
				gov.va.med.domain.service.messaging.environment.Destination destination = destinationEntry.getDestination();
				DestinationKey key = new DestinationKey(destination.getDestinationKey());
				key.setInstitutionId(new Long(destination.getInstitutionId()));
				destinationsMap.put(key, destination);
				destinationMapById.put(new Long(destination.getDestinationId()), destination);
			}
		} else {
			logger.error("destinations is null");
		}

		return destinationMapById;
	}

	private Map loadEndpointsAndRemoteFunctions(Map destMap, Map destMapById) {
		// Map for quickly loading protocol and encoding parameters
		Map endpointMapById = new TreeMap();
		long prevEndPointId = -1;
		EndPoint endpoint=null;
		gov.va.med.domain.service.messaging.environment.Destination destination = null;
		List<DestinationFunction> destinationFunctions = null;

		try {
			destinationFunctions = destinationFunctionRepository.findAll();
		} catch(Exception e) {
			logger.error("Error in fetching destinationFunctions ", e);
			//swallow exception
		}

		if (null != destinationFunctions && destinationFunctions.size() > 0) {
			for (DestinationFunction destinationFunction : destinationFunctions) {
				EndpointEntry endpointEntry = destinationFunctionConverter.convert(destinationFunction);
				if (endpointEntry.getEndpointId() != prevEndPointId) {
					// Break on DESTINATION_ENDPOINT_ID_SEQ ===> start new current EndPoint
					destination = (gov.va.med.domain.service.messaging.environment.Destination) destMapById.get(new Long(endpointEntry.getDestinationId()));
					endpoint = endpointEntry.buildEndpoint(destination);
					destination.addEndPoint(endpoint);
					endpointMapById.put(new Long(endpoint.getEndpointId()), endpoint);
					prevEndPointId = endpoint.getEndpointId();
				}
				// Keep adding functions to current EndPoint
				//Function function =  FunctionLookup.getInstance().getById(endpointEntry.getFunctionName());
				Function function =  functionLookup.getById(endpointEntry.getFunctionName());
				if(endpoint != null){
				  endpoint.addFunction(function);
				}
				if(destination != null){
				   destination.addEndPointFunction(endpoint, function);
				}
			}
		} else {
			logger.error("destinationFunctions is null");
		}

		/*for (Iterator endPoints = dao.getEndpoints().iterator(); endPoints.hasNext();) {
            EndpointEntry endpointEntry = (EndpointEntry) endPoints.next();
            if (endpointEntry.getEndpointId() != prevEndPointId) {
                // Break on DESTINATION_ENDPOINT_ID_SEQ ===> start new current EndPoint
                destination = (Destination) destMapById.get(new Long(endpointEntry.getDestinationId()));
                endpoint = endpointEntry.buildEndpoint(destination);
                destination.addEndPoint(endpoint);
                endpointMapById.put(new Long(endpoint.getEndpointId()), endpoint);
                prevEndPointId = endpoint.getEndpointId();
            }
            // Keep adding functions to current EndPoint
            Function function =  FunctionLookup.getInstance().getById(endpointEntry.getFunctionName());
    		endpoint.addFunction(function);
            destination.addEndPointFunction(endpoint, function);
        }*/

		return endpointMapById;
	}

	private void loadProtocolParameters(Map endpointMapById) {
		// Add the protocol parameters to their endpoint.
		/*List protocolParamList = messagingConfigDao.getProtocolParams();
        for (Iterator iter = protocolParamList.iterator(); iter.hasNext(); ) {
            ParameterEntry paramEntry = (ParameterEntry) iter.next();
            EndPoint endpoint = (EndPoint) endpointMapById.get(new Long(paramEntry.getEndpointId()));
            endpoint.setProtocolParameter(paramEntry.getDescription(), paramEntry.getValue());
            log.debug("Added protocol parameter (" + paramEntry.getDescription() + "," +
                    paramEntry.getValue() + ") to endpoint with id " + paramEntry.getEndpointId() +
                    " of destination " + endpoint.getDestination().getName());
        }*/

		List<gov.va.med.mhv.rxrefill.data.model.ProtocolParameter> protocolParamList = null;

		try {
			protocolParamList = protocolParameterRepository.findAll();
		} catch(Exception e) {
			logger.error("Error in fetching protocolParamList ", e);
			//swallow exception
		}

		if (null != protocolParamList && protocolParamList.size() >0) {
			for (gov.va.med.mhv.rxrefill.data.model.ProtocolParameter protocolParameter : protocolParamList) {
				ParameterEntry paramEntry = protocolParameterConverter.convert(protocolParameter);
				EndPoint endpoint = (EndPoint) endpointMapById.get(new Long(paramEntry.getEndpointId()));
				endpoint.setProtocolParameter(paramEntry.getDescription(), paramEntry.getValue());

				if (logger.isDebugEnabled()) {
					logger.debug(String.format("Added protocol parameter (%s, %s) to endpoint with id %s of destination %s",
							paramEntry.getDescription(), paramEntry.getValue(), paramEntry.getEndpointId(), endpoint.getDestination().getName()));
				}
			}
		} else {
			logger.error("protocolParamList is null");
		}
	}

	private Set loadEncodingParameters(Map endpointMapById) {
		// add the encoding parameters to their endpoint.
		/*HashSet invalidEndpoints = new HashSet();
        List endpointParamList = messagingConfigDao.getEncodingParams();
        for (Iterator iter = endpointParamList.iterator(); iter.hasNext(); ) {
            ParameterEntry paramEntry = (ParameterEntry) iter.next();
            EndPoint endpoint = (EndPoint) endpointMapById.get(new Long(paramEntry.getEndpointId()));
            validateParameter(invalidEndpoints, paramEntry, endpoint);
            endpoint.setEncodingParameter(paramEntry.getDescription(), paramEntry.getValue());
            log.debug("Added encoding parameter (" + paramEntry.getDescription() + "," +
                    paramEntry.getValue() + ") to endpoint with id " + endpoint.getEndpointId() +
                    " of destination " + endpoint.getDestination().getName());
        }*/
		Set invalidEndpoints = new HashSet();

		List<gov.va.med.mhv.rxrefill.data.model.EncodingParameter> endpointParamList = null;
		try {
			endpointParamList = encodingParameterRepository.findAll();
		} catch(Exception e) {
			logger.error("Error in fetching endpointParamList ", e);
			//swallow exception
		}

		if (null != endpointParamList)
			if (logger.isDebugEnabled())
				logger.debug("In side DestinationLoader. endpointParamList is not null. Size::"+endpointParamList.size());
		else
			if (logger.isDebugEnabled())
				logger.debug("In side DestinationLoader. endpointParamList is NULL.");

		if (null != endpointParamList && endpointParamList.size() > 0) {
			if (logger.isDebugEnabled())
				logger.debug("In side endpointParamList null check");
			for (gov.va.med.mhv.rxrefill.data.model.EncodingParameter endpointParam : endpointParamList) {
				if (logger.isDebugEnabled())
					logger.debug("Calling encodingParameterConverter.convert");
				ParameterEntry paramEntry = encodingParameterConverter.convert(endpointParam);
				if (logger.isDebugEnabled())
					logger.debug("Getting Endpoint");
				EndPoint endpoint = (EndPoint) endpointMapById.get(new Long(paramEntry.getEndpointId()));
				if (logger.isDebugEnabled())
					logger.debug("Calling validateParameter");
				validateParameter(invalidEndpoints, paramEntry, endpoint);
				if (logger.isDebugEnabled())
					logger.debug("Calling setEncodingParameter");
				endpoint.setEncodingParameter(paramEntry.getDescription(), paramEntry.getValue());
				if (logger.isDebugEnabled())
					logger.debug("completed setEncodingParameter");
				if (logger.isDebugEnabled()) {
					logger.debug(String.format("Added encoding parameter (%s, %s) to endpoint with id %s of destination %s",
							paramEntry.getDescription(), paramEntry.getValue(), endpoint.getEndpointId(), endpoint.getDestination().getName()));
				}
			}
		} else {
			logger.error("endpointParamList is null");
		}

		return invalidEndpoints;
	}

	/**
	 * @param invalidEndpoints
	 * @param paramEntry
	 * @param endpoint
	 */
	protected void validateParameter(Set invalidEndpoints, ParameterEntry paramEntry, EndPoint endpoint) {

		if (logger.isDebugEnabled())
			logger.debug("inside  validateParameter");

		if (paramEntry.getDescription().equals(MessagingConstants.SYSTEM_TYPE))
		{
			if (logger.isDebugEnabled())
				logger.debug("inside  if check MessagingConstants.SYSTEM_TYPE");
			if (!(paramEntry.getValue().equals(MessagingConstants.MHV_SYSTEM_TYPE)))
			{
				if (logger.isDebugEnabled())
					logger.debug("inside  if check MessagingConstants.MHV_SYSTEM_TYPE");
				invalidEndpoints.add(new Long(paramEntry.getEndpointId()));
				if (logger.isDebugEnabled())
				logger.debug("Messaging system type mismatch between config " + MessagingConstants.MHV_SYSTEM_TYPE +
						" and database " + paramEntry.getDescription() + "=" +
						paramEntry.getValue() + " at endpoint with id " + endpoint.getEndpointId() +
						" of destination " + endpoint.getDestination().getName());
			}
		}
		if (paramEntry.getDescription().equals(MessagingConstants.SENDING_FACILITY))
		{
			if (logger.isDebugEnabled())
				logger.debug("inside  if check MessagingConstants.SENDING_FACILITY");

			if (!(paramEntry.getValue().equals(MessagingConstants.MHV_STATION_NUMBER)))
			{
				if (logger.isDebugEnabled())
					logger.debug("inside  if check MessagingConstants.MHV_STATION_NUMBER");

				invalidEndpoints.add(new Long(paramEntry.getEndpointId()));
				if (logger.isDebugEnabled())
				logger.debug("Messaging MHV station number mismatch between config " + MessagingConstants.MHV_STATION_NUMBER +
						" and database  " + paramEntry.getDescription() + "=" +
						paramEntry.getValue() + " at endpoint with id " + endpoint.getEndpointId() +
						" of destination " + endpoint.getDestination().getName());
			}
		}
	}

	protected void removeInvalidEndpoints(Set invalidEndpoints, Map endpointMapById)
	{
		Iterator endPointKeys = invalidEndpoints.iterator();
		while (endPointKeys.hasNext())
		{
			Object endPointKey = endPointKeys.next();
			endpointMapById.remove(endPointKey);
		}
	}
}
