package gov.va.med.domain.service.messaging.environment;

//import gov.va.med.domain.model.Function;
import gov.va.med.domain.service.messaging.Request;
import gov.va.med.framework.InvalidConfigurationException;
import gov.va.med.mhv.rxrefill.data.model.Function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Destination - DTO for the Destination Table plus some smart lookup getters
 *
 * @author Odysseas Pentakalos
 * @version $Id: Destination.java,v 1.9 2005/08/03 20:18:08 joel.goldberg Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class Destination {
	private static Logger logger = LogManager.getLogger(Destination.class);

	private long destinationId;
	private long institutionId;
	private String destinationKey;
	private String name;
	private boolean active;
	private boolean participating;
	private String version;
	private String majorVersion;
	private String minorVersion;
	private List endPointsList = new ArrayList();
	private Map endPointMapByFunctionName = new HashMap();

	/**
	 * Constructs the transceiver for the class specified for the 
	 * destination/endpoint.  The Transceiver is populated with the endpoint
	 *
	 * @param endPoint EndPoint
	 * @return Transceiver populated with the Endpoint
	 */
	/*public Transceiver getTransceiver(EndPoint endPoint) {
		return TransceiverFactory.getTransceiver(endPoint);
	}*/
	/**
	 * Looks up the Function.  
	 * Precondition:  The function name maps to a single DestinationEdnpoint.  
	 * If the same function name maps to multiple DestinationEdnpoint, results
	 * are not guaranteed as this is a configuration ambiguity.    
	 * @param functionName
	 * @return the DTO for the row in the FUNCTIONS table.  
	 * @throws InvalidConfigurationException
	 */
	public Function getFunction(String functionName) 
			throws InvalidConfigurationException {
		EndPoint endPoint = selectEndPointForFunction(functionName);
		return getFunction(endPoint, functionName);
	}
	/**
	 * Looks up the Function held in the Request under the specified endpoint.    
	 * @param request holding a function name
	 * @return the DTO for the row in the FUNCTIONS table.  
	 * @throws InvalidConfigurationException
	 */
	public Function getFunction(EndPoint endPoint, Request request) 
			throws InvalidConfigurationException {
		return getFunction(endPoint, request.getFunctionName());
	}
	/**
	 * Looks up the Function under the specified endpoint.  <BR>
	 * NOTE:  If there is concern that this endpoint and function
	 * are not configured, to avoid an exception,  use the 
	 * NamingDirectory method <ode>isFunctionConfiguredForDestination</code>.  
	 * @param functionName
	 * @return the function DTO for the row in the FUNCTIONS table.  
	 * @throws InvalidConfigurationException if the function not configured for the endpoint
	 */
	public Function getFunction(EndPoint endPoint, String functionName) 
			throws InvalidConfigurationException {
		Function remoteFunction = endPoint.getFunctionByName(functionName);
		if(remoteFunction == null) {
			String message = "Unable to locate function " + functionName +
			    " at endpoint " + endPoint.getEndpointId();
			logger.warn(message);   
			throw new InvalidConfigurationException(message);
		}
		return remoteFunction;
	}
    /**
     * Looks up the Endpoint to which the request's function is associated 
     * under this Destination. 
     * @param request with a function 
     */
	public EndPoint selectEndPoint(Request request) { 
		return selectEndPointForFunction(request.getFunctionName());
	}

	public EndPoint selectEndPointForFunction(String functionName) 
			throws InvalidConfigurationException {

		EndPoint endPoint 
				= (EndPoint)getEndPointMapByFunctionName().get(functionName);
		if(endPoint == null) {
			String message = "Unable to locate an appropriate endpoint for destination " 
			    + destinationKey +
			    " and remote function " + functionName;
			throw new InvalidConfigurationException(message);
		}
		return endPoint;
	}
	/**
	 * The uniquness constraint prvents more than one
	 * of the same protocol.  
	 * @param type example DS, MLLP, DCLLP 
	 */
	public EndPoint selectEndPointForProtocolType(String type) {
	    Iterator points = getEndPointIterator();
	    while (points.hasNext()) {
	        EndPoint point = (EndPoint)points.next();
	        if (point.getProtocolType().equals(type)) {
	            return point; 
	        }
	    }
	    return null; 
	}
	
	protected void addEndPoint(EndPoint endPoint) {
		endPointsList.add(endPoint);
	}

	protected void addEndPointFunction(EndPoint endPoint, Function function) {
	    String key = function.getFunctionName();
	    
	    // This check is necessary due to a lax integrtiy constraint
	    // on the config DB tables that allow the same Function to be 
	    // mapped to the same destination via multiple protocols 
	    // in the Destination_EndPoints table.  The framework is not designed 
	    // to differentiate since the protocol is suppposed to be looked up 
	    // (derived) through the function/destination
	    // relationship rather than known a priori and specified.  
	    
		if (getEndPointMapByFunctionName().containsKey(key))
		{
		    logger.error("Function [" + key + 
		              "] multiply mapped to same destination - station number [" + 
		              endPoint.getDestination().getDestinationKey() + "]" + '\n');
		}
		
		getEndPointMapByFunctionName().put(key, endPoint);
	}

	protected Map getEndPointMapByFunctionName() {return endPointMapByFunctionName;}
	protected void setEndPointMapByFunctionName(Map endPointMapByFunctionName) {
		this.endPointMapByFunctionName = endPointMapByFunctionName;
	}
	protected void setEndPointsList(List endPointsList) {this.endPointsList = endPointsList; }
	protected List getEndPointList() {return endPointsList;}
	protected Iterator getEndPointIterator() {return endPointsList.iterator();}
	public long getDestinationId() {return destinationId;}
	public void setDestinationId(long destinationId) {this.destinationId = destinationId;}
	public String getDestinationKey() {return destinationKey;}
	public void setDestinationKey(String destinationKey) {this.destinationKey = destinationKey;}
	public long getInstitutionId() {return institutionId;}
	public void setInstitutionId(long institutionId) {this.institutionId = institutionId;}
	public String getName() {return name;}
	public void setName(String name) {this.name = name;}
	public boolean isActive() {return active;}
	public void setActive(boolean active) {this.active = active;}
	
 
    /**
     * @return Returns the majorVersion.
     */
    public String getMajorVersion()
    {
        if (version == null)
            return null;
        if (version.equalsIgnoreCase("N/A"))
            return "N/A";
        return version.substring(0, version.indexOf("."));
    }
    /**
     * @return Returns the minorVersion.
     */
    public String getMinorVersion()
    {
        if (version == null)
            return null;
        if (version.equalsIgnoreCase("N/A"))
            return "N/A";
        return version.substring(version.indexOf(".")+1);
    }
    /**
     * @return Returns the participating.
     */
    public boolean isParticipating()
    {
        return participating;
    }
    /**
     * @param participating The participating to set.
     */
    public void setParticipating(boolean participating)
    {
        this.participating = participating;
    }
    /**
     * @return Returns the version.
     */
    public String getVersion()
    {
        return version;
    }
    /**
     * @param version The version to set.
     */
    public void setVersion(String version)
    {
        this.version = version;
    }
}
