package gov.va.med.domain.service.messaging.environment;

import gov.va.med.domain.service.messaging.MessagingConstants;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Constants used for managin the configuration tables.  Has constants
 * that align with the database to isolate the dependence between the 
 * Database and the Java code to one place.  
 * @author Joel Goldberg
 * @version $Id: ConfigurationConstants.java,v 1.1 2005/07/26 20:22:20 joel.goldberg Exp $
 * @since MHV 2.0 <br>Jul 26, 2005
 */
public class ConfigurationConstants {
    // Encoding Paremeter Types primary keys and names
    public static final int SYSTEM_TYPE_KEY = 1;
    public static final int SENDING_STATION_NUMBER_KEY = 2;
    public static final int SENDING_DOMAIN_KEY = 3;
    public static final int SENDING_APPLICATION_KEY = 4; 
   	public static final int RECEIVING_STATION_NUMBER_KEY = 5;
  	public static final int RECEIVING_DOMAIN_KEY = 6;
   	public static final int RECEIVING_APPLICATION_KEY = 7; 

    public static final String SYSTEM_TYPE_NAME = "System Type";
    public static final String SENDING_STATION_NUMBER_NAME = "Sending Station Number"; 
    public static final String SENDING_DOMAIN_NAME = "Sending Station Domain" ;      
    public static final String SENDING_APPLICATION_NAME = "Sending Application" ;    
    public static final String RECEIVING_STATION_NUMBER_NAME = "Receiving Station Number";                          
    public static final String RECEIVING_STATION_DOMAIN_NAME = "Receiving Station Domain" ;                         
    public static final String RECEIVING_APPLICATION_NAME = "Receiving Application" ;                            

   
   	// Protocol Parameter Types primary keys and names
   	public static final int IP_ADDRESS_KEY = 1;
   	public static final int DOMAIN_NAME_KEY = 2;
   	public static final int PORT_NUMBER_KEY = 3;
   	public static final int TIMEOUT_KEY = 4;  

   	public static final String IP_ADDRESS_NAME = "IP";
   	public static final String DOMAIN_NAME_NAME = "DN";
   	public static final String PORT_NUMBER_NAME = "Port Number";
   	public static final String TIMEOUT_NAME = "TimeOut";  
   	
   	// Protocol Types In Destination_EndPoints table. 
   	public static final String MLLP = "MLLP";
   	public static final String DCLLP = "DCLLP";
   	public static final String DELIVERY_SERVICES = "DS"; 

   	public static final String HL7_ENCODING_TYPE = "HL7"; 
   	
   	public static Map transceiverBeanNamesByProtocol; 
   	
   	public static final List MLLP_FUNCTION_NAMES = VersionInterpreter.getRxRefillFunctions();
   	
   	public static final List DELIVERY_SERVICES_FUNCTION_NAMES = VersionInterpreter.getPhrFunctions();
 
   	static {
       Map aMap = new HashMap();
       aMap.put(MLLP, MessagingConstants.HL7_MLLP_TRANSCEIVER_BEAN_NAME);
       aMap.put(DCLLP, MessagingConstants.HL7_DCLLP_TRANSCEIVER_BEAN_NAME);
       aMap.put(DELIVERY_SERVICES, MessagingConstants.DELIVERY_SERVICES_TRANSCEIVER_BEAN_NAME);
       setTransceiverBeanNamesByProtocol(aMap);
   	}
   
   	public String tranceiverForProtocal(String protoclType) {
   	    return (String) getTransceiverBeanNamesByProtocol().get(protoclType);
   	}
   
	private static Map getTransceiverBeanNamesByProtocol() {
	    return transceiverBeanNamesByProtocol;
	}
	
	private static void setTransceiverBeanNamesByProtocol(
	        Map transceiverBeanNamesByProtocol) {
	    ConfigurationConstants.transceiverBeanNamesByProtocol = transceiverBeanNamesByProtocol;
	}
}
