package gov.va.med.domain.service.messaging.encode.hl7.util;

import java.text.SimpleDateFormat; 

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.TS;

/**
 * HL7Helper
 *
 * @author Slava Uchitel
 * @version $Id: HL7Helper.java,v 1.12 2005/08/24 15:55:41 tom Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class HL7Helper 
{ 
    public static final int ID_SSN = 0;
    public static final int ID_ICN = 1;
    public static final int ID_DFN = 2;
    
    public static final String [] pidAuthority = {"USSSA", "USVHA", "USVHA"};
    public static final String [] pidType = {"SS", "NI", "PI"};
    
    protected static final String VA_FACILITY_TYPE = "VA FACILITY ID";
    
    public static String getMessageDateTime()
    {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssZ");
        return sdf.format(new java.util.Date());
    }
    
    /**
     * Returns a String from a specific repetition of a Field object at the specified location in the segment. 
	 * @param segment
	 * @param column - field number location in the segment
	 * @param rep - repetition index number of repeating field 
	 */ 	
    public static String getStringField(AbstractSegment segment,  
            							int column, 
            							int rep) 
    				throws HL7Exception {
    	Type type = getType(segment, column, rep);
    	if (type instanceof Varies) {
    		return  ((Varies)type).getData().toString(); 
    	}
    	if (type instanceof TS) {
    		return  ((TS)type).getValue(); 
    	}
    	if (type instanceof NM) {

    		return  ((NM)type).getValue(); 
    	}
    	throw new HL7Exception("Unsupported HL7 Type [" + type.getClass().getName() +
    			               "],  Please fix code  in HL7Helper.getStringField() to suppport");
    }
    
    /**
     * Returns a concatenated String from an array of all repeating Field objects at the specified location in the segment. 
     * Resulting String will contain repeating field values that are each concatenated with a new line character (\n).
     * @param segment
     * @param column - field number location in the segment
     */
	public static String getStringArray(AbstractSegment segment,  int column) 
					throws HL7Exception {
		Type[] types = getTypes(segment, column);
		StringBuffer buffer = new StringBuffer();
		
		for(int i = 0; i < types.length; i++) {
			buffer.append(getStringField(segment, column, i) + "\n");
		}
		return buffer.toString();
	}
    
    public static Varies getVaries(AbstractSegment segment,  
								   int column, 
								   int rep) throws HL7Exception {
        return (Varies)getType(segment, column, rep);
    }
    
    /**
	 * Returns a specific repetition of field at the specified repetition index.
	 * @param segment
	 * @param column - field number location in the segment
	 * @param rep - repetition index number of repeating field 
	 */ 	
    public static Type getType(AbstractSegment segment, int column, int rep)
			throws HL7Exception {
		return segment.getField(column, rep);
	}
    
    /**
	 * Returns an array of all repeating Field objects at the specified location in the segment.
	 * @param segment
	 * @param column - field number location in the segment
	 */
	public static Type[] getTypes(AbstractSegment segment,  
				   int column) throws HL7Exception {
	    	return segment.getField(column);
	}
    /**
     * Helper method that climbs the ancenstral tree of the Error's 
     * structure and returns either the first parent whose name is the 
     * segmentName provided or the entire message if not found o rif
     * the targetName is null.
     * <P>
     * Used to obtain the key to group related errors by logical record. 
     * @param structure the current position in the Message Strutcture tree
     * @param targetName the name of the struture of the root for this record or null
     */
    public static Structure climbTreeToStructure(Structure structure, String targetName) {
        if (structure.getName().equals(targetName)){
            return structure;
        }
        
        Structure parent = structure.getParent();
        String messageName = structure.getMessage().getName();
        
        while (!messageName.equals(parent.getName())) {
            if (parent.getName().equals(targetName)) {     
                return parent;
            }
            parent = parent.getParent(); //move up the ancenstral tree
        }
        return parent;  // whether or not it matches the name, it is all we have left to give
    }
} 
