package gov.va.med.domain.service.messaging.encode.hl7.util;

import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.environment.EndPoint;

/**
 * Wraps the paramaters to simplfiy encoding method signiatures. 
 * @author Slava Uchitel
 * @version $Id: HL7HeaderParameters.java,v 1.3 2005/06/01 19:46:19 joel.goldberg Exp $
 * @since MHV 2.0 <br>Apr 20, 2005
 */
public class HL7HeaderParameters implements MessagingConstants {
    
	private String fieldSeparator;
	private String delimiters; 
	private String event;
	private String trigger;
	private String messageStructure;
	private String srcStationNumber;
	private String srcDomain;
	private String srcApplication;
	private String dstStationNumber;
	private String dstDomain;
	private String dstApplication;
	private String systemType;
	private String messageControlId;
	private String acceptAcknowledgmentType;
	private String applicationAcknowledgmentType;
	
	/**
	 * 
	 */
	public HL7HeaderParameters()
	{
		super();
	}
    /**
     * Populates itself with all the known HL7 Encoding parameters in the 
     * EndPoint.  If additional parameters are needed, either change this class
     * or set them explictily on the the instance after creation.
     *   
     * @param endPoint containing the encodingParemeters
     */
    public HL7HeaderParameters(EndPoint endPoint){
        setSrcStationNumber(endPoint.getEncodingParameter(SENDING_FACILITY));
        setSrcDomain(endPoint.getEncodingParameter(SENDING_FACILITY_DOMAIN));
        setDstStationNumber(endPoint.getEncodingParameter(RECEIVING_FACILITY));
        setDstDomain(endPoint.getEncodingParameter(RECEIVING_FACILITY_DOMAIN));
        setSystemType(endPoint.getEncodingParameter(SYSTEM_TYPE));
        setSrcApplication(endPoint.getEncodingParameter(SENDING_APPLICATION));
        setDstApplication(endPoint.getEncodingParameter(RECEIVING_APPLICATION));
    }

	public HL7HeaderParameters(String fieldSeparator, String delimiters, 
            String event, String trigger, String messageStructure,
            String srcStationNumber, String srcDomain, String srcApplication,
            String dstStationNumber, String dstDomain, String dstApplication,
            String systemType, String messageControlId, 
            String acceptAcknowledgmentType, String applicationAcknowledgmentType) {
		super();
		setFieldSeparator(fieldSeparator);
		setDelimiters(delimiters); 
        setEvent(event);
        setTrigger(trigger);
        setMessageStructure(messageStructure);
        setSrcStationNumber(srcStationNumber);
        setSrcDomain(srcDomain);
        setSrcApplication(srcApplication);
        setDstStationNumber(dstStationNumber);
        setDstDomain(dstDomain);
        setDstApplication(dstApplication);
        setSystemType(systemType);
        setMessageControlId(messageControlId);
        setAcceptAcknowledgmentType(acceptAcknowledgmentType);
        setApplicationAcknowledgmentType(applicationAcknowledgmentType);
	}

	/**
	 * @param fieldSeparator The fieldSeparator to set.
	 */
	public void setFieldSeparator(String fieldSeparator) {
		this.fieldSeparator = fieldSeparator;
	}

	/**
	 * @return Returns the fieldSeparator.
	 */
	public String getFieldSeparator() {
		return fieldSeparator;
	}

	/**
	 * @param delimiters The delimiters to set.
	 */
	public void setDelimiters(String delimiters) {
		this.delimiters = delimiters;
	}

	/**
	 * @return Returns the delimiters.
	 */
	public String getDelimiters() {
		return delimiters;
	}

	/**
	 * @param event The event to set.
	 */
	public void setEvent(String event) {
		this.event = event;
	}

	/**
	 * @return Returns the event.
	 */
	public String getEvent() {
		return event;
	}

	/**
	 * @param trigger The trigger to set.
	 */
	public void setTrigger(String trigger) {
		this.trigger = trigger;
	}

	/**
	 * @return Returns the trigger.
	 */
	public String getTrigger() {
		return trigger;
	}

	/**
	 * @param messageStructure The messageStructure to set.
	 */
	public void setMessageStructure(String messageStructure) {
		this.messageStructure = messageStructure;
	}

	/**
	 * @return Returns the messageStructure.
	 */
	public String getMessageStructure() {
		return messageStructure;
	}

	/**
	 * @param srcStationNumber The srcStationNumber to set.
	 */
	public void setSrcStationNumber(String srcStationNumber) {
		this.srcStationNumber = srcStationNumber;
	}

	/**
	 * @return Returns the srcStationNumber.
	 */
	public String getSrcStationNumber() {
		return srcStationNumber;
	}

	/**
	 * @param srcDomain The srcDomain to set.
	 */
	public void setSrcDomain(String srcDomain) {
		this.srcDomain = srcDomain;
	}

	/**
	 * @return Returns the srcDomain.
	 */
	public String getSrcDomain() {
		return srcDomain;
	}

	/**
	 * @param srcApplication The srcApplication to set.
	 */
	public void setSrcApplication(String srcApplication) {
		this.srcApplication = srcApplication;
	}

	/**
	 * @return Returns the srcApplication.
	 */
	public String getSrcApplication() {
		return srcApplication;
	}

	/**
	 * @param dstStationNumber The dstStationNumber to set.
	 */
	public void setDstStationNumber(String dstStationNumber) {
		this.dstStationNumber = dstStationNumber;
	}

	/**
	 * @return Returns the dstStationNumber.
	 */
	public String getDstStationNumber() {
		return dstStationNumber;
	}

	/**
	 * @param dstDomain The dstDomain to set.
	 */
	public void setDstDomain(String dstDomain) {
		this.dstDomain = dstDomain;
	}

	/**
	 * @return Returns the dstDomain.
	 */
	public String getDstDomain() {
		return dstDomain;
	}

	/**
	 * @param dstApplication The dstApplication to set.
	 */
	public void setDstApplication(String dstApplication) {
		this.dstApplication = dstApplication;
	}

	/**
	 * @return Returns the dstApplication.
	 */
	public String getDstApplication() {
		return dstApplication;
	}

	/**
	 * @param systemType The systemType to set.
	 */
	public void setSystemType(String systemType) {
		this.systemType = systemType;
	}

	/**
	 * @return Returns the systemType.
	 */
	public String getSystemType() {
		return systemType;
	}

	/**
	 * @param messageControlId The messageControlId to set.
	 */
	public void setMessageControlId(String messageControlId) {
		this.messageControlId = messageControlId;
	}

	/**
	 * @return Returns the messageControlId.
	 */
	public String getMessageControlId() {
		return messageControlId;
	}

	/**
	 * @param acceptAcknowledgmentType The acceptAcknowledgmentType to set.
	 */
	public void setAcceptAcknowledgmentType(String acceptAcknowledgmentType) {
		this.acceptAcknowledgmentType = acceptAcknowledgmentType;
	}

	/**
	 * @return Returns the acceptAcknowledgmentType.
	 */
	public String getAcceptAcknowledgmentType() {
		return acceptAcknowledgmentType;
	}

	/**
	 * @param applicationAcknowledgmentType The applicationAcknowledgmentType to set.
	 */
	public void setApplicationAcknowledgmentType(String applicationAcknowledgmentType) {
		this.applicationAcknowledgmentType = applicationAcknowledgmentType;
	}

	/**
	 * @return Returns the applicationAcknowledgmentType.
	 */
	public String getApplicationAcknowledgmentType() {
		return applicationAcknowledgmentType;
	}

}
