package gov.va.med.domain.service.messaging.encode.hl7;

import gov.va.med.domain.service.messaging.MessagingConstants;

/**
 * VitalSignEncoder
 * This will encode and fill QBP_Q13 Vital Signs query by parameter message structure segments.
 * This query will generate a tabular response.
 *
 * @author Tom Cornils
 * @version $Id: VitalSignEncoder.java,v 1.5 2005/04/22 05:09:11 tom Exp $
 * @since MHV 2.0 <br>Mar 18, 2005
 */
public class VitalSignEncoder extends HL7TabularEncoder implements MessagingConstants {
	private static final String SUBJECT_AREA_NAME = "Vitals";
	private static final String[][] STRUCTURE = {
		{"IEN", "NM", "30"},
		{"Vital Type", "CE", "55"},
		{"Date/Time Vitals Taken", "TS", "26"},
		{"Measurement", "ST", "50"},
		{"Supplemental O2", "ST", "30"},
		{"Qualifier", "CE", "55"}
	};

	/*
	  message = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QBP^Q13^QBP_Q13|65810481154|P|2.4|||AL|NE
		  QPD|K13^Vitals^HL70471|123996-10|123996|Vitals|2000010100000|2004123124000
		  PID|||1001023456^^^USVHA&&0363^NI^VA FACILITY ID&442&L~1477^^^USVHA&&0363^PI^VA FACILITY ID&442&L~123994321^^^USSSA&&0363^SS^VA FACILITY ID&200MH&L||TEST^HEATHER^J
		  RDF|6|IEN^NM^30~Vital Type^CE^55~Date/Time Vitals Taken^TS^26~Measurement^ST^50~Supplemental O2^ST^30~Qualifier^CE^55
		  RCP|D";
	*/
	public String getSubjectArea() {
		return SUBJECT_AREA_NAME;
	}

	public String[][] getColumnStructure() {
		return STRUCTURE;
	}

	public int getQueryMode() {
		return QUERY_MODE_ASYNCHRONOUS;
	};

}
