package gov.va.med.domain.service.messaging.encode.hl7;

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.MessagingException;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7HeaderParameters;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7v24Helper;
import gov.va.med.domain.service.messaging.environment.EndPoint;
import gov.va.med.domain.service.messaging.parse.HL7MessageMetadata;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.group.MFK_M05_MFEMFA;
import ca.uhn.hl7v2.model.v24.group.MFN_M05_MFELOCLCHLRLLDPLCHLCC;
import ca.uhn.hl7v2.model.v24.message.MFK_M05;
import ca.uhn.hl7v2.model.v24.message.MFN_M05;
import ca.uhn.hl7v2.model.v24.segment.MFA;
import ca.uhn.hl7v2.model.v24.segment.MFE;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;

/**
 * UpdatePatientFacilitiesApplicationAckEncoder
 * 
 * @author Slava Uchitel
 * @version $Id: UpdatePatientFacilitiesApplicationAckEncoder.java,v 1.1
 *          2005/06/09 15:04:45 slava.uchitel Exp $
 * @since MHV 2.1 <br>
 *        June 9, 2005
 */
public class UpdatePatientFacilitiesApplicationAckEncoder extends
        HL7ApplicationAckEncoder
{
    //Do not change next two lines, MPI specific.
    private static final String FIELD_SEPARATOR = "^";
	private static final String DELIMITERS = "~|\\&";

    protected void fillMSHSegment(MSH msh, HL7MessageMetadata metaData)
            throws DataTypeException
    {
        HL7HeaderParameters params = buildHL7HeaderParameters(metaData);
        params.setFieldSeparator(FIELD_SEPARATOR);
        params.setDelimiters(DELIMITERS);
        HL7v24Helper.fillMSHSegment(msh, params);
    }

    protected HL7HeaderParameters buildHL7HeaderParameters(
            HL7MessageMetadata metaData)
    {
        HL7HeaderParameters params = super.buildHL7HeaderParameters(metaData);
        String messageType = "MFK";
        params.setEvent(messageType);
        params.setTrigger(metaData.getTriggerEvent());
        params.setMessageStructure("");
        return params;
    }

    protected Message createMessage(HL7MessageMetadata metaData)
            throws EncodingNotSupportedException, HL7Exception
    {
        MFK_M05 ack = new MFK_M05();
        MSH msh = ack.getMSH();
        fillMSHSegment(msh, metaData);
        MSA msa = ack.getMSA();
        msa.getAcknowledgementCode().setValue("AA");
        msa.getMessageControlID().setValue(metaData.getMessageContolId());
        msa.getTextMessage().setValue("0");
        // Confirmed with Danny Reed on 06/10/2005 that they can request
        // detailed application ack for MFN-M05 using mfi field 6 
        // (Response Level Code)
        String[] segments = metaData.getMessage().split("\r");
        String fieldDelimiter = segments[0].substring(3, 4);
        String[] mfiFields = segments[1].split("\\"+fieldDelimiter);
        String responseLevelCode = mfiFields[6];
        if (responseLevelCode
                .equalsIgnoreCase(MessagingConstants.ALWAYS_ACKNOWLEDGE))
        {
            MFN_M05 mfn_m05 = (MFN_M05) (new PipeParser().parse(metaData
                    .getMessage()));
            int mfeCount = mfn_m05.getMFN_M05_MFELOCLCHLRLLDPLCHLCCReps();
            for (int i=0; i<mfeCount; i++)
            {
                MFN_M05_MFELOCLCHLRLLDPLCHLCC struct1 = mfn_m05.getMFN_M05_MFELOCLCHLRLLDPLCHLCC(i);
                MFE srcMfe = struct1.getMFE();
                MFK_M05_MFEMFA struct2 = ack.getMFEMFA(i);
                MFE dstMfe = struct2.getMFE();
                MFA dstMfa = struct2.getMFA();
                dstMfa.getRecordLevelEventCode().setValue(srcMfe.getRecordLevelEventCode().getValue());
                dstMfa.getMFNRecordLevelErrorReturn().getIdentifier().setValue("S");
                dstMfa.getMFNControlID().setValue(srcMfe.getMFNControlID().getValue());
                
                ID srcEventCode = srcMfe.getRecordLevelEventCode();
                dstMfe.getRecordLevelEventCode().setValue(srcEventCode.getValue());
                
                ST srcId = srcMfe.getMFNControlID();
                dstMfe.getMFNControlID().setValue(srcId.getValue());
                
                TS srcEffectiveDateTime = srcMfe.getEffectiveDateTime();
                dstMfe.getEffectiveDateTime().setValue(srcEffectiveDateTime.getValue());
                
                Varies srcPrimaryKeyValue = srcMfe.getPrimaryKeyValueMFE(0); 
                dstMfe.getPrimaryKeyValueMFE(0).setData(srcPrimaryKeyValue.getData());    
                
                ID srcPrimaryKeyValueType = srcMfe.getPrimaryKeyValueType(0);
                dstMfe.getPrimaryKeyValueType(0).setValue(srcPrimaryKeyValueType.getValue());
            }
        }
        return ack;
    }

    public Object encode(IPayload payload, EndPoint ep)
            throws MessagingException
    {
        HL7MessageMetadata metaData = (HL7MessageMetadata) payload;
        try
        {
            Message ack = createMessage(metaData);
            Parser parser = new PipeParser();
            return parser.encode(ack);
        }
        catch (DataTypeException e)
        {
            String msg = "Failed while encoding a request message into HL7.";
            getLogger().error(msg + ". Error: " + e.getMessage());
            throw new MessagingException(msg);
        }
        catch (HL7Exception e)
        {
            String msg = "Failed while encoding a request message into HL7.";
            getLogger().error(msg + ". Error: " + e.getMessage());
            throw new MessagingException(msg);
        }
    }
}
