package gov.va.med.domain.service.messaging.encode.hl7;

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.model.Patient;
import gov.va.med.domain.service.messaging.MessagingException;
import gov.va.med.domain.service.messaging.encode.hl7.structure.QBP_Q13_RXP;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7HeaderParameters;
import gov.va.med.domain.service.messaging.environment.EndPoint;

import java.util.Date;

import org.springframework.stereotype.Component;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;

/**
 * RxCompleteListEncoder
 * This will encode and fill QBP_Q13 Prescription Profile query by parameter message structure segments.
 * This query will generate a tabular response of all current and historical prescriptions, using an optional date range.
 * A specific list of prescription numbers is not permitted.
 *
 * @author Slava Uchitel
 * @version $Id: RxCompleteListEncoder.java,v 1.6 2005/08/12 18:14:29 tom Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
@Component
public class RxCompleteListEncoder extends RxProfileEncoder {

	private static final String SUBJECT_AREA_NAME = "Prescriptions";

	/*
	  message = "MSH|^~\&|MHV EVAULT|200MH^ISA-UCHITELSLAVA.VHA.MED.DNS   ^DNS|MHV VISTA|658^TEST.HEVET.MED.DNS   ^DNS|20050202152556-0500||QBP^Q13^QBP_Q13|1107375956189151861|T|2.4\r"+
	        "QPD|Q13^Prescriptions^HL70471|0-Prescriptions|0|Prescriptions\r"+
	        "PID|||111223456^^^USSSA^SS\r"+
	        "RCP|I\r"+
	        "RDF|18|Prescription Number^NM^32~IEN^NM^30~Drug Name^ST^40~Issue Date/Time^TS^26~Last Fill Date^TS^26~Release Date/Time^TS^26~Expiration or Cancel Date^TS^26~Status^ST^20~Quantity^NM^3~Days Supply^NM^3~Number of Refills^NM^3~Provider^XPN^60~Place Order Number^ST^3~Mail/Window^ST^1~Division^NM^3~MHV Request Status^NM^3~Remarks^ST^75~SIG^TX^1024\r";
	*/

	protected QBP_Q13_RXP createQueryMessage(Patient patient, String[] rxNumbers,
	                                         HL7HeaderParameters params,
	                                         Date fromDateLimit, Date toDateLimit)
	    throws DataTypeException, HL7Exception {
		if (getLogger().isDebugEnabled())
			getLogger().debug("In side RxCompleteListEncoder - createQueryMessage");
		//if(rxNumbers != null && rxNumbers.length > 0)
		//	throw new HL7Exception("Rx list with values is not permitted in payload for " + this.getClass().getName());

		QBP_Q13_RXP qbp_q13 = super.createQueryMessage(patient, rxNumbers, params,
		                                               fromDateLimit, toDateLimit);

		return qbp_q13;
	}

	public Object encode(IPayload payload, EndPoint endPoint)
	    throws MessagingException {
		if (getLogger().isDebugEnabled())
			getLogger().debug("In side RxCompleteListEncoder - encode");
		return super.encode(payload, endPoint);
		/*
		RxRefillPayload rxRefillPayload = (RxRefillPayload)payload;
	    Patient patient = rxRefillPayload.getPatient();
	    Prescription[] prescriptions = rxRefillPayload.getPrescriptionList();

	    String[] rxNumbers = new String[0];
	    if (prescriptions != null) {
	        rxNumbers = new String[prescriptions.length];
	        for (int i=0; i<prescriptions.length; i++) {
	            rxNumbers[i] = String.valueOf(prescriptions[i].getPrescriptionNum());
	        }
	    }

	    try {
		    HL7HeaderParameters params = new HL7HeaderParameters();
	        params.setSrcStationNumber(endPoint.getEncodingParameter(MessagingConstants.SENDING_FACILITY));
	        params.setSrcDomain(endPoint.getEncodingParameter(MessagingConstants.SENDING_FACILITY_DOMAIN));
	        params.setSrcApplication(endPoint.getEncodingParameter(MessagingConstants.SENDING_APPLICATION));
	        params.setDstStationNumber(endPoint.getEncodingParameter(MessagingConstants.RECEIVING_FACILITY));
	        params.setDstDomain(endPoint.getEncodingParameter(MessagingConstants.RECEIVING_FACILITY_DOMAIN));
	        params.setDstApplication(endPoint.getEncodingParameter(MessagingConstants.RECEIVING_APPLICATION));
	        params.setSystemType(endPoint.getEncodingParameter(MessagingConstants.SYSTEM_TYPE));
	        params.setMessageControlId(rxRefillPayload.getRequestId());

		    QBP_Q13_RXP qbp_q13 =
		        this.createQueryMessage(patient,
		                                rxNumbers,
		                                params,
											rxRefillPayload.getFromDate(),
		                                rxRefillPayload.getToDate());
		    //Parser parser = (Parser) new PipeParser();
		    //return parser.encode(qbp_q13);
		    return qbp_q13.er7Encode();
	    } catch (DataTypeException e) {
		    String message="Failed while encoding a request message into HL7.";
		    getLogger().error(message + ". Error: " + e.getMessage());
		    throw new MessagingException(message);
	    } catch (HL7Exception e) {
		    String message="Failed while encoding a request message into HL7.";
		    getLogger().error(message + ". Error: " + e.getMessage());
		    throw new MessagingException(message);
	    }
	    */
	}

	public String getSubjectArea() {
		return SUBJECT_AREA_NAME;
	}

	public int getQueryMode() {
		return QUERY_MODE_SYNCHRONOUS;
	};
}
