package gov.va.med.domain.service.messaging.encode.hl7;

/**
 * RadiologyEncoder
 * This will encode and fill QBP_Q13 Radiology query by parameter message structure segments.
 * This query will generate a tabular response.
 *
 * @author Tom Cornils
 * @version $Id: RadiologyEncoder.java,v 1.1 2005/06/07 17:42:09 tom Exp $
 * @since MHV 2.0 <br>Mar 18, 2005
 */
public class RadiologyEncoder extends HL7TabularEncoder {
	private static final String SUBJECT_AREA_NAME = "Radiology";
	private static final String[][] STRUCTURE = {
            {"IEN", "NM", "30"},
            {"Exam Date/Time", "TS", "26"},
            {"Procedure", "ST", "60"},
            {"Last Updated", "TS", "10"},
            {"Report Status", "ST", "30"},
            {"Report Text", "TX", "65535"},
            {"Impression Text", "TX", "65535"}
           };                       

	/*
	  message = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QBP^Q13^QBP_Q13|65810481154|P|2.4|||AL|NE
	  	QPD|K13^Radiology^HL70471|123996-6|123996|Radiology|2000010100000|2004123124000
	  	PID|||1001023456^^^USVHA&&0363^NI^VA FACILITY ID&442&L~1477^^^USVHA&&0363^PI^VA FACILITY ID&442&L~123994321^^^USSSA&&0363^SS^VA FACILITY ID&200MH&L||TEST^HEATHER^J
	  	RDF|7|IEN^NM^30~Exam Date/Time^TS^26~Procedure^ST^60~Last Updated^TS^10~Report Status^ST^30~Report Text^TX^65535~Impression Text^TX^65535
	  	RCP|D";
	*/
	public String getSubjectArea() {
		return SUBJECT_AREA_NAME;
	}

	public String[][] getColumnStructure() {
		return STRUCTURE;
	}

	public int getQueryMode() {
		return QUERY_MODE_ASYNCHRONOUS;
	};

}
