package gov.va.med.domain.service.messaging.encode.hl7;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v24.message.QRY_R02;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.model.v24.segment.QRF;

/**
 * PathologyLabEncoder
 * This will encode QRY_R02 Pathology Lab original style query segments.
 *
 * @author Tom Cornils
 * @version $Id: PathologyLabEncoder.java,v 1.2 2005/06/19 15:45:02 tom Exp $
 * @since MHV 2.0 <br>Mar 18, 2005
 */
public class PathologyLabEncoder extends HL7OriginalStyleEncoder
{ 
    private static final String SUBJECT_AREA_NAME = "Pathology";
    private static final String SUBJECT_FILTER = "RES";        
	protected static final String EVENT = "QRY";
	protected static final String TRIGGER = "R02";    
	protected static final String MESSAGE_STRUCTURE = "QRY_R02";    

    /*
      message = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QRY^R02^QRY_R02|65810481154|P|2.4|||AL|NE
      	QRD|20040328134602.1234+0600|R|D|123996-5||||1001023456^TEST^HEATHER^J^^^^^USVHA&&0363^^^^NI^VA FACILITY ID&442&L^^^&20040328134602.1234+0600~1477^TEST^HEATHER^J^^^^^USVHA&&0363^^^^PI^VA FACILITY ID&442&L~123994321^TEST^HEATHER^J^^^^^USSSA&&0363^^^^SS^VA FACILITY ID&200MH&L|RES^^HL70048|Pathology
      	QRF|RES|20040328134602.1234+0600|20040328134602.1234+0600";
    */

    public String getEvent() {
        return  EVENT;
    }   
    
    public String getTrigger() {
        return  TRIGGER;
    }   
    
    public String getMessageStructure() {
        return  MESSAGE_STRUCTURE;
    }   
    
    public String getSubjectArea() {
        return  SUBJECT_AREA_NAME;
    }     

    public String getSubjectFilter() {
        return  SUBJECT_FILTER;
    }   
    
    public int getQueryMode() {
        return QUERY_MODE_ASYNCHRONOUS;
    }
    
	public Message getQueryMessage() {
		return new QRY_R02();
	}
	
	public MSH getMsh(Message message) {
		QRY_R02 msg = (QRY_R02)message;
		MSH msh = msg.getMSH();
		return msh;
	}	
	
	public QRD getQrd(Message message) {
		QRY_R02 msg = (QRY_R02)message;
		QRD qrd = msg.getQRD();
		return qrd;
	}	
	
	public QRF getQrf(Message message) {
		QRY_R02 msg = (QRY_R02)message;
		QRF qrf = msg.getQRF();
		return qrf;
	}		
} 
