package gov.va.med.domain.service.messaging.encode.hl7;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v24.message.VXQ_V01;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.model.v24.segment.QRF;

/**
 * ImmunizationEncoder
 * This will encode VXQ_V01 Immunization original style query segments.
 *
 * @author Tom Cornils
 * @version $Id: ImmunizationEncoder.java,v 1.2 2005/06/19 15:45:02 tom Exp $
 * @since MHV 2.0 <br>Mar 18, 2005
 */
public class ImmunizationEncoder extends HL7OriginalStyleEncoder
{ 
    private static final String SUBJECT_AREA_NAME = "Immunizations";
    private static final String SUBJECT_FILTER = "VXI";        
	protected static final String EVENT = "VXQ";
	protected static final String TRIGGER = "V01";    
	protected static final String MESSAGE_STRUCTURE = "VXQ_V01";    

    /*
      message = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||VXQ^V01^VXQ_V01|65810481154|P|2.4|||AL|NE
      	QRD|20040328134602.1234+0600|R|D|123996-22||||1001023456^TEST^HEATHER^J^^^^^USVHA&&0363^^^^NI^VA FACILITY ID&442&L^^^&20040328134602.1234+0600~1477^TEST^HEATHER^J^^^^^USVHA&&0363^^^^PI^VA FACILITY ID&442&L~123994321^TEST^HEATHER^J^^^^^USSSA&&0363^^^^SS^VA FACILITY ID&200MH&L|VXI^^HL70048|Immunizations
      	QRF|VXI|20040328134602.1234+0600|20040328134602.1234+0600";
    */

    public String getEvent() {
        return  EVENT;
    }   
    
    public String getTrigger() {
        return  TRIGGER;
    }   
    
    public String getMessageStructure() {
        return  MESSAGE_STRUCTURE;
    }   
    
    public String getSubjectArea() {
        return  SUBJECT_AREA_NAME;
    }     

    public String getSubjectFilter() {
        return  SUBJECT_FILTER;
    }   
    
    public int getQueryMode() {
        return QUERY_MODE_ASYNCHRONOUS;
    }
    
	public Message getQueryMessage() {
		return new VXQ_V01();
	}
	
	public MSH getMsh(Message message) {
		VXQ_V01 msg = (VXQ_V01)message;
		MSH msh = msg.getMSH();
		return msh;
	}	
	
	public QRD getQrd(Message message) {
		VXQ_V01 msg = (VXQ_V01)message;
		QRD qrd = msg.getQRD();
		return qrd;
	}	
	
	public QRF getQrf(Message message) {
		VXQ_V01 msg = (VXQ_V01)message;
		QRF qrf = msg.getQRF();
		return qrf;
	}		
} 
