package gov.va.med.domain.service.messaging.encode.hl7;

/**
 * HealthReminderEncoder
 * This will encode and fill QBP_Q13 Health Reminder query by parameter message structure segments.
 * This query will generate a tabular response.
 *
 * @author John Nitz
 * @version $Id: HealthReminderEncoder.java,v 1.2 2005/07/27 21:03:17 tom Exp $
 * @since MHV 2.0 <br>Jun , 2005
 */
public class HealthReminderEncoder extends HL7TabularEncoder
{ 
    private static final String SUBJECT_AREA_NAME = "Reminders";
    private static final String[][] STRUCTURE = {
                             {"IEN", "NM", "30"},
                             {"Internal Name", "ST", "64"},
                             {"Subject", "ST", "35"},
                             {"Due Date", "TS", "26"},
                             {"Date Last Done", "TS", "26"},
                             {"Status", "ST", "20"},
                             {"Brief Summary", "TX", "4000"},
                             {"Full Summary", "TX", "65535"},
							 {"Web Link Text", "ST", "60"},
							 {"Web Site URL", "ST", "128"},
							 {"Web Site Description", "TX", "65535"}
                            };                              

    /*
      message = "MSH|^~\&|EVET EVAULT|200HV^MHV.MED.DNS   ^DNS|EVET VISTA|442^CHY7D.DNS        .MED.DNS   ^DNS|2004012819021||QBP^Q13^QBP_Q13|65810481154|P|2.4|||AL|NE
      QPD|K13^Reminders^HL70471|123996-19|123996|Reminders|2000010100000|2004123124000
      PID|||1001023456^^^USVHA&&0363^NI^VA FACILITY ID&442&L~1477^^^USVHA&&0363^PI^VA FACILITY ID&442&L~123994321^^^USSSA&&0363^SS^VA FACILITY ID&200MH&L||TEST^HEATHER^J
      RDF|7|IEN^NM^30~Subject^ST^35~Due Date^TS^26~Date Last Done^TS^26~Status^ST^20~Brief Summary^TX^4000~Full Summary^TX^65535
      RCP|D
    */
    public String getSubjectArea() {
        return  SUBJECT_AREA_NAME;
    }     

    public String[][] getColumnStructure()
    {
        return STRUCTURE;
    }
    
    public int getQueryMode() {
        return QUERY_MODE_ASYNCHRONOUS;
    };    
    
} 
