package gov.va.med.domain.service.messaging.encode.hl7;

import gov.va.med.domain.service.messaging.MessagingConstants;
import gov.va.med.domain.service.messaging.encode.hl7.util.HL7HeaderParameters;
import gov.va.med.domain.service.messaging.parse.HL7MessageMetadata;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v24.message.ACK;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;

/**
 * HL7ApplicationAckEncoder
 *
 * @author Slava Uchitel
 * @version $Id: GenericApplicationAckEncoder.java,v 1.6 2005/08/03 20:18:08 joel.goldberg Exp $
 * @since MHV 2.1 <br>Apr 3, 2005
 */
public class GenericApplicationAckEncoder extends HL7ApplicationAckEncoder {
	
    protected HL7HeaderParameters buildHL7HeaderParameters(HL7MessageMetadata metaData) {
		HL7HeaderParameters params = super.buildHL7HeaderParameters(metaData);
		String ack = "ACK";
		String acceptAcknowledgmentType = MessagingConstants.ALWAYS_ACKNOWLEDGE;
        String applicationAcknowledgmentType = MessagingConstants.NEVER_ACKNOWLEDGE;
		params.setEvent(ack);
		params.setMessageStructure(ack);
		return params;
	}

	protected Message createMessage(HL7MessageMetadata metaData)
	    throws DataTypeException 
	{
	    boolean isUnknownFunctionNack = 
	        metaData.getFunctionName().equals(metaData.SEND_APPLICATION_ACK_FUNCTION);
	    ACK ack = new ACK();
		MSH msh = ack.getMSH();
		fillMSHSegment(msh, metaData);
		MSA msa = ack.getMSA();
		msa.getAcknowledgementCode().setValue(isUnknownFunctionNack?"AR":"AA");
		msa.getTextMessage().setValue("Can't process this message.");
		msa.getMessageControlID().setValue(metaData.getMessageContolId());
		if (isUnknownFunctionNack)
		{
		    if (metaData.getTriggerEvent() == null || 
		        metaData.getTriggerEvent().trim().length()!=3)
			{
			    msa.getErrorCondition().getIdentifier().setValue("200");
				msa.getErrorCondition().getText().setValue("The Message Type is not supported");
			} 
			else 
			{
			    msa.getErrorCondition().getIdentifier().setValue("201");
				msa.getErrorCondition().getText().setValue("The Event Code is not supported.");
			}
		}
		return ack;
	}
}
